/*
 * Decompiled with CFR 0.152.
 */
package com.xnx3.wangmarket.admin.service.impl;

import com.xnx3.DateUtil;
import com.xnx3.StringUtil;
import com.xnx3.j2ee.dao.SqlDAO;
import com.xnx3.j2ee.shiro.ShiroFunc;
import com.xnx3.j2ee.util.SafetyUtil;
import com.xnx3.wangmarket.admin.cache.GenerateHTML;
import com.xnx3.wangmarket.admin.entity.News;
import com.xnx3.wangmarket.admin.entity.NewsData;
import com.xnx3.wangmarket.admin.entity.Site;
import com.xnx3.wangmarket.admin.entity.SiteColumn;
import com.xnx3.wangmarket.admin.service.SiteColumnService;
import com.xnx3.wangmarket.admin.util.SessionUtil;
import com.xnx3.wangmarket.admin.vo.SiteColumnTreeVO;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="columnService")
public class SiteColumnServiceImpl
implements SiteColumnService {
    @Resource
    private SqlDAO sqlDAO;

    @Override
    public List<SiteColumn> findBySiteid(int siteid) {
        return this.sqlDAO.findBySqlQuery("SELECT * FROM site_column WHRER siteid = " + siteid + " ORDER BY rank ASC", SiteColumn.class);
    }

    @Override
    public void resetColumnRankAndJs(Site site) {
        List list = this.sqlDAO.findBySqlQuery("SELECT * FROM site_column WHERE siteid = " + site.getId() + " AND used = " + SiteColumn.USED_ENABLE + " ORDER BY rank ASC", SiteColumn.class);
        String rankString = "";
        for (int i = 0; i < list.size(); ++i) {
            String id = ((SiteColumn)list.get(i)).getId() + "";
            rankString = rankString.length() == 0 ? id : rankString + "," + id;
        }
        new com.xnx3.wangmarket.admin.cache.Site().siteColumnRank(site, rankString);
        new com.xnx3.wangmarket.admin.cache.Site().siteColumn(list, site);
    }

    @Override
    public List<SiteColumnTreeVO> getSiteColumnTreeVOByCache() {
        SiteColumnTreeVO vo;
        SiteColumn sc;
        Map<Integer, SiteColumn> siteColumnMap = this.getSiteColumnMapByCache();
        ArrayList<SiteColumnTreeVO> siteColumnTreeVOList = new ArrayList<SiteColumnTreeVO>();
        for (Map.Entry<Integer, SiteColumn> entry : siteColumnMap.entrySet()) {
            sc = entry.getValue();
            if (sc.getParentid() != null && sc.getParentid() != 0 || sc.getParentCodeName() != null && sc.getParentCodeName().length() != 0) continue;
            vo = new SiteColumnTreeVO();
            vo.setLevel(1);
            vo.setList(new ArrayList<SiteColumnTreeVO>());
            vo.setSiteColumn(sc);
            siteColumnTreeVOList.add(vo);
        }
        Collections.sort(siteColumnTreeVOList, new Comparator<SiteColumnTreeVO>(){

            @Override
            public int compare(SiteColumnTreeVO arg0, SiteColumnTreeVO arg1) {
                return arg0.getSiteColumn().getRank().compareTo(arg1.getSiteColumn().getRank());
            }
        });
        block1: for (Map.Entry<Integer, SiteColumn> entry : siteColumnMap.entrySet()) {
            sc = entry.getValue();
            if ((sc.getParentid() == null || sc.getParentid() <= 0) && (sc.getParentCodeName() == null || sc.getParentCodeName().length() <= 0)) continue;
            vo = new SiteColumnTreeVO();
            vo.setLevel(1);
            vo.setList(new ArrayList<SiteColumnTreeVO>());
            vo.setSiteColumn(sc);
            for (int j = 0; j < siteColumnTreeVOList.size(); ++j) {
                if (!((SiteColumnTreeVO)((Object)siteColumnTreeVOList.get(j))).getSiteColumn().getCodeName().equals(sc.getParentCodeName())) continue;
                ((SiteColumnTreeVO)((Object)siteColumnTreeVOList.get(j))).getList().add(vo);
                continue block1;
            }
        }
        for (int j = 0; j < siteColumnTreeVOList.size(); ++j) {
            SiteColumnTreeVO vo2 = (SiteColumnTreeVO)((Object)siteColumnTreeVOList.get(j));
            if (vo2.getList() == null || vo2.getList().size() <= 0) continue;
            List<SiteColumnTreeVO> list = vo2.getList();
            Collections.sort(list, new Comparator<SiteColumnTreeVO>(){

                @Override
                public int compare(SiteColumnTreeVO arg0, SiteColumnTreeVO arg1) {
                    return arg0.getSiteColumn().getRank().compareTo(arg1.getSiteColumn().getRank());
                }
            });
        }
        return siteColumnTreeVOList;
    }

    @Override
    public void updateSiteColumnByCache(SiteColumn siteColumn) {
        Map<Integer, SiteColumn> siteColumnMap = this.getSiteColumnMapByCache();
        siteColumnMap.put(siteColumn.getId(), siteColumn);
        SessionUtil.setSiteColumnMap(siteColumnMap);
    }

    @Override
    public SiteColumn getSiteColumnByCache(int siteColumnId) {
        return this.getSiteColumnMapByCache().get(siteColumnId);
    }

    @Override
    public Map<Integer, SiteColumn> getSiteColumnMapByCache() {
        Map<Integer, SiteColumn> siteColumnMap = SessionUtil.getSiteColumnMap();
        if (siteColumnMap == null) {
            siteColumnMap = new HashMap<Integer, SiteColumn>();
            Site site = SessionUtil.getSite();
            List siteColumnList = this.sqlDAO.findBySqlQuery("SELECT * FROM site_column WHERE siteid = " + site.getId() + " ORDER BY rank ASC", SiteColumn.class);
            for (int i = 0; i < siteColumnList.size(); ++i) {
                SiteColumn sc = (SiteColumn)siteColumnList.get(i);
                siteColumnMap.put(sc.getId(), sc);
            }
        }
        return siteColumnMap;
    }

    @Override
    public void deleteSiteColumnByCache(int siteColumnId) {
        Map<Integer, SiteColumn> siteColumnMap = this.getSiteColumnMapByCache();
        siteColumnMap.remove(siteColumnId);
        SessionUtil.setSiteColumnMap(siteColumnMap);
    }

    @Override
    public List<SiteColumn> getSiteColumnListByCache() {
        Map<Integer, SiteColumn> map = this.getSiteColumnMapByCache();
        ArrayList<SiteColumn> list = new ArrayList<SiteColumn>();
        for (Map.Entry<Integer, SiteColumn> entry : map.entrySet()) {
            list.add(entry.getValue());
        }
        return list;
    }

    @Override
    public void createNonePage(SiteColumn siteColumn, Site site, boolean updateName) {
        News news = (News)this.sqlDAO.findAloneBySqlQuery("SELECT * FROM news WHERE cid = " + siteColumn.getId(), News.class);
        if (news == null) {
            news = new News();
            news.setAddtime(DateUtil.timeForUnix10());
            news.setCid(siteColumn.getId());
            news.setCommentnum(0);
            news.setIntro(SafetyUtil.filter((String)siteColumn.getName()));
            news.setOpposenum(0);
            news.setReadnum(0);
            news.setSiteid(siteColumn.getSiteid());
            news.setStatus(News.STATUS_NORMAL);
            news.setTitle(news.getIntro());
            news.setTitlepic(StringUtil.filterXss((String)siteColumn.getIcon()));
            news.setType(News.TYPE_PAGE);
            news.setUserid(ShiroFunc.getUser().getId());
            this.sqlDAO.save((Object)news);
            if (news.getId() > 0) {
                NewsData newsData = new NewsData();
                newsData.setId(news.getId());
                newsData.setText(news.getTitle());
                this.sqlDAO.save((Object)newsData);
                GenerateHTML gh = new GenerateHTML(site);
                gh.generateViewHtml(site, news, siteColumn, news.getTitle());
            }
        } else if (updateName) {
            news.setTitle(SafetyUtil.filter((String)siteColumn.getName()));
            this.sqlDAO.save((Object)news);
            NewsData newsData = (NewsData)this.sqlDAO.findById(NewsData.class, (Object)news.getId());
            GenerateHTML gh = new GenerateHTML(site);
            gh.generateViewHtml(site, news, siteColumn, newsData.getText());
        }
    }

    @Override
    public void refreshCache() {
        SessionUtil.setSiteColumnMap(null);
        this.getSiteColumnMapByCache();
    }
}

