/*
 * Decompiled with CFR 0.152.
 */
package com.xnx3.wangmarket.admin.service.impl;

import com.xnx3.FileUtil;
import com.xnx3.j2ee.dao.SqlDAO;
import com.xnx3.j2ee.util.AttachmentUtil;
import com.xnx3.j2ee.util.ConsoleUtil;
import com.xnx3.j2ee.util.Page;
import com.xnx3.j2ee.util.SystemUtil;
import com.xnx3.wangmarket.admin.Func;
import com.xnx3.wangmarket.admin.bean.NewsDataBean;
import com.xnx3.wangmarket.admin.cache.GenerateHTML;
import com.xnx3.wangmarket.admin.cache.Template;
import com.xnx3.wangmarket.admin.cache.TemplateCMS;
import com.xnx3.wangmarket.admin.entity.News;
import com.xnx3.wangmarket.admin.entity.NewsData;
import com.xnx3.wangmarket.admin.entity.Site;
import com.xnx3.wangmarket.admin.entity.SiteColumn;
import com.xnx3.wangmarket.admin.service.NewsService;
import com.xnx3.wangmarket.admin.service.TemplateService;
import com.xnx3.wangmarket.admin.util.SessionUtil;
import com.xnx3.wangmarket.admin.util.TemplateUtil;
import com.xnx3.wangmarket.admin.vo.NewsVO;
import com.xnx3.wangmarket.admin.vo.bean.NewsInit;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import net.sf.json.JSONObject;
import org.springframework.stereotype.Service;
import org.springframework.ui.Model;

@Service(value="newsService")
public class NewsServiceImpl
implements NewsService {
    @Resource
    private SqlDAO sqlDAO;
    @Resource
    private TemplateService templateService;

    @Override
    public void generateListHtml(Site site, SiteColumn siteColumn, List<News> newsList, HttpServletRequest request) {
        int count = newsList.size();
        Page page = new Page(count, 12);
        page.setUrlByStringUrl("");
        String listHtml = FileUtil.read((String)(SystemUtil.getProjectPath() + "/static/template/" + site.getTemplateId() + "/" + (siteColumn.getType() == SiteColumn.TYPE_NEWS ? "news" : "newsimage") + "_list.html"));
        String listItem = FileUtil.read((String)(SystemUtil.getProjectPath() + "/static/template/" + site.getTemplateId() + "/module/" + (siteColumn.getType() == SiteColumn.TYPE_NEWS ? "news" : "newsimage") + "_list_item.html"));
        GenerateHTML gh = new GenerateHTML(site);
        listHtml = gh.assemblyCommon(listHtml);
        listHtml = gh.replacePublicTag(listHtml);
        for (int i = 1; i <= page.getLastPageNumber() && count >= 0; ++i) {
            page.setCurrentPageNumber(i);
            String currentListHtml = this.generateListHtml(listHtml, listItem, page, siteColumn, count, newsList, site, false);
            gh.generateListHtml(currentListHtml, siteColumn, i);
        }
    }

    @Override
    public void generateListHtml(Site site, SiteColumn siteColumn) {
        List list = this.sqlDAO.findBySqlQuery("SELECT * FROM news WHERE cid = " + siteColumn.getId() + " AND status = " + News.STATUS_NORMAL, News.class);
        int count = list.size();
        Page page = new Page(count, 12);
        page.setUrlByStringUrl("");
        String listHtml = FileUtil.read((String)(SystemUtil.getProjectPath() + "/static/template/" + site.getTemplateId() + "/" + (siteColumn.getType() == SiteColumn.TYPE_NEWS ? "news" : "newsimage") + "_list.html"));
        String listItem = FileUtil.read((String)(SystemUtil.getProjectPath() + "/static/template/" + site.getTemplateId() + "/module/" + (siteColumn.getType() == SiteColumn.TYPE_NEWS ? "news" : "newsimage") + "_list_item.html"));
        GenerateHTML gh = new GenerateHTML(site);
        listHtml = gh.assemblyCommon(listHtml);
        listHtml = gh.replacePublicTag(listHtml);
        for (int i = 1; i <= page.getLastPageNumber() && count >= 0; ++i) {
            page.setCurrentPageNumber(i);
            String currentListHtml = this.generateListHtml(listHtml, listItem, page, siteColumn, count, list, site, false);
            gh.generateListHtml(currentListHtml, siteColumn, i);
        }
    }

    @Override
    public String generateListHtml(Page page, SiteColumn siteColumn, int count, List<News> list, Site site) {
        String listHtml = FileUtil.read((String)(SystemUtil.getProjectPath() + "/static/template/" + site.getTemplateId() + "/" + (siteColumn.getType() == SiteColumn.TYPE_NEWS ? "news" : "newsimage") + "_list.html"));
        String listItem = FileUtil.read((String)(SystemUtil.getProjectPath() + "/static/template/" + site.getTemplateId() + "/module/" + (siteColumn.getType() == SiteColumn.TYPE_NEWS ? "news" : "newsimage") + "_list_item.html"));
        GenerateHTML gh = new GenerateHTML(site);
        gh.setEditMode(true);
        listHtml = gh.assemblyCommon(listHtml);
        listHtml = gh.replacePublicTag(listHtml);
        return this.generateListHtml(listHtml, listItem, page, siteColumn, count, list, site, true);
    }

    private String generateListHtml(String listHtml, String listItem, Page page, SiteColumn siteColumn, int count, List<News> list, Site site, boolean edit) {
        GenerateHTML gh = new GenerateHTML(site);
        gh.setEditMode(edit);
        String currentListHtml = gh.replaceListTag(listHtml, page, siteColumn);
        int currentShowNumber = page.getEveryNumber();
        if (page.getLastPageNumber() == page.getCurrentPageNumber()) {
            currentShowNumber = count - page.getLimitStart();
        }
        String itemsString = "";
        for (int j = 0; j < currentShowNumber; ++j) {
            int indexJ = 0;
            indexJ = edit ? j : (page.getCurrentPageNumber() - 1) * page.getEveryNumber() + j;
            News news = list.get(indexJ);
            itemsString = itemsString + gh.replaceNewsListItem(listItem, news);
        }
        currentListHtml = currentListHtml.replaceAll(GenerateHTML.regex("listItem"), itemsString);
        if (edit) {
            Template temp = new Template(site);
            currentListHtml = temp.replaceForEditModeTag(currentListHtml);
        }
        return currentListHtml;
    }

    @Override
    public void generateViewHtml(Site site, News news, SiteColumn siteColumn, NewsDataBean newsDataBean, HttpServletRequest request) {
        if (Func.isCMS(site)) {
            this.generateViewHtmlForTemplate(site, news, siteColumn, newsDataBean, request);
        } else {
            GenerateHTML gh = new GenerateHTML(site);
            gh.generateViewHtml(site, news, siteColumn, newsDataBean.getText());
        }
    }

    @Override
    public void generateViewHtmlForTemplate(Site site, News news, SiteColumn siteColumn, NewsDataBean newsDataBean, HttpServletRequest request) {
        String templateHtml = this.templateService.getTemplatePageTextByCache(siteColumn.getTemplatePageViewName(), request);
        TemplateCMS template = new TemplateCMS(site, TemplateUtil.getTemplateByName(site.getTemplateName()));
        if (templateHtml == null) {
            return;
        }
        String pageHtml = template.assemblyTemplateVar(templateHtml, this.templateService.getTemplateVarAndDataByDatabase(site).getCompileMap());
        pageHtml = template.replaceSiteColumnTag(pageHtml, siteColumn);
        pageHtml = template.replacePublicTag(pageHtml);
        pageHtml = template.replaceNewsTag(pageHtml, news, siteColumn, newsDataBean);
        pageHtml = pageHtml.replaceAll(Template.regex("title"), news.getTitle() + "_" + site.getName());
        pageHtml = pageHtml.replaceAll(Template.regex("keywords"), news.getTitle() + "," + site.getKeywords());
        pageHtml = Template.replaceAll(pageHtml, Template.regex("description"), news.getIntro());
        template.generateNewsHtml(news, siteColumn, null, null, pageHtml, newsDataBean);
    }

    @Override
    public NewsInit news(HttpServletRequest request, int id, int cid, Model model) {
        NewsInit n = new NewsInit();
        Site site = SessionUtil.getSite();
        News news = null;
        NewsData newsData = null;
        if (id > 0) {
            news = (News)this.sqlDAO.findById(News.class, id);
            if (news == null) {
                n.setBaseVO(0, "\u8981\u7f16\u8f91\u7684\u4fe1\u606f\u4e0d\u5b58\u5728");
                return n;
            }
            if (news.getSiteid() - site.getId() != 0) {
                n.setBaseVO(0, "\u8981\u7f16\u8f91\u7684\u4fe1\u606f\u4e0d\u5c5e\u4e8e\u60a8\uff0c\u65e0\u6cd5\u64cd\u4f5c");
                return n;
            }
            cid = news.getCid();
            newsData = (NewsData)this.sqlDAO.findById(NewsData.class, (Object)news.getId());
            n.setPageTitle("\u4fee\u6539\u4fe1\u606f");
        } else {
            news = new News();
            n.setPageTitle("\u65b0\u589e\u4fe1\u606f");
        }
        SiteColumn siteColumn = null;
        if (cid == 0) {
            n.setBaseVO(0, "\u8bf7\u4f20\u5165\u4fe1\u606f\u6240\u5c5e\u680f\u76ee");
            return n;
        }
        siteColumn = (SiteColumn)this.sqlDAO.findById(SiteColumn.class, cid);
        if (siteColumn == null) {
            n.setBaseVO(0, "\u6240\u5c5e\u680f\u76ee\u4e0d\u5b58\u5728\uff01");
            return n;
        }
        if (siteColumn.getSiteid() - site.getId() != 0) {
            n.setBaseVO(0, "\u680f\u76ee\u4e0d\u5c5e\u4e8e\u60a8\uff0c\u65e0\u6cd5\u64cd\u4f5c");
            return n;
        }
        news.setCid(siteColumn.getId());
        news.setType(siteColumn.getType());
        if (Func.isCMS(site)) {
            if (siteColumn.getType() - SiteColumn.TYPE_NEWS == 0) {
                siteColumn.setEditUseText(SiteColumn.USED_ENABLE);
                siteColumn.setType(SiteColumn.TYPE_LIST);
                this.sqlDAO.save((Object)siteColumn);
            }
            if (siteColumn.getType() - SiteColumn.TYPE_IMAGENEWS == 0) {
                siteColumn.setEditUseText(SiteColumn.USED_ENABLE);
                siteColumn.setEditUseTitlepic(SiteColumn.USED_ENABLE);
                siteColumn.setType(SiteColumn.TYPE_LIST);
                this.sqlDAO.save((Object)siteColumn);
            }
            if (siteColumn.getType() - SiteColumn.TYPE_PAGE == 0) {
                siteColumn.setEditUseText(SiteColumn.USED_ENABLE);
                siteColumn.setType(SiteColumn.TYPE_ALONEPAGE);
                this.sqlDAO.save((Object)siteColumn);
            }
        }
        model.addAttribute("siteColumn", (Object)siteColumn);
        n.setSiteColumn(siteColumn);
        n.setSite(site);
        if (id > 0) {
            String titlepicImage = "";
            if (news.getTitlepic() != null && news.getTitlepic().length() > 0) {
                titlepicImage = news.getTitlepic().indexOf("http://") == 0 || news.getTitlepic().indexOf("https://") == 0 || news.getTitlepic().indexOf("//") == 0 ? news.getTitlepic() : AttachmentUtil.netUrl() + "site/" + site.getId() + "/news/" + news.getTitlepic();
            }
            n.setTitlepicImage(titlepicImage);
            model.addAttribute("titlepicImage", (Object)("<img src=\"" + titlepicImage + "\" height=\"30\" />"));
            NewsDataBean newsDataBean = new NewsDataBean(newsData);
            model.addAttribute("text", (Object)newsDataBean.getText());
            JSONObject json = newsDataBean.getExtendJson();
            if (json != null) {
                Iterator it = json.keys();
                while (it.hasNext()) {
                    String key = (String)it.next();
                    String string = json.getString(key);
                }
            }
            n.setNewsDataBean(newsDataBean);
        }
        n.setNews(news);
        model.addAttribute("news", (Object)news);
        SessionUtil.setUeUploadParam1((String)(site.getId() + ""));
        return n;
    }

    @Override
    public NewsVO deleteNews(int id, boolean authCheck) {
        NewsVO baseVO = new NewsVO();
        if (id == 0) {
            baseVO.setBaseVO(0, "\u8bf7\u4f20\u5165\u8981\u5220\u9664\u4fe1\u606f\u7684\u7f16\u53f7");
            return baseVO;
        }
        News news = (News)this.sqlDAO.findById(News.class, id);
        if (news == null) {
            baseVO.setBaseVO(0, "\u4fe1\u606f\u4e0d\u5b58\u5728");
            return baseVO;
        }
        Site site = SessionUtil.getSite();
        if (authCheck && news.getSiteid() - site.getId() != 0) {
            baseVO.setBaseVO(0, "\u4fe1\u606f\u4e0d\u5c5e\u4e8e\u4f60\uff0c\u65e0\u6743\u5220\u9664");
            return baseVO;
        }
        SiteColumn siteColumn = (SiteColumn)this.sqlDAO.findById(SiteColumn.class, (Object)news.getCid());
        if (siteColumn != null && (siteColumn.getType() - SiteColumn.TYPE_PAGE == 0 || siteColumn.getType() - SiteColumn.TYPE_ALONEPAGE == 0)) {
            baseVO.setBaseVO(0, "\u8be5\u4fe1\u606f\u6240\u5c5e\u7684\u680f\u76ee\uff0c\u680f\u76ee\u7c7b\u578b\u4e3a\u72ec\u7acb\u9875\u9762\uff0c\u65e0\u6cd5\u5220\u9664\u6b64\u4fe1\u606f\u3002\u5982\u679c\u4f60\u60f3\u5220\u9664\uff0c\u53ef\u4ee5\u5220\u9664\u5176\u6240\u5c5e\u7684\u680f\u76ee\uff0c\u6b64\u4fe1\u606f\u81ea\u7136\u5c31\u6ca1\u4e86");
            return baseVO;
        }
        this.sqlDAO.delete((Object)news);
        NewsData newsData = (NewsData)this.sqlDAO.findById(NewsData.class, id);
        if (newsData == null) {
            baseVO.setBaseVO(0, "\u4fe1\u606f\u5185\u5bb9\u4e0d\u5b58\u5728");
            return baseVO;
        }
        this.sqlDAO.delete((Object)newsData);
        if (news.getTitlepic() != null && news.getTitlepic().indexOf("http://") == -1) {
            try {
                AttachmentUtil.deleteObject((String)("site/" + news.getSiteid() + "/news/" + news.getTitlepic()));
            }
            catch (Exception e) {
                ConsoleUtil.error((String)("\u5220\u9664titlepic\u65f6\u5f02\u5e38\uff0c\u4f46\u4e0d\u5f71\u54cd\u6b63\u5e38\u4f7f\u7528\u3002\u5f02\u5e38:" + e.getMessage()));
            }
        }
        baseVO.setNews(news);
        return baseVO;
    }

    @Override
    public String setText(String text, Site site) {
        GenerateHTML gh = new GenerateHTML(site);
        return gh.restoreNewsText(text);
    }
}

