/*
 * Decompiled with CFR 0.152.
 */
package com.xnx3.wangmarket.admin.service.impl;

import com.xnx3.FileUtil;
import com.xnx3.j2ee.dao.SqlDAO;
import com.xnx3.j2ee.util.ConsoleUtil;
import com.xnx3.j2ee.util.SystemUtil;
import com.xnx3.j2ee.vo.BaseVO;
import com.xnx3.net.HttpResponse;
import com.xnx3.net.HttpUtil;
import com.xnx3.wangmarket.admin.cache.Template;
import com.xnx3.wangmarket.admin.entity.InputModel;
import com.xnx3.wangmarket.admin.entity.News;
import com.xnx3.wangmarket.admin.entity.Site;
import com.xnx3.wangmarket.admin.entity.SiteColumn;
import com.xnx3.wangmarket.admin.service.InputModelService;
import com.xnx3.wangmarket.admin.util.ActionLogUtil;
import com.xnx3.wangmarket.admin.util.SessionUtil;
import com.xnx3.wangmarket.admin.vo.bean.NewsInit;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="InputModelService")
public class InputModelServiceImpl
implements InputModelService {
    private static String defaultInputModelText = null;
    @Resource
    private SqlDAO sqlDAO;

    @Override
    public String getInputModelText(int modelId) {
        Map<Integer, InputModel> map = this.getInputModelBySession();
        InputModel inputModel = map.get(modelId);
        if (inputModel == null) {
            return null;
        }
        return inputModel.getText();
    }

    @Override
    public List<InputModel> getInputModelListForSession() {
        Map<Integer, InputModel> map = this.getInputModelBySession();
        ArrayList<InputModel> inputModelList = new ArrayList<InputModel>();
        for (InputModel model : map.values()) {
            inputModelList.add(model);
        }
        return inputModelList;
    }

    @Override
    public Map<Integer, InputModel> getInputModelBySession(int siteid) {
        Map<Integer, InputModel> map = SessionUtil.getInputModel();
        if (map == null) {
            map = new HashMap<Integer, InputModel>();
            List inputModelList = this.sqlDAO.findBySqlQuery("SELECT * FROM input_model WHERE siteid = " + siteid, InputModel.class);
            if (inputModelList != null && inputModelList.size() > 0) {
                for (int i = 0; i < inputModelList.size(); ++i) {
                    InputModel model = (InputModel)inputModelList.get(i);
                    map.put(model.getId(), model);
                }
                SessionUtil.setInputModel(map);
            }
        }
        return map;
    }

    @Override
    public Map<Integer, InputModel> getInputModelBySession() {
        Site site = SessionUtil.getSite();
        int siteid = 0;
        if (site != null) {
            siteid = site.getId();
        }
        return this.getInputModelBySession(siteid);
    }

    @Override
    public InputModel getInputModelById(int modelId) {
        return this.getInputModelBySession().get(modelId);
    }

    @Override
    public BaseVO saveInputModel(InputModel inputModel) {
        BaseVO vo = new BaseVO();
        this.sqlDAO.save((Object)inputModel);
        if (inputModel.getId() != null && inputModel.getId() > 0) {
            Map<Integer, InputModel> map = this.getInputModelBySession();
            map.put(inputModel.getId(), inputModel);
            SessionUtil.setInputModel(map);
            vo.setInfo(inputModel.getId() + "");
            return vo;
        }
        vo.setBaseVO(0, "\u4fdd\u5b58\u5931\u8d25");
        return vo;
    }

    @Override
    public BaseVO removeInputModel(int inputModelId) {
        BaseVO vo = new BaseVO();
        Site site = SessionUtil.getSite();
        if (site == null) {
            vo.setBaseVO(0, "\u60a8\u65e0\u6743\u64cd\u4f5c\u6b64\u6761\u8f93\u5165\u6a21\u578b");
            return vo;
        }
        InputModel inputModel = (InputModel)this.sqlDAO.findById(InputModel.class, inputModelId);
        if (inputModel == null) {
            vo.setBaseVO(0, "\u8981\u5220\u9664\u7684\u8f93\u5165\u6a21\u578b\u4e0d\u5b58\u5728");
            return vo;
        }
        if (inputModel.getSiteid() - site.getId() != 0) {
            vo.setBaseVO(0, "\u8981\u5220\u9664\u7684\u8f93\u5165\u6a21\u578b\u4e0d\u5c5e\u4e8e\u60a8\uff0c\u5220\u9664\u5931\u8d25");
            return vo;
        }
        this.sqlDAO.delete((Object)inputModel);
        Map<Integer, InputModel> map = this.getInputModelBySession();
        map.remove(inputModelId);
        SessionUtil.setInputModel(map);
        ActionLogUtil.insertUpdateDatabase(null, inputModel.getSiteid(), "\u5220\u9664\u8f93\u5165\u6a21\u578b", inputModel.getRemark());
        return vo;
    }

    @Override
    public String getInputModelTextByIdForNews(NewsInit newsInit) {
        String text;
        block7: {
            HashMap<String, Boolean> map;
            News news;
            block6: {
                SiteColumn siteColumn = newsInit.getSiteColumn();
                InputModel im = this.getInputModelBySiteColumn(siteColumn);
                text = null;
                text = im == null ? this.getDefaultInputModelText() : im.getText();
                if (text == null) {
                    return "\u51fa\u9519\uff01\u83b7\u53d6\u8f93\u5165\u6a21\u578b\u5931\u8d25\uff01\u8bf7\u91cd\u65b0\u5c1d\u8bd5";
                }
                text = text.replaceAll(Template.regex("siteColumn.type"), siteColumn.getType() + "");
                news = newsInit.getNews();
                map = new HashMap<String, Boolean>();
                if (text.indexOf("extend.") > 0) {
                    Pattern p = Pattern.compile(Template.regex("news.extend.(\\w*?)"));
                    Matcher m = p.matcher(text);
                    while (m.find()) {
                        map.put(m.group(1), true);
                    }
                }
                if (news != null && news.getId() != null) break block6;
                text = text.replaceAll(Template.regex("news.title"), "");
                text = text.replaceAll(Template.regex("titlepicImage"), "");
                text = text.replaceAll(Template.regex("news.titlepic"), "");
                text = text.replaceAll(Template.regex("text"), "");
                text = text.replaceAll(Template.regex("news.intro"), "");
                text = text.replaceAll(Template.regex("news.reserve1"), "");
                text = text.replaceAll(Template.regex("news.reserve2"), "");
                if (map.size() <= 0) break block7;
                for (Map.Entry entry : map.entrySet()) {
                    text = text.replaceAll(Template.regex("news.extend." + (String)entry.getKey()), "");
                }
                break block7;
            }
            text = Template.replaceAll(text, Template.regex("news.title"), news.getTitle());
            text = Template.replaceAll(text, Template.regex("titlepicImage"), newsInit.getTitlepicImage());
            text = Template.replaceAll(text, Template.regex("news.titlepic"), news.getTitlepic());
            text = Template.replaceAll(text, Template.regex("news.intro"), news.getIntro());
            text = Template.replaceAll(text, Template.regex("news.reserve1"), news.getReserve1());
            text = Template.replaceAll(text, Template.regex("news.reserve2"), news.getReserve2());
            text = Template.replaceAll(text, Template.regex("text"), newsInit.getNewsDataBean().getText());
            if (map.size() > 0) {
                for (Map.Entry entry : map.entrySet()) {
                    text = Template.replaceAll(text, Template.regex("news.extend." + (String)entry.getKey()), newsInit.getNewsDataBean().getExtendJson((String)entry.getKey()));
                }
            }
        }
        return text;
    }

    @Override
    public InputModel getInputModelBySiteColumn(SiteColumn siteColumn) {
        Map<Integer, InputModel> map = this.getInputModelBySession(siteColumn.getSiteid());
        for (Integer key : map.keySet()) {
            InputModel inputModel = map.get(key);
            if (inputModel == null || inputModel.getCodeName() == null || !inputModel.getCodeName().equals(siteColumn.getInputModelCodeName())) continue;
            return inputModel;
        }
        return null;
    }

    @Override
    public InputModel getInputModelByCodeName(String codeName) {
        Map<Integer, InputModel> map = this.getInputModelBySession();
        for (Integer key : map.keySet()) {
            InputModel inputModel = map.get(key);
            if (inputModel == null || inputModel.getCodeName() == null || !inputModel.getCodeName().equals(codeName)) continue;
            return inputModel;
        }
        return null;
    }

    @Override
    public String getDefaultInputModelText() {
        if (defaultInputModelText == null && ((defaultInputModelText = FileUtil.read((String)(SystemUtil.getProjectPath() + "static/inputModel/default.html"))) == null || defaultInputModelText.length() < 1)) {
            ConsoleUtil.info((String)"\u68c0\u6d4b\u5230\u7cfb\u7edf\u9ed8\u8ba4\u7684\u8f93\u5165\u6a21\u578b\u4e0d\u5b58\u5728\uff01\uff08src/main/resources/static/inputModel/default.html\uff09");
            ConsoleUtil.info((String)"\u6b63\u5728\u4ece\u4e91\u7aef http://down.zvo.cn/wangmarket/resources/inputModel_default.html \u52a0\u8f7d\u9ed8\u8ba4\u7684\u8f93\u5165\u6a21\u578b");
            HttpUtil http = new HttpUtil("UTF-8");
            HttpResponse hr = http.get("http://down.zvo.cn/wangmarket/resources/inputModel_default.html");
            if (hr.getCode() != 200) {
                ConsoleUtil.error((String)("http://down.zvo.cn/wangmarket/resources/inputModel_default.html \u83b7\u53d6\u5931\u8d25\uff0crequest code\uff1a" + hr.getCode()));
            }
            defaultInputModelText = hr.getContent();
        }
        return defaultInputModelText;
    }
}

