/*
 * Decompiled with CFR 0.152.
 */
package com.xnx3.wangmarket.admin.controller;

import com.xnx3.DateUtil;
import com.xnx3.Lang;
import com.xnx3.StringUtil;
import com.xnx3.j2ee.entity.User;
import com.xnx3.j2ee.service.SqlService;
import com.xnx3.j2ee.service.UserService;
import com.xnx3.j2ee.util.AttachmentUtil;
import com.xnx3.j2ee.util.SystemUtil;
import com.xnx3.j2ee.vo.BaseVO;
import com.xnx3.j2ee.vo.UploadFileVO;
import com.xnx3.media.ImageUtil;
import com.xnx3.net.MailUtil;
import com.xnx3.net.OSSUtil;
import com.xnx3.wangmarket.admin.Func;
import com.xnx3.wangmarket.admin.G;
import com.xnx3.wangmarket.admin.cache.pc.Index;
import com.xnx3.wangmarket.admin.cache.pc.IndexAboutUs;
import com.xnx3.wangmarket.admin.controller.BaseController;
import com.xnx3.wangmarket.admin.entity.Feedback;
import com.xnx3.wangmarket.admin.entity.News;
import com.xnx3.wangmarket.admin.entity.NewsData;
import com.xnx3.wangmarket.admin.entity.Site;
import com.xnx3.wangmarket.admin.entity.SiteColumn;
import com.xnx3.wangmarket.admin.entity.SiteData;
import com.xnx3.wangmarket.admin.service.NewsService;
import com.xnx3.wangmarket.admin.service.SiteColumnService;
import com.xnx3.wangmarket.admin.service.SiteService;
import com.xnx3.wangmarket.admin.util.ActionLogUtil;
import com.xnx3.wangmarket.admin.util.SessionUtil;
import com.xnx3.wangmarket.admin.vo.SiteDataVO;
import com.xnx3.wangmarket.admin.vo.SiteVO;
import com.xnx3.wangmarket.domain.bean.MQBean;
import com.xnx3.wangmarket.domain.bean.SimpleSite;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.json.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

@Controller
@RequestMapping(value={"/sites"})
public class SiteController
extends BaseController {
    @Resource
    private SqlService sqlService;
    @Resource
    private SiteColumnService siteColumnService;
    @Resource
    private SiteService siteService;
    @Resource
    private NewsService newsService;
    @Resource
    private UserService userService;

    @RequestMapping(value={"saveSite${url.suffix}"}, method={RequestMethod.POST})
    public String saveSite(Site s, Model model, HttpServletRequest request) {
        SiteVO siteVO = this.siteService.saveSite(s, this.getUserId(), request);
        if (siteVO.getResult() == 1) {
            ActionLogUtil.insert(request, "\u4fdd\u5b58\u7f51\u7ad9\u4fe1\u606f", s.toString());
            return this.success(model, s.getId() > 0 ? "\u4fdd\u5b58\u7f51\u7ad9\u6210\u529f\uff01" : "\u521b\u5efa\u7f51\u7ad9\u6210\u529f\uff01", Func.getConsoleRedirectUrl());
        }
        return this.error(model, "\u4fdd\u5b58\u5931\u8d25\uff01");
    }

    @RequestMapping(value={"updateName${url.suffix}"}, method={RequestMethod.POST})
    @ResponseBody
    public BaseVO updateName(Model model, HttpServletRequest request, @RequestParam(value="name", required=false, defaultValue="") String name) {
        BaseVO vo = new BaseVO();
        Site site = (Site)this.sqlService.findById(Site.class, this.getSiteId());
        if (name.length() == 0) {
            name = "\u6b64\u4eba\u5f88\u61d2\uff0c\u6682\u672a\u8d77\u540d";
        }
        site.setName(StringUtil.filterXss((String)name));
        this.sqlService.save((Object)site);
        ActionLogUtil.insertUpdateDatabase(request, "\u4fee\u6539\u7ad9\u70b9\u540d\u5b57", site.getName());
        SessionUtil.setSite(site);
        if (site.getClient() - Site.CLIENT_PC == 0) {
            Index.updateSiteName(site, site.getName());
        }
        return vo;
    }

    @RequestMapping(value={"updateKeywords${url.suffix}"}, method={RequestMethod.POST})
    @ResponseBody
    public BaseVO updateKeywords(Model model, HttpServletRequest request, @RequestParam(value="keywords", required=false, defaultValue="") String keywords) {
        BaseVO vo = new BaseVO();
        Site site = (Site)this.sqlService.findById(Site.class, this.getSiteId());
        site.setKeywords(this.filter(keywords));
        this.sqlService.save((Object)site);
        ActionLogUtil.insertUpdateDatabase(request, "\u4fee\u6539\u7ad9\u70b9Keywords", site.getKeywords());
        Index.updateKeywords(site, keywords);
        return vo;
    }

    @RequestMapping(value={"updateDescription${url.suffix}"}, method={RequestMethod.POST})
    @ResponseBody
    public BaseVO updateDescription(@RequestParam(value="description", required=false, defaultValue="") String description, Model model, HttpServletRequest request) {
        BaseVO vo = new BaseVO();
        Site site = (Site)this.sqlService.findById(Site.class, this.getSiteId());
        SiteData siteData = (SiteData)this.sqlService.findById(SiteData.class, (Object)site.getId());
        if (siteData == null) {
            siteData = new SiteData();
            siteData.setId(site.getId());
            siteData.setIndexDescription(site.getName());
        }
        siteData.setIndexDescription(this.filter(description));
        this.sqlService.save((Object)siteData);
        ActionLogUtil.insertUpdateDatabase(request, "\u4fee\u6539\u7ad9\u70b9Description", siteData.getIndexDescription());
        Index.updateDescription(site, siteData.getIndexDescription());
        return vo;
    }

    @RequestMapping(value={"updateBindDomain${url.suffix}"}, method={RequestMethod.POST})
    @ResponseBody
    public BaseVO updateBindDomain(Model model, HttpServletRequest request, @RequestParam(value="bindDomain", required=false, defaultValue="") String bindDomain) {
        int scount;
        BaseVO vo = new BaseVO();
        if ((bindDomain = StringUtil.filterXss((String)bindDomain)).length() != 0 && (scount = this.sqlService.count("site", "WHERE bind_domain = '" + bindDomain + "'")) > 0) {
            vo.setBaseVO(0, "\u6b64\u57df\u540d\u5df2\u7ecf\u88ab\u7ed1\u5b9a\u8fc7\u4e86\uff01");
            return vo;
        }
        Site site = (Site)this.sqlService.findById(Site.class, this.getSiteId());
        String oldBindDomain = site.getBindDomain();
        site.setBindDomain(bindDomain);
        this.sqlService.save((Object)site);
        MQBean mqBean = new MQBean();
        mqBean.setType(2);
        mqBean.setOldValue(oldBindDomain);
        mqBean.setSimpleSite(new SimpleSite(site));
        this.siteService.updateDomainServers(mqBean);
        SessionUtil.setSite(site);
        ActionLogUtil.insertUpdateDatabase(request, "\u4fee\u6539\u7ad9\u70b9\u7ed1\u5b9a\u7684\u57df\u540d", site.getBindDomain());
        return vo;
    }

    @RequestMapping(value={"popupBasicInfo${url.suffix}"})
    public String baseInfo(Model model, HttpServletRequest request) {
        model.addAttribute("user", (Object)this.getUser());
        model.addAttribute("site", (Object)this.getSite());
        ActionLogUtil.insert((HttpServletRequest)request, (String)"\u67e5\u770b\u6211\u7684\u7ad9\u70b9\u5c5e\u6027\u4fe1\u606f");
        this.siteService.getTemplateCommonHtml(this.getSite(), "\u7ad9\u70b9\u5c5e\u6027", model);
        return "site/popupBasicInfo";
    }

    @RequestMapping(value={"popupInfo${url.suffix}"})
    public String baseSet(Model model, HttpServletRequest request) {
        model.addAttribute("user", (Object)this.getUser());
        model.addAttribute("site", (Object)this.getSite());
        ActionLogUtil.insert((HttpServletRequest)request, (String)"\u5f39\u51fa\u6846\u53e3\u67e5\u770b\u6211\u7684\u7ad9\u70b9\u5c5e\u6027\u4fe1\u606f");
        this.siteService.getTemplateCommonHtml(this.getSite(), "\u7ad9\u70b9\u5c5e\u6027", model);
        model.addAttribute("autoAssignDomain", (Object)G.getFirstAutoAssignDomain());
        return "site/popupInfo";
    }

    @RequestMapping(value={"getOSSSize${url.suffix}"}, method={RequestMethod.POST})
    @ResponseBody
    public BaseVO getOSSSize(HttpServletRequest request) {
        if (AttachmentUtil.isMode((String)"aliyunOSS") && OSSUtil.getOSSClient() == null) {
            return this.error("\u672a\u5f00\u901a\u963f\u91cc\u4e91OSS\u670d\u52a1");
        }
        BaseVO vo = new BaseVO();
        Site site = (Site)this.sqlService.findById(Site.class, (Object)SessionUtil.getSite().getId());
        long sizeB = AttachmentUtil.getDirectorySize((String)("site/" + site.getId() + "/"));
        int kb = Math.round(sizeB / 1024L);
        String currentDate = DateUtil.currentDate((String)"yyyyMMdd");
        this.sqlService.executeSql("UPDATE site SET attachment_update_date = '" + currentDate + "' , attachment_size = " + kb + " WHERE id = " + site.getId());
        vo.setBaseVO(1, kb + "");
        ActionLogUtil.insertUpdateDatabase(request, "\u8ba1\u7b97\u6211\u5f53\u524d\u7f51\u7ad9\u4f7f\u7528\u4e86\u591a\u5c11\u5b58\u50a8\u7a7a\u95f4", "\u5df2\u4f7f\u7528\uff1a" + Lang.fileSizeToInfo((double)sizeB));
        SessionUtil.setAllowUploadForUEditor((kb < SessionUtil.getSite().getAttachmentSizeHave() * 1000 ? 1 : 0) != 0);
        return vo;
    }

    @RequestMapping(value={"getSiteData${url.suffix}"}, method={RequestMethod.POST})
    @ResponseBody
    public SiteDataVO getSiteData(HttpServletRequest request) {
        SiteDataVO vo = new SiteDataVO();
        SiteData siteData = (SiteData)this.sqlService.findById(SiteData.class, this.getSiteId());
        vo.setSite(this.getSite());
        vo.setSiteData(siteData);
        ActionLogUtil.insert(request, "\u83b7\u53d6\u5f53\u524d\u7ad9\u70b9\u4fe1\u606f", siteData != null ? siteData.toString() : "");
        return vo;
    }

    @RequestMapping(value={"updateDomain${url.suffix}"}, method={RequestMethod.POST})
    @ResponseBody
    public BaseVO updateDomain(HttpServletRequest request, @RequestParam(value="domain", required=false, defaultValue="") String domain) {
        int count;
        BaseVO vo = new BaseVO();
        domain = this.filter(domain);
        String forbidDomain = SystemUtil.get((String)"FORBID_DOMAIN");
        if (forbidDomain != null && forbidDomain.length() > 0) {
            String[] fs = forbidDomain.split("\\|");
            for (int i = 0; i < fs.length; ++i) {
                if (fs[i] == null || fs[i].length() <= 0 || !domain.toLowerCase().equals(fs[i])) continue;
                vo.setBaseVO(0, fs[i] + " \u6b64\u57df\u540d\u5c5e\u4e8e\u7cfb\u7edf\u4fdd\u7559\u57df\u540d\uff0c\u4e0d\u53ef\u4f7f\u7528\uff01\u8bf7\u66f4\u6362\u4e00\u4e2a\u5427");
                return vo;
            }
        }
        if ((count = this.sqlService.count("site", "WHERE domain = '" + domain + "'")) > 0) {
            vo.setBaseVO(0, "\u6b64\u57df\u540d\u5df2\u88ab\u4f7f\u7528\uff01\u8bf7\u66f4\u6362\u518d\u8bd5");
            return vo;
        }
        Site site = (Site)this.sqlService.findById(Site.class, this.getSiteId());
        String oldDomain = site.getDomain();
        site.setDomain(domain);
        this.sqlService.save((Object)site);
        MQBean mqBean = new MQBean();
        mqBean.setType(1);
        mqBean.setOldValue(oldDomain);
        mqBean.setSimpleSite(new SimpleSite(site));
        this.siteService.updateDomainServers(mqBean);
        SessionUtil.setSite(site);
        ActionLogUtil.insertUpdateDatabase(request, "\u66f4\u6362\u7ad9\u70b9\u4e8c\u7ea7\u57df\u540d", site.getDomain());
        return vo;
    }

    @RequestMapping(value={"templateList${url.suffix}"})
    public String templateList(Model model, HttpServletRequest request) {
        Site site = this.getSite();
        model.addAttribute("user", (Object)this.getUser());
        model.addAttribute("site", (Object)site);
        model.addAttribute("client", (Object)site.getClient());
        ActionLogUtil.insert((HttpServletRequest)request, (String)"\u6253\u5f00\u901a\u7528\u6a21\u5f0f\u4e0b\u9009\u62e9\u6a21\u7248\u9875\u9762");
        return "site/templateList";
    }

    @RequestMapping(value={"templateSave${url.suffix}"}, method={RequestMethod.POST})
    @ResponseBody
    public BaseVO templateSave(Model model, HttpServletRequest request, @RequestParam(value="templateId", required=false, defaultValue="0") int templateId) {
        Site site = (Site)this.sqlService.findById(Site.class, this.getSiteId());
        if (templateId == 0) {
            return this.error("\u8bf7\u4f20\u5165\u8981\u4f7f\u7528\u7684\u6a21\u7248\u7f16\u53f7");
        }
        ActionLogUtil.insertUpdateDatabase(request, templateId, "\u4fdd\u5b58\u901a\u7528\u6a21\u5f0f\u4e0b\u9009\u62e9\u7684\u6a21\u7248");
        if (site.getTemplateId() != templateId) {
            site.setTemplateId(templateId);
            SiteVO siteVO = null;
            if (site.getClient() - Site.CLIENT_WAP == 0) {
                siteVO = this.siteService.saveSite(site, site.getUserid(), request);
            } else {
                siteVO = this.siteService.saveSite(site, site.getUserid(), request);
                BaseVO vo = this.siteService.refreshIndex(site);
                if (vo.getResult() - 0 == 0) {
                    return this.error(vo.getInfo());
                }
            }
            if (siteVO.getResult() == 1) {
                return this.success();
            }
            return this.error(siteVO.getInfo());
        }
        return this.error("\u672a\u9009\u62e9\u65b0\u6a21\u7248");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @RequestMapping(value={"html${url.suffix}"})
    public String html(HttpServletRequest request, Model model, @RequestParam(value="htmlFile", required=false, defaultValue="") String htmlFile) {
        if (htmlFile.equals("")) {
            return this.error(model, "\u610f\u5916\u6545\u969c\uff01");
        }
        Site site = this.getSite();
        if (site == null) {
            return this.error(model, "\u767b\u9646\u72b6\u6001\u4e22\u5931\uff0c\u91cd\u65b0\u767b\u9646");
        }
        String redirectUrl = "";
        if (htmlFile.equals("index")) {
            redirectUrl = "sitePc/index.do";
        } else if (htmlFile.indexOf("lc") > -1 && htmlFile.indexOf("_") > -1) {
            String sid = Lang.subString((String)htmlFile, (String)"lc", (String)"_");
            int siteColumnId = Lang.stringToInt((String)sid, (int)0);
            if (siteColumnId <= 0) return this.error(model, "\u672a\u83b7\u53d6\u5230\u680f\u76ee\u7f16\u53f7");
            redirectUrl = "news/listForTemplate.do?cid=" + siteColumnId;
        } else if (htmlFile.indexOf("c") > -1) {
            String sid = Lang.subString((String)htmlFile, (String)"c", null);
            int siteColumnId = Lang.stringToInt((String)sid, (int)0);
            if (siteColumnId <= 0) return this.error(model, "\u672a\u83b7\u53d6\u5230\u680f\u76ee\u7f16\u53f7");
            redirectUrl = "news/updateNewsByCid.do?cid=" + siteColumnId;
        } else {
            int newsId = Lang.stringToInt((String)htmlFile, (int)0);
            if (newsId <= 0) return this.error(model, "\u672a\u77e5\u9875\u9762");
            redirectUrl = "news/news.do?id=" + newsId;
        }
        ActionLogUtil.insert((HttpServletRequest)request, (String)"HTML\u540e\u7f00\u6355\u83b7\u8f6c\u53d1\uff0c\u4e3b\u8981\u7528\u4e8e\u7535\u8111\u6a21\u5f0f\u7f51\u7ad9\uff0c\u53ef\u89c6\u5316\u72b6\u6001");
        return this.redirect(redirectUrl);
    }

    @RequestMapping(value={"refreshSitemap${url.suffix}"})
    public String refreshSitemap(@RequestParam(value="siteid", required=true) int siteid, Model model, HttpServletRequest request) {
        Site site = (Site)this.sqlService.findAloneBySqlQuery("SELECT * FROM site WHERE id = " + siteid, Site.class);
        this.siteService.refreshSiteMap(site);
        ActionLogUtil.insert((HttpServletRequest)request, (String)"\u5237\u65b0\uff0c\u91cd\u65b0\u751f\u6210sitemap.xml\u6587\u4ef6");
        return this.success(model, "\u6210\u529f");
    }

    @RequestMapping(value={"refreshIndex${url.suffix}"})
    public String refreshIndex(Model model, HttpServletRequest request) {
        BaseVO vo = this.siteService.refreshIndex(this.getSite());
        if (vo.getResult() - 1 == 0) {
            ActionLogUtil.insert((HttpServletRequest)request, (String)"\u901a\u7528\u7535\u8111\u6a21\u5f0f\u4e0b\uff0c\u5237\u65b0\uff0c\u91cd\u65b0\u751f\u6210\u9996\u9875");
            return this.success(model, "\u5237\u65b0\u6210\u529f\uff0c\u82e5\u9996\u9875\u4e0d\u662f\u6700\u65b0\u7684\uff0c\u53ef\u6309\u4f4fCTRL\uff0bF5 \u5f3a\u5236\u5237\u65b0\u540e\u5728\u770b");
        }
        return this.error(model, vo.getInfo());
    }

    @RequestMapping(value={"popupSiteUpdate${url.suffix}"})
    public String popupSiteUpdate(Model model, HttpServletRequest request) {
        ActionLogUtil.insert((HttpServletRequest)request, (String)"\u5f39\u51fa\u5f39\u51fa\u6846\uff0c\u663e\u793a\u7ad9\u70b9\u4fe1\u606f\u4fee\u6539");
        model.addAttribute("site", (Object)this.getSite());
        return "site/popupSiteUpdate";
    }

    @RequestMapping(value={"savePopupSiteUpdate${url.suffix}"}, method={RequestMethod.POST})
    @ResponseBody
    public BaseVO savePopupSiteUpdate(Site s, Model model, HttpServletRequest request) {
        Site site = (Site)this.sqlService.findById(Site.class, (Object)this.getSite().getId());
        site.setUsername(this.filter(s.getUsername()));
        site.setPhone(this.filter(s.getPhone()));
        site.setQq(this.filter(s.getQq()));
        site.setCompanyName(this.filter(s.getCompanyName()));
        site.setAddress(this.filter(s.getAddress()));
        SiteVO siteVO = this.siteService.saveSite(site, this.getUserId(), request);
        if (siteVO.getResult() == 1) {
            ActionLogUtil.insert((HttpServletRequest)request, (String)"\u4fdd\u5b58\u5f39\u51fa\u6846\u4fee\u6539\u7684\u7ad9\u70b9\u4fe1\u606f\u6210\u529f");
            return this.success();
        }
        return this.error(siteVO.getInfo());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"popupQrImageUpdateSubmit${url.suffix}"}, method={RequestMethod.POST})
    public void popupQrImageUpdateSubmit(Model model, HttpServletRequest request, HttpServletResponse response, @RequestParam(value="qrImageFile") MultipartFile multipartFile) throws IOException {
        JSONObject json = new JSONObject();
        Site site = this.getSite();
        if (!(multipartFile.getContentType().equals("image/pjpeg") || multipartFile.getContentType().equals("image/jpeg") || multipartFile.getContentType().equals("image/png") || multipartFile.getContentType().equals("image/gif"))) {
            json.put((Object)"result", (Object)"0");
            json.put((Object)"info", (Object)"\u8bf7\u4f20\u5165jpg\u3001png\u3001gif\u683c\u5f0f\u7684\u4e8c\u7ef4\u7801\u56fe");
        } else {
            BufferedImage bufferedImage = ImageUtil.inputStreamToBufferedImage((InputStream)multipartFile.getInputStream());
            BufferedImage tag = ImageUtil.formatConversion((BufferedImage)bufferedImage);
            BufferedImage tag1 = ImageUtil.proportionZoom((BufferedImage)tag, (int)400);
            AttachmentUtil.put((String)("site/" + site.getId() + "/images/qr.jpg"), (InputStream)ImageUtil.bufferedImageToInputStream((BufferedImage)tag1, (String)"jpg"));
            ActionLogUtil.insert((HttpServletRequest)request, (String)"\u901a\u7528\u7535\u8111\u6a21\u5f0f\uff0c\u66f4\u6539\u5e95\u90e8\u7684\u4e8c\u7ef4\u7801\uff0c\u63d0\u4ea4\u4fdd\u5b58");
            json.put((Object)"result", (Object)"1");
        }
        response.setCharacterEncoding("UTF-8");
        response.setContentType("application/json; charset=utf-8");
        try (PrintWriter out = null;){
            out = response.getWriter();
            out.append(json.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"popupAboutUsImageUpdateSubmit${url.suffix}"}, method={RequestMethod.POST})
    public void popupAboutUsImageUpdateSubmit(HttpServletRequest request, Model model, HttpServletResponse response, @RequestParam(value="titlePicFile") MultipartFile multipartFile) {
        JSONObject json = new JSONObject();
        Site site = this.getSite();
        News news = (News)this.sqlService.findAloneBySqlQuery("SELECT news.* FROM news WHERE news.cid = " + this.getSite().getAboutUsCid(), News.class);
        if (news == null) {
            return;
        }
        UploadFileVO uploadFileVO = AttachmentUtil.uploadImage((String)("site/" + site.getId() + "/news/"), (HttpServletRequest)request, (String)"titlePicFile", (int)1000);
        String oldTitlePic = "";
        if (uploadFileVO.getResult() == 1) {
            oldTitlePic = news.getTitlepic() == null || news.getTitlepic().length() == 0 ? "" : news.getTitlepic();
            news.setTitlepic(uploadFileVO.getFileName());
            this.sqlService.save((Object)news);
            if (oldTitlePic.length() > 0 && oldTitlePic.indexOf("http://") == -1 && oldTitlePic.indexOf("https://") == -1 && oldTitlePic.indexOf("//") == -1) {
                AttachmentUtil.deleteObject((String)("site/" + site.getId() + "/news/" + oldTitlePic));
            }
            SiteColumn siteColumn = (SiteColumn)this.sqlService.findById(SiteColumn.class, (Object)news.getCid());
            NewsData newsData = (NewsData)this.sqlService.findById(NewsData.class, (Object)news.getId());
            IndexAboutUs.refreshIndexData(site, siteColumn, news, newsData == null ? "" : newsData.getText());
            ActionLogUtil.insertUpdateDatabase(request, "\u901a\u7528\u7535\u8111\u6a21\u5f0f\uff0c\u5173\u4e8e\u6211\u4eec\u56fe\u7247\u66f4\u6539\u6210\u529f");
            json.put((Object)"result", (Object)"1");
        } else {
            json.put((Object)"result", (Object)"0");
            json.put((Object)"info", (Object)uploadFileVO.getInfo());
        }
        response.setCharacterEncoding("UTF-8");
        response.setContentType("application/json; charset=utf-8");
        try (PrintWriter out = null;){
            out = response.getWriter();
            out.append(json.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"deleteOssData${url.suffix}"}, method={RequestMethod.POST})
    public void deleteOssData(Model model, HttpServletResponse response, HttpServletRequest request, @RequestParam(value="fileName", required=true) String fileName) {
        fileName = this.filter(fileName);
        AttachmentUtil.deleteObject((String)("site/" + this.getSiteId() + "/" + fileName));
        ActionLogUtil.insert((HttpServletRequest)request, (String)("\u5220\u9664\u5f53\u524d\u7f51\u7ad9\u5185\u5b58\u50a8\u7684\u6587\u4ef6\uff1a" + fileName));
        JSONObject json = new JSONObject();
        json.put((Object)"result", (Object)"1");
        response.setCharacterEncoding("UTF-8");
        response.setContentType("application/json; charset=utf-8");
        try (PrintWriter out = null;){
            out = response.getWriter();
            out.append(json.toString());
        }
    }

    @RequestMapping(value={"wenTiFanKui${url.suffix}"}, method={RequestMethod.POST})
    @ResponseBody
    public BaseVO wenTiFanKui(HttpServletRequest request, @RequestParam(value="text", required=false, defaultValue="") String text) {
        if (text.length() == 0) {
            return this.error("\u8bf4\u70b9\u4ec0\u4e48\u5462\uff1f");
        }
        Feedback fb = new Feedback();
        fb.setAddtime(DateUtil.timeForUnix10());
        fb.setUserid(this.getUserId());
        fb.setText(this.filter(text));
        this.sqlService.save((Object)fb);
        if (fb.getId() != null && fb.getId() > 0) {
            String jianjie = fb.getText();
            if (jianjie.length() > 30) {
                jianjie = jianjie.substring(0, 30);
            }
            ActionLogUtil.insertUpdateDatabase(request, "\u63d0\u4ea4\u95ee\u9898\u53cd\u9988", jianjie);
            MailUtil.sendMail((String)SystemUtil.get((String)"SERVICE_MAIL"), (String)"\u6709\u65b0\u7684\u95ee\u9898\u53cd\u9988", (String)fb.toString());
            return this.success();
        }
        return this.error("\u4fdd\u5b58\u51fa\u9519\uff01\u8bf7\u91cd\u8bd5");
    }

    @RequestMapping(value={"refreshGenerateAllSite${url.suffix}"})
    public String refreshGenerateAllSite(Model model, HttpServletRequest request) {
        User user = this.getUser();
        if (user.getId() - 1 == 0) {
            List list = this.sqlService.findBySqlQuery("SELECT * FROM site WHERE client = " + Site.CLIENT_WAP + " OR client = " + Site.CLIENT_PC, Site.class);
            for (int i = 0; i < list.size(); ++i) {
                Site site = (Site)list.get(i);
                SessionUtil.setSite(site);
                try {
                    System.out.println(this.siteService.refreshSiteGenerateHtml(request));
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        ActionLogUtil.insert((HttpServletRequest)request, (String)"\u5237\u65b0\uff0c\u91cd\u65b0\u751f\u6210\u6240\u6709wap\u3001pc\u6a21\u5f0f\u7f51\u7ad9\u3002\u4e0d\u8fc7\u6b64\u63a5\u53e3\u53ea\u80fd\u662f\u7528\u6237id\u4e3a1\u7684\u8d85\u7ea7\u7ba1\u7406\u5458\u4f7f\u7528");
        return "asd";
    }

    @RequestMapping(value={"updatePassword${url.suffix}"}, method={RequestMethod.POST})
    @ResponseBody
    public BaseVO updatePassword(HttpServletRequest request, @RequestParam(value="newPassword", required=false, defaultValue="") String newPassword) {
        User user = this.getUser();
        if (user.getUsername().indexOf("ceshi") == 0) {
            return this.error("\u6d4b\u8bd5\u4f53\u9a8c\u7684\u7f51\u7ad9\u65e0\u6cd5\u4fee\u6539\u5bc6\u7801\uff01");
        }
        ActionLogUtil.insertUpdateDatabase(request, "\u7f51\u7ad9\u66f4\u6539\u5bc6\u7801", newPassword);
        return this.userService.updatePassword(this.getUserId(), newPassword);
    }

    @RequestMapping(value={"uploadImage${url.suffix}"}, method={RequestMethod.POST})
    @ResponseBody
    public UploadFileVO uploadImage(Model model, HttpServletRequest request) {
        UploadFileVO uploadFileVO = AttachmentUtil.uploadImage((String)("site/" + this.getSiteId() + "/news/"), (HttpServletRequest)request, (String)"image", (int)0);
        if (uploadFileVO.getResult() == 1) {
            ActionLogUtil.insert(request, "\u7f51\u7ad9\u4e0a\u4f20\u56fe\u7247", uploadFileVO.getPath());
        }
        return uploadFileVO;
    }

    @RequestMapping(value={"popupUpdateEmailSave${url.suffix}"})
    public String popupUpdateEmailSave(HttpServletRequest request, Model model) {
        ActionLogUtil.insert((HttpServletRequest)request, (String)"\u5f39\u51fa\u5f39\u51fa\u6846\uff0c\u4fee\u6539\u90ae\u7bb1");
        model.addAttribute("user", (Object)this.getUser());
        return "site/popup_updateEmail";
    }

    @RequestMapping(value={"popupBindDomain${url.suffix}"})
    public String popupBindDomain(Model model, HttpServletRequest request) {
        model.addAttribute("user", (Object)this.getUser());
        model.addAttribute("site", (Object)this.getSite());
        String bindDomainDemo = SystemUtil.get((String)"BIND_DOMAIN_DEMO");
        if (bindDomainDemo == null || bindDomainDemo.length() == 0 || bindDomainDemo.equalsIgnoreCase("null")) {
            bindDomainDemo = "www.guanleiming.com";
        }
        model.addAttribute("bindDomainDemo", (Object)bindDomainDemo);
        ActionLogUtil.insert((HttpServletRequest)request, (String)"\u5f39\u51fa\u6846\u53e3\uff0c\u7ed1\u5b9a\u81ea\u5df1\u7684\u57df\u540d");
        return "site/popupBindDomain";
    }

    @RequestMapping(value={"sitePreview${url.suffix}"})
    public String sitePreview(Model model, HttpServletRequest request) {
        ActionLogUtil.insert(request, "\u7cfb\u7edf\u7ba1\u7406-\u9884\u89c8\u7f51\u7ad9", this.getSite().getDomain() + "." + G.getFirstAutoAssignDomain());
        return this.redirect("index.html?domain=" + this.getSite().getDomain() + "." + G.getFirstAutoAssignDomain());
    }
}

