/*
 * Decompiled with CFR 0.152.
 */
package com.xnx3.wangmarket.admin.controller;

import com.xnx3.j2ee.service.SqlService;
import com.xnx3.j2ee.vo.BaseVO;
import com.xnx3.wangmarket.admin.controller.BaseController;
import com.xnx3.wangmarket.admin.entity.InputModel;
import com.xnx3.wangmarket.admin.entity.Site;
import com.xnx3.wangmarket.admin.service.InputModelService;
import com.xnx3.wangmarket.admin.util.ActionLogUtil;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/inputModel/"})
public class InputModelController
extends BaseController {
    @Resource
    private SqlService sqlService;
    @Resource
    private InputModelService inputModelService;

    @RequestMapping(value={"list${url.suffix}"})
    public String list(HttpServletRequest request, Model model) {
        ActionLogUtil.insert((HttpServletRequest)request, (String)"\u8fdb\u5165CMS\u6a21\u5f0f\u4e0b\u81ea\u5b9a\u4e49\u8f93\u5165\u6a21\u578b\u5217\u8868");
        model.addAttribute("list", this.inputModelService.getInputModelListForSession());
        return "inputModel/list";
    }

    @RequestMapping(value={"edit${url.suffix}"})
    public String edit(HttpServletRequest request, Model model, @RequestParam(value="id", required=false, defaultValue="0") int id) {
        InputModel inputModel = this.inputModelService.getInputModelById(id);
        ActionLogUtil.insert(request, "\u8fdb\u5165\u8f93\u5165\u6a21\u578b\u7f16\u8f91\u9875\u9762", inputModel == null ? "\u6dfb\u52a0\u9875\u9762" : inputModel.toString());
        model.addAttribute("inputModel", (Object)inputModel);
        return "inputModel/edit";
    }

    @RequestMapping(value={"getInputModelTextById${url.suffix}"}, method={RequestMethod.POST})
    @ResponseBody
    public BaseVO getInputModelTextById(HttpServletRequest request, Model model, @RequestParam(value="id", required=false, defaultValue="0") int id) {
        InputModel inputModel = this.inputModelService.getInputModelById(id);
        if (inputModel == null) {
            BaseVO vo = new BaseVO();
            vo.setBaseVO(3, this.inputModelService.getDefaultInputModelText());
            return vo;
        }
        ActionLogUtil.insert(request, inputModel.getId(), "\u83b7\u53d6\u8f93\u5165\u6a21\u578b\u7684\u5185\u5bb9", inputModel.getCodeName());
        return this.success(inputModel.getText());
    }

    @RequestMapping(value={"save${url.suffix}"}, method={RequestMethod.POST})
    @ResponseBody
    public BaseVO save(HttpServletRequest request, Model model, InputModel im) {
        InputModel inputModel;
        Site site = this.getSite();
        if (im.getId() != null && im.getId() > 0) {
            inputModel = (InputModel)this.sqlService.findById(InputModel.class, (Object)im.getId());
            if (inputModel == null) {
                return this.error("\u8981\u7f16\u8f91\u7684\u8f93\u5165\u6a21\u578b\u4e0d\u5b58\u5728\uff01");
            }
            if (inputModel.getSiteid() - site.getId() != 0) {
                return this.error("\u8be5\u8f93\u5165\u6a21\u578b\u4e0d\u5c5e\u4e8e\u4f60\uff0c\u65e0\u6cd5\u64cd\u4f5c");
            }
        } else {
            inputModel = new InputModel();
            inputModel.setSiteid(site.getId());
        }
        inputModel.setRemark(this.filter(im.getRemark()));
        inputModel.setCodeName(this.filter(im.getCodeName()));
        inputModel.setText(im.getText());
        List<InputModel> cacheList = this.inputModelService.getInputModelListForSession();
        for (int i = 0; i < cacheList.size(); ++i) {
            InputModel m = cacheList.get(i);
            if (!inputModel.getCodeName().equals(m.getCodeName()) || inputModel.getId() != null && inputModel.getId() - m.getId() == 0) continue;
            return this.error("\u6a21\u578b\u4ee3\u7801\u91cd\u590d\uff01\u4fdd\u5b58\u5931\u8d25\uff0c\u8bf7\u66f4\u6539\u6a21\u578b\u4ee3\u7801\u91cd\u8bd5");
        }
        BaseVO vo = this.inputModelService.saveInputModel(inputModel);
        if (vo.getResult() - 1 == 0) {
            ActionLogUtil.insertUpdateDatabase(request, inputModel.getId(), "\u8f93\u5165\u6a21\u578b\u4fdd\u5b58\u6210\u529f", inputModel.getCodeName());
        }
        return vo;
    }

    @RequestMapping(value={"delete${url.suffix}"}, method={RequestMethod.POST})
    @ResponseBody
    public BaseVO delete(HttpServletRequest request, Model model, @RequestParam(value="id", required=false, defaultValue="0") int id) {
        ActionLogUtil.insertUpdateDatabase(request, id, "\u8f93\u5165\u6a21\u578b\u5220\u9664");
        return this.inputModelService.removeInputModel(id);
    }
}

