/*
 * Decompiled with CFR 0.152.
 */
package com.xnx3.wangmarket.admin.cache;

import com.xnx3.DateUtil;
import com.xnx3.StringUtil;
import com.xnx3.bean.TagA;
import com.xnx3.j2ee.util.AttachmentUtil;
import com.xnx3.j2ee.util.ConsoleUtil;
import com.xnx3.j2ee.util.Page;
import com.xnx3.j2ee.util.SystemUtil;
import com.xnx3.wangmarket.admin.bean.NewsDataBean;
import com.xnx3.wangmarket.admin.cache.Template;
import com.xnx3.wangmarket.admin.cache.generateSite.DefaultGenerateHtmlInterfaceImpl;
import com.xnx3.wangmarket.admin.cache.generateSite.GenerateHtmlInterface;
import com.xnx3.wangmarket.admin.entity.News;
import com.xnx3.wangmarket.admin.entity.NewsData;
import com.xnx3.wangmarket.admin.entity.Site;
import com.xnx3.wangmarket.admin.entity.SiteColumn;
import com.xnx3.wangmarket.admin.util.TemplateUtil;
import com.xnx3.wangmarket.admin.vo.SiteColumnTreeVO;
import com.xnx3.wangmarket.admin.vo.TemplateVO;
import com.xnx3.wangmarket.admin.vo.TemplateVarVO;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.json.JSONObject;

public class TemplateCMS {
    private int linuxTime;
    private Site site;
    private com.xnx3.wangmarket.admin.entity.Template template;
    private JSONObject siteVarJson;
    private String templatePathDomain = null;
    public GenerateHtmlInterface generateHtmlInterface;
    public static final String TEMPLATE_CLOUD_PATH;
    public static final String TEMPLATE_PRIVATE_PATH;
    private String generateUrlRule = "int";
    private boolean editMode = false;

    public String getTemplatePath() {
        if (this.templatePathDomain == null) {
            this.templatePathDomain = this.template != null && TemplateUtil.databaseTemplateMapForName.get(this.template.getName()) != null ? TEMPLATE_PRIVATE_PATH : TEMPLATE_CLOUD_PATH;
            this.templatePathDomain = this.templatePathDomain + this.site.getTemplateName() + "/";
        }
        return this.templatePathDomain;
    }

    public TemplateCMS(Site site, TemplateVO templateVO) {
        com.xnx3.wangmarket.admin.entity.Template template = null;
        if (templateVO != null && templateVO.getTemplate() != null) {
            template = templateVO.getTemplate();
        }
        this.templateCMS(site, template);
    }

    public TemplateCMS(Site site, com.xnx3.wangmarket.admin.entity.Template template) {
        this.templateCMS(site, template);
    }

    private void templateCMS(Site site, com.xnx3.wangmarket.admin.entity.Template template) {
        this.linuxTime = DateUtil.timeForUnix10();
        this.site = site;
        this.template = template;
        if (SystemUtil.get((String)"MASTER_SITE_URL") != null && SystemUtil.get((String)"MASTER_SITE_URL").equals("http://wang.market/")) {
            if (site.getId() - 255 > 0) {
                this.generateUrlRule = "code";
            }
            if (site.getId() - 218 == 0) {
                this.generateUrlRule = "code";
            }
        } else {
            this.generateUrlRule = "code";
        }
        this.generateHtmlInterface = new DefaultGenerateHtmlInterfaceImpl(site);
    }

    public TemplateCMS(Site site, boolean editMode) {
        this.linuxTime = DateUtil.timeForUnix10();
        this.site = site;
        this.editMode = editMode;
        this.generateHtmlInterface = new DefaultGenerateHtmlInterfaceImpl(site);
    }

    public void setGenerateHtmlInterface(GenerateHtmlInterface interfaceImpl) {
        this.generateHtmlInterface = interfaceImpl;
    }

    public void setSiteVar(JSONObject siteVarJson) {
        if (siteVarJson == null) {
            this.siteVarJson = new JSONObject();
            return;
        }
        this.siteVarJson = siteVarJson;
    }

    public String replacePublicTag(String text) {
        text = this.replaceSiteVar(text);
        text = Template.replaceAll(text, TemplateCMS.regex("OSSUrl"), AttachmentUtil.netUrl());
        text = Template.replaceAll(text, TemplateCMS.regex("AttachmentFileUrl"), AttachmentUtil.netUrl());
        text = Template.replaceAll(text, TemplateCMS.regex("resUrl"), AttachmentUtil.netUrl());
        text = Template.replaceAll(text, TemplateCMS.regex("linuxTime"), this.linuxTime + "");
        text = Template.replaceAll(text, TemplateCMS.regex("masterSiteUrl"), SystemUtil.get((String)"MASTER_SITE_URL"));
        text = Template.replaceAll(text, TemplateCMS.regex("siteId"), this.site.getId() + "");
        text = Template.replaceAll(text, TemplateCMS.regex("siteDomain"), this.site.getDomain());
        text = Template.replaceAll(text, TemplateCMS.regex("siteName"), this.site.getName());
        text = Template.replaceAll(text, TemplateCMS.regex("siteTemplateId"), this.site.getTemplateId() + "");
        text = Template.replaceAll(text, TemplateCMS.regex("site.name"), this.site.getName());
        text = Template.replaceAll(text, TemplateCMS.regex("site.id"), this.site.getId() + "");
        text = Template.replaceAll(text, TemplateCMS.regex("site.domain"), this.site.getDomain());
        text = Template.replaceAll(text, TemplateCMS.regex("site.templateId"), this.site.getTemplateId() + "");
        text = Template.replaceAll(text, TemplateCMS.regex("site.username"), this.site.getUsername());
        text = Template.replaceAll(text, TemplateCMS.regex("site.phone"), this.site.getPhone());
        text = Template.replaceAll(text, TemplateCMS.regex("site.qq"), this.site.getQq());
        text = Template.replaceAll(text, TemplateCMS.regex("site.keywords"), this.site.getKeywords());
        text = Template.replaceAll(text, TemplateCMS.regex("site.address"), this.site.getAddress());
        text = Template.replaceAll(text, TemplateCMS.regex("site.companyName"), this.site.getCompanyName());
        text = Template.replaceAll(text, TemplateCMS.regex("masterSiteUrl"), SystemUtil.get((String)"MASTER_SITE_URL"));
        text = Template.replaceAll(text, TemplateCMS.regex("templatePath"), this.getTemplatePath());
        return text;
    }

    public String replaceSiteVar(String text) {
        if (this.siteVarJson == null) {
            return text;
        }
        if (text == null) {
            return null;
        }
        if (text.indexOf("{var.") > -1) {
            Pattern p = Pattern.compile(TemplateCMS.regex("var\\.(.*?)"));
            Matcher m = p.matcher(text);
            while (m.find()) {
                String name = m.group(1);
                String reg = TemplateCMS.regex("var." + name);
                String value = null;
                value = this.siteVarJson.get(name) != null ? this.siteVarJson.getJSONObject(name).getString("value") : "";
                text = Template.replaceAll(text, reg, value);
            }
        }
        return text;
    }

    private String getDomain() {
        if (this.site.getBindDomain() != null && this.site.getBindDomain().length() > 0) {
            return "http://" + this.site.getBindDomain();
        }
        return "http://" + this.site.getDomain() + ".wang.market";
    }

    public String assemblyTemplateVarByOriginal(String text, Map<String, TemplateVarVO> templateVarVOMap) {
        Pattern p = Pattern.compile(TemplateCMS.regex("include=(.*?)"));
        Matcher m = p.matcher(text);
        while (m.find()) {
            String templateVarName = m.group(1);
            String content = null;
            content = templateVarVOMap.get(templateVarName) != null ? templateVarVOMap.get(templateVarName).getTemplateVarData().getText() : "\u6a21\u7248\u53d8\u91cf" + templateVarName + "\u4e0d\u5b58\u5728";
            String reg = TemplateCMS.regex("include=" + templateVarName);
            text = Template.replaceAll(text, reg, "<!--templateVarStart--><!--templateVarName=" + templateVarName + "-->" + content + "<!--templateVarEnd-->");
        }
        return text;
    }

    public String assemblyTemplateVar(String text, Map<String, String> map) {
        Pattern p = Pattern.compile(TemplateCMS.regex("include=(.*?)"));
        Matcher m = p.matcher(text);
        while (m.find()) {
            String templateVarName = m.group(1);
            String content = null;
            content = map.get(templateVarName) != null ? map.get(templateVarName) : "\u6a21\u7248\u53d8\u91cf" + templateVarName + "\u4e0d\u5b58\u5728";
            String reg = TemplateCMS.regex("include=" + templateVarName);
            text = Template.replaceAll(text, reg, "<!--templateVarStart--><!--templateVarName=" + templateVarName + "-->" + content + "<!--templateVarEnd-->");
        }
        return text;
    }

    public String replaceNewsText(String text) {
        if (text == null) {
            return "";
        }
        text = Template.replaceAll(text, TemplateCMS.regex("prefixUrl"), AttachmentUtil.netUrl() + "site/" + this.site.getId() + "/");
        return text;
    }

    public String replaceSiteColumnTag(String text, SiteColumn siteColumn) {
        if (siteColumn == null) {
            return text;
        }
        text = Template.replaceAll(text, TemplateCMS.regex("siteColumn.id"), siteColumn.getId() + "");
        text = Template.replaceAll(text, TemplateCMS.regex("siteColumn.name"), siteColumn.getName());
        text = Template.replaceAll(text, TemplateCMS.regex("siteColumn.type"), siteColumn.getType() + "");
        text = Template.replaceAll(text, TemplateCMS.regex("siteColumn.used"), siteColumn.getUsed() + "");
        text = Template.replaceAll(text, TemplateCMS.regex("siteColumn.codeName"), siteColumn.getCodeName());
        text = Template.replaceAll(text, TemplateCMS.regex("siteColumn.parentCodeName"), siteColumn.getParentCodeName() == null || siteColumn.getParentCodeName().equals("") ? siteColumn.getCodeName() : siteColumn.getParentCodeName());
        text = Template.replaceAll(text, TemplateCMS.regex("siteColumn.icon"), (siteColumn.getIcon() == null ? "" : siteColumn.getIcon()).replace("{templatePath}", this.getTemplatePath()));
        text = Template.replaceAll(text, TemplateCMS.regex("siteColumn.keywords"), siteColumn.getKeywords() == null ? "" : siteColumn.getKeywords());
        text = Template.replaceAll(text, TemplateCMS.regex("siteColumn.description"), siteColumn.getDescription() == null ? "" : siteColumn.getDescription());
        String url = "";
        if (this.generateUrlRule.equals("code")) {
            url = siteColumn.getCodeName() + ".html";
        } else if (siteColumn.getType() - SiteColumn.TYPE_LIST == 0 || siteColumn.getType() - SiteColumn.TYPE_NEWS == 0 || siteColumn.getType() - SiteColumn.TYPE_IMAGENEWS == 0) {
            url = "lc" + siteColumn.getId() + "_1.html";
        } else if (siteColumn.getType() - SiteColumn.TYPE_ALONEPAGE == 0 || siteColumn.getType() - SiteColumn.TYPE_PAGE == 0) {
            url = "c" + siteColumn.getId() + ".html";
        }
        text = Template.replaceAll(text, TemplateCMS.regex("siteColumn.url"), url);
        return text;
    }

    public String replaceNewsTag(String newsText, News news, SiteColumn siteColumn, NewsDataBean newsDataBean) {
        String titlePic = news.getTitlepic();
        if (titlePic == null) {
            titlePic = SystemUtil.get((String)"MASTER_SITE_URL") + "default/aboutUs.jpg";
        }
        String text = Template.replaceAll(newsText, TemplateCMS.regex("news.id"), news.getId() + "");
        text = Template.replaceAll(text, TemplateCMS.regex("news.addtime"), DateUtil.intToString((int)news.getAddtime(), (String)"yyyy-MM-dd"));
        text = Template.replaceAll(text, TemplateCMS.regex("news.title"), news.getTitle());
        text = Template.replaceAll(text, TemplateCMS.regex("news.intro"), news.getIntro() + "");
        text = Template.replaceAll(text, TemplateCMS.regex("news.cid"), news.getCid() + "");
        text = Template.replaceAll(text, TemplateCMS.regex("news.reserve1"), news.getReserve1());
        text = Template.replaceAll(text, TemplateCMS.regex("news.reserve2"), news.getReserve2());
        if (titlePic.indexOf("//") != 0 && titlePic.indexOf("http://") != 0 && titlePic.indexOf("https://") != 0) {
            titlePic = "news/" + titlePic;
        }
        text = Template.replaceAll(text, TemplateCMS.regex("news.titlepic"), titlePic);
        text = this.generateUrlRule.equals("code") ? (siteColumn.getType() - SiteColumn.TYPE_ALONEPAGE == 0 || siteColumn.getType() - SiteColumn.TYPE_PAGE == 0 ? Template.replaceAll(text, TemplateCMS.regex("news.url"), siteColumn.getCodeName() + ".html") : Template.replaceAll(text, TemplateCMS.regex("news.url"), news.getId() + ".html")) : (siteColumn.getType() - SiteColumn.TYPE_ALONEPAGE == 0 || siteColumn.getType() - SiteColumn.TYPE_PAGE == 0 ? Template.replaceAll(text, TemplateCMS.regex("news.url"), "c" + siteColumn.getId() + ".html") : Template.replaceAll(text, TemplateCMS.regex("news.url"), news.getId() + ".html"));
        if (text.indexOf("{news.addtime.") > -1) {
            long time = news.getAddtime().intValue();
            GregorianCalendar c = new GregorianCalendar();
            c.setTime(new Date(time * 1000L));
            text = Template.replaceAll(text, TemplateCMS.regex("news.addtime.year"), c.get(1) + "");
            text = Template.replaceAll(text, TemplateCMS.regex("news.addtime.month"), c.get(2) + 1 + "");
            text = Template.replaceAll(text, TemplateCMS.regex("news.addtime.day"), c.get(5) + "");
            text = Template.replaceAll(text, TemplateCMS.regex("news.addtime.hour"), c.get(11) + "");
            text = Template.replaceAll(text, TemplateCMS.regex("news.addtime.minute"), c.get(12) + "");
            text = Template.replaceAll(text, TemplateCMS.regex("news.addtime.second"), c.get(13) + "");
        }
        if (newsDataBean == null) {
            ConsoleUtil.error((String)("\u6587\u7ae0\u5728news\u4e2d\u6709\uff0c\u5728news_data\u4e2d\u6ca1\u6709\uff01\u6587\u7ae0id:" + news.getId()));
            return text;
        }
        String newsDataText = this.getNewsDataText(newsDataBean);
        if ((text = Template.replaceAll(text, Template.regex("news.text"), newsDataText)).indexOf("{news.extend.") > -1) {
            Pattern p = Pattern.compile(Template.regex("news.extend.(\\w*?)"));
            Matcher m = p.matcher(text);
            HashMap<String, Boolean> map = new HashMap<String, Boolean>();
            while (m.find()) {
                String key = m.group(1);
                map.put(key, true);
            }
            for (Map.Entry entry : map.entrySet()) {
                text = Template.replaceAll(text, Template.regex("news.extend." + (String)entry.getKey()), newsDataBean.getExtendJson((String)entry.getKey()));
            }
        }
        return text;
    }

    public static String regex(String regexString) {
        return "\\{" + regexString + "\\}";
    }

    public String getListItemTemplate(String listTemplate) {
        Pattern p = Pattern.compile("<!--TemplateListItemStart-->([\\s|\\S]*?)<!--TemplateListItemEnd-->");
        Matcher m = p.matcher(listTemplate);
        if (m.find()) {
            String itemTemplate = m.group(1);
            return itemTemplate;
        }
        return "";
    }

    public String getListPageTemplate(String listTemplate) {
        Pattern p = Pattern.compile("<!--TemplateListPageStart-->([\\s|\\S]*?)<!--TemplateListPageEnd-->");
        Matcher m = p.matcher(listTemplate);
        if (m.find()) {
            String itemTemplate = m.group(1);
            return itemTemplate;
        }
        return "";
    }

    public void generateListHtmlForWholeSite(String listTemplateHtml, SiteColumn siteColumn, List<News> newList, Map<Integer, NewsDataBean> newsDataMap, Map<Integer, SiteColumn> columnMapForId) {
        int count = newList.size();
        String listItemTemplate = this.getListItemTemplate(listTemplateHtml);
        int listNum = 12;
        if (siteColumn.getListNum() != null && siteColumn.getListNum() > 0) {
            listNum = siteColumn.getListNum();
        }
        Page page = new Page(count, listNum);
        page.setUrlByStringUrl("");
        for (int i = 1; i <= page.getLastPageNumber() && count >= 0; ++i) {
            page.setCurrentPageNumber(i);
            String currentListHtml = "";
            currentListHtml = this.replaceListPageTag(listTemplateHtml, page, siteColumn);
            if (listItemTemplate != null && listItemTemplate.length() > 0) {
                int currentShowNumber = page.getEveryNumber();
                if (page.getLastPageNumber() == page.getCurrentPageNumber()) {
                    currentShowNumber = count - page.getLimitStart();
                }
                StringBuffer itemsBuffer = new StringBuffer();
                for (int j = 0; j < currentShowNumber; ++j) {
                    int indexJ = 0;
                    indexJ = (page.getCurrentPageNumber() - 1) * page.getEveryNumber() + j;
                    News news = newList.get(indexJ);
                    String newsHTML = this.replaceNewsTag(listItemTemplate, news, siteColumn, newsDataMap.get(news.getId()));
                    if (newsHTML.indexOf("siteColumn") > -1) {
                        newsHTML = this.replaceSiteColumnTag(newsHTML, columnMapForId.get(news.getCid()));
                    }
                    itemsBuffer.append(newsHTML);
                }
                currentListHtml = Template.replaceAll(currentListHtml, "<!--TemplateListItemStart-->([\\s|\\S]*?)<!--TemplateListItemEnd-->", itemsBuffer.toString());
            }
            this.generateHtmlInterface.putStringFile(currentListHtml, this.generateSiteColumnListPageHtmlName(siteColumn, i) + ".html");
        }
    }

    public String generateSiteColumnListPageHtmlName(SiteColumn siteColumn, int currentPageNumber) {
        if (this.generateUrlRule.equals("code")) {
            if (currentPageNumber == 1) {
                return siteColumn.getCodeName();
            }
            return siteColumn.getCodeName() + "_" + currentPageNumber;
        }
        return "lc" + siteColumn.getId() + "_" + currentPageNumber;
    }

    public String generateNewsPageHtmlName(SiteColumn siteColumn, News news) {
        if (news == null) {
            news = new News();
        }
        if (news.getId() == null) {
            news.setId(0);
        }
        if (this.generateUrlRule.equals("code")) {
            if (siteColumn.getType() - SiteColumn.TYPE_ALONEPAGE == 0 || siteColumn.getType() - SiteColumn.TYPE_PAGE == 0) {
                return siteColumn.getCodeName();
            }
            return news.getId() + "";
        }
        if (siteColumn.getType() - SiteColumn.TYPE_ALONEPAGE == 0 || siteColumn.getType() - SiteColumn.TYPE_PAGE == 0) {
            return "c" + news.getCid();
        }
        return news.getId() + "";
    }

    public void generateViewHtmlForTemplateForWholeSite(News news, SiteColumn siteColumn, NewsDataBean newsDataBean, String templateHtml, News upNews, News nextNews) {
        if (templateHtml == null) {
            return;
        }
        String pageHtml = this.replaceSiteColumnTag(templateHtml, siteColumn);
        if (news != null) {
            pageHtml = this.replaceNewsTag(pageHtml, news, siteColumn, newsDataBean);
        }
        this.generateNewsHtml(news, siteColumn, upNews, nextNews, pageHtml, newsDataBean);
    }

    public void generateNewsHtml(News news, SiteColumn siteColumn, News upNews, News nextNews, String pageHtml, NewsDataBean newsDataBean) {
        if (newsDataBean == null) {
            newsDataBean = new NewsDataBean(new NewsData());
        }
        String newsDataText = this.getNewsDataText(newsDataBean);
        pageHtml = Template.replaceAll(pageHtml, Template.regex("text"), newsDataText);
        String generateUrl = "";
        if (siteColumn.getType() - SiteColumn.TYPE_ALONEPAGE == 0 || siteColumn.getType() - SiteColumn.TYPE_PAGE == 0) {
            generateUrl = this.generateNewsPageHtmlName(siteColumn, news) + ".html";
        } else {
            String nextPageUrl;
            String nextPage;
            String upPageUrl;
            String upPage;
            if (upNews == null) {
                if (this.generateUrlRule.equals("code")) {
                    upPage = "<a href=\"" + siteColumn.getCodeName() + ".html\" target=\"_black\">\u8fd4\u56de\u5217\u8868</a>";
                    upPageUrl = siteColumn.getCodeName() + ".html";
                } else {
                    upPage = "<a href=\"lc" + siteColumn.getId() + "_1.html\" target=\"_black\">\u8fd4\u56de\u5217\u8868</a>";
                    upPageUrl = siteColumn.getId() + "_1.html";
                }
            } else {
                upPage = "<a href=\"" + upNews.getId() + ".html\" target=\"_black\">" + upNews.getTitle() + "</a>";
                upPageUrl = upNews.getId() + ".html";
            }
            if (nextNews == null) {
                if (this.generateUrlRule.equals("code")) {
                    nextPage = "<a href=\"" + siteColumn.getCodeName() + ".html\" target=\"_black\">\u8fd4\u56de\u5217\u8868</a>";
                    nextPageUrl = siteColumn.getCodeName() + ".html";
                } else {
                    nextPage = "<a href=\"lc" + siteColumn.getId() + "_1.html\" target=\"_black\">\u8fd4\u56de\u5217\u8868</a>";
                    nextPageUrl = siteColumn.getId() + "_1.html";
                }
            } else {
                nextPage = "<a href=\"" + nextNews.getId() + ".html\" target=\"_black\">" + nextNews.getTitle() + "</a>";
                nextPageUrl = nextNews.getId() + ".html";
            }
            pageHtml = Template.replaceAll(pageHtml, Template.regex("upPage"), upPage);
            pageHtml = Template.replaceAll(pageHtml, Template.regex("nextPage"), nextPage);
            pageHtml = Template.replaceAll(pageHtml, Template.regex("upPageUrl"), upPageUrl);
            pageHtml = Template.replaceAll(pageHtml, Template.regex("nextPageUrl"), nextPageUrl);
            generateUrl = this.generateNewsPageHtmlName(siteColumn, news) + ".html";
        }
        this.generateHtmlInterface.putStringFile(pageHtml, generateUrl);
    }

    public String replaceListPageTag(String pageTemplateHtml, Page page, SiteColumn siteColumn) {
        if (pageTemplateHtml == null || pageTemplateHtml.length() == 0) {
            return "";
        }
        String text = this.replaceSiteColumnTag(pageTemplateHtml, siteColumn);
        text = Template.replaceAll(text, TemplateCMS.regex("page.allRecordNumber"), page.getAllRecordNumber() + "");
        text = Template.replaceAll(text, TemplateCMS.regex("page.currentPageNumber"), page.getCurrentPageNumber() + "");
        text = Template.replaceAll(text, TemplateCMS.regex("page.lastPageNumber"), page.getLastPageNumber() + "");
        text = Template.replaceAll(text, TemplateCMS.regex("page.haveNextPage"), page.isHaveNextPage() + "");
        text = Template.replaceAll(text, TemplateCMS.regex("page.haveUpPage"), page.isHaveUpPage() + "");
        if (this.generateUrlRule.equals("code")) {
            text = Template.replaceAll(text, TemplateCMS.regex("page.firstPage"), siteColumn.getCodeName() + ".html");
            text = page.getNextPageNumber() > 1 ? Template.replaceAll(text, TemplateCMS.regex("page.nextPage"), siteColumn.getCodeName() + "_" + page.getNextPageNumber() + ".html") : Template.replaceAll(text, TemplateCMS.regex("page.nextPage"), siteColumn.getCodeName() + ".html");
            text = page.getLastPageNumber() > 1 ? Template.replaceAll(text, TemplateCMS.regex("page.lastPage"), siteColumn.getCodeName() + "_" + page.getLastPageNumber() + ".html") : Template.replaceAll(text, TemplateCMS.regex("page.lastPage"), siteColumn.getCodeName() + ".html");
            text = page.getUpPageNumber() == 1 ? Template.replaceAll(text, TemplateCMS.regex("page.upPage"), siteColumn.getCodeName() + ".html") : Template.replaceAll(text, TemplateCMS.regex("page.upPage"), siteColumn.getCodeName() + "_" + page.getUpPageNumber() + ".html");
            String upList = "";
            for (int i = 0; i < page.getUpList().size(); ++i) {
                TagA tagA = (TagA)page.getUpList().get(i);
                upList = tagA.getPageNumber() - 1 == 0 ? upList + "<li class=\"page_pageList\"><a href=" + siteColumn.getCodeName() + ".html>" + tagA.getTitle() + "</a></li>" : upList + "<li class=\"page_pageList\"><a href=" + siteColumn.getCodeName() + "_" + tagA.getPageNumber() + ".html>" + tagA.getTitle() + "</a></li>";
            }
            text = Template.replaceAll(text, TemplateCMS.regex("page.upList"), upList);
            String nextList = "";
            for (int i = 0; i < page.getNextList().size(); ++i) {
                TagA tagA = (TagA)page.getNextList().get(i);
                nextList = nextList + "<li class=\"page_pageList\"><a href=" + siteColumn.getCodeName() + "_" + tagA.getPageNumber() + ".html>" + tagA.getTitle() + "</a></li>";
            }
            text = Template.replaceAll(text, TemplateCMS.regex("page.nextList"), nextList);
        } else {
            text = Template.replaceAll(text, TemplateCMS.regex("page.firstPage"), "lc" + siteColumn.getId() + "_1.html");
            text = Template.replaceAll(text, TemplateCMS.regex("page.nextPage"), "lc" + siteColumn.getId() + "_" + page.getNextPageNumber() + ".html");
            text = Template.replaceAll(text, TemplateCMS.regex("page.lastPage"), "lc" + siteColumn.getId() + "_" + page.getLastPageNumber() + ".html");
            text = Template.replaceAll(text, TemplateCMS.regex("page.upPage"), "lc" + siteColumn.getId() + "_" + page.getUpPageNumber() + ".html");
            String upList = "";
            for (int i = 0; i < page.getUpList().size(); ++i) {
                TagA tagA = (TagA)page.getUpList().get(i);
                upList = upList + "<li class=\"page_pageList\"><a href=lc" + siteColumn.getId() + "_" + tagA.getPageNumber() + ".html>" + tagA.getTitle() + "</a></li>";
            }
            text = Template.replaceAll(text, TemplateCMS.regex("page.upList"), upList);
            String nextList = "";
            for (int i = 0; i < page.getNextList().size(); ++i) {
                TagA tagA = (TagA)page.getNextList().get(i);
                nextList = nextList + "<li class=\"page_pageList\"><a href=lc" + siteColumn.getId() + "_" + tagA.getPageNumber() + ".html>" + tagA.getTitle() + "</a></li>";
            }
            text = Template.replaceAll(text, TemplateCMS.regex("page.nextList"), nextList);
        }
        return text;
    }

    public String replaceSiteColumnBlock(String templateHTML, Map<String, List<News>> columnNewsMap, Map<String, SiteColumn> columnMap, Map<String, SiteColumnTreeVO> columnTreeMap, boolean codeRetainDynamicTag, SiteColumn currentSiteColumn, Map<Integer, NewsDataBean> newsDataMap) {
        Pattern p = Pattern.compile("<!--SiteColumn_Start-->([\\s|\\S]*?)<!--SiteColumn_End-->");
        Matcher m = p.matcher(templateHTML);
        while (m.find()) {
            SiteColumn siteColumn;
            String siteColumnTemplate = m.group(1);
            String codeName = Template.getConfigValue(siteColumnTemplate, "codeName");
            if (codeName.indexOf("{") > -1) {
                if (codeRetainDynamicTag) continue;
                if (currentSiteColumn != null) {
                    codeName = this.replaceSiteColumnTag(codeName, currentSiteColumn);
                }
            }
            if (((siteColumn = columnMap.get(codeName)) != null || siteColumn == null && codeName.equals("")) && siteColumnTemplate.indexOf("<!--SubColumnList_Start-->") > -1) {
                String subColumnListTemp = Template.getAnnoCenterString(siteColumnTemplate, "SubColumnList");
                int number = Template.getConfigValue(subColumnListTemp, "number", 6);
                int start_number = Template.getConfigValue(subColumnListTemp, "start_number", 0);
                String itemTemp = Template.getAnnoCenterString(subColumnListTemp, "List");
                StringBuffer itemBuffer = new StringBuffer();
                List<Object> scList = null;
                if (codeName.length() == 0) {
                    scList = new ArrayList();
                    for (Map.Entry<String, SiteColumnTreeVO> entry : columnTreeMap.entrySet()) {
                        SiteColumnTreeVO sct = entry.getValue();
                        if (sct.getLevel() != 1 || sct.getSiteColumn().getUsed() - SiteColumn.USED_ENABLE != 0) continue;
                        scList.add((Object)sct);
                    }
                    Collections.sort(scList, new Comparator<SiteColumnTreeVO>(){

                        @Override
                        public int compare(SiteColumnTreeVO sc1, SiteColumnTreeVO sc2) {
                            return sc1.getSiteColumn().getRank() - sc2.getSiteColumn().getRank();
                        }
                    });
                } else {
                    SiteColumnTreeVO stvo = columnTreeMap.get(codeName);
                    scList = stvo != null ? stvo.getList() : new ArrayList();
                }
                for (int i = 0; i < scList.size(); ++i) {
                    SiteColumn subColumn = ((SiteColumnTreeVO)((Object)scList.get(i))).getSiteColumn();
                    if (subColumn.getUsed() != null && subColumn.getUsed() - SiteColumn.USED_UNABLE == 0 || subColumn.getTemplateCodeColumnUsed() != null && subColumn.getTemplateCodeColumnUsed() - SiteColumn.USED_UNABLE == 0) continue;
                    String subColumnNewsTemp = this.replaceSiteColumnTag(subColumnListTemp, subColumn);
                    String str = this.replaceSiteColumnBlock_replaceNews(subColumnNewsTemp, start_number, number, itemTemp, columnNewsMap, subColumn, newsDataMap);
                    itemBuffer.append(str);
                }
                siteColumnTemplate = StringUtil.subStringReplace((String)siteColumnTemplate, (String)"<!--SubColumnList_Start-->", (String)"<!--SubColumnList_End-->", (String)itemBuffer.toString());
            }
            if (siteColumn != null) {
                if (siteColumnTemplate.indexOf("<!--List_Start-->") > -1) {
                    int number = Template.getConfigValue(siteColumnTemplate, "number", 6);
                    int start_number = Template.getConfigValue(siteColumnTemplate, "start_number", 0);
                    String itemTemp = Template.getAnnoCenterString(siteColumnTemplate, "List");
                    siteColumnTemplate = this.replaceSiteColumnBlock_replaceNews(siteColumnTemplate, start_number, number, itemTemp, columnNewsMap, siteColumn, newsDataMap);
                }
                siteColumnTemplate = this.replaceSiteColumnTag(siteColumnTemplate, siteColumn);
            }
            templateHTML = StringUtil.subStringReplace((String)templateHTML, (String)"<!--SiteColumn_Start-->", (String)"<!--SiteColumn_End-->", (String)siteColumnTemplate);
        }
        return templateHTML;
    }

    private String replaceSiteColumnBlock_replaceNews(String newsListTemplate, int start_number, int number, String itemTemp, Map<String, List<News>> columnNewsMap, SiteColumn siteColumn, Map<Integer, NewsDataBean> newsDataMap) {
        if (newsListTemplate == null) {
            return "";
        }
        if (newsListTemplate.indexOf("<!--List_Start-->") > -1) {
            StringBuffer itemBuffer = new StringBuffer();
            List<News> list = columnNewsMap.get(siteColumn.getCodeName());
            if (start_number < 0) {
                start_number = 0;
            }
            int zongshu = number + start_number;
            for (int i = start_number; i < list.size() && i < zongshu; ++i) {
                News news = list.get(i);
                itemBuffer.append(this.replaceNewsTag(itemTemp, news, siteColumn, newsDataMap.get(news.getId())));
            }
            newsListTemplate = StringUtil.subStringReplace((String)(newsListTemplate + " "), (String)"<!--List_Start-->", (String)"<!--List_End-->", (String)itemBuffer.toString());
        }
        return newsListTemplate;
    }

    private String getNewsDataText(NewsDataBean newsDataBean) {
        String newsDataText = newsDataBean.getText();
        if (this.site.getKeywords() != null && this.site.getKeywords().trim().length() > 0) {
            String[] keywords = this.site.getKeywords().split(",");
            for (int i = 0; i < keywords.length; ++i) {
                String keyword = keywords[i].trim();
                if (keyword.length() <= 0) continue;
                newsDataText = Template.replaceAll(newsDataText, keyword, "<a href=\"http://" + this.site.getBindDomain() + "\" class=\"keyword\">" + keyword + "</a>");
            }
        }
        newsDataText = this.replaceNewsText(newsDataText);
        return newsDataText;
    }

    static {
        TEMPLATE_PRIVATE_PATH = SystemUtil.get((String)"ATTACHMENT_FILE_URL") + "websiteTemplate/";
        TEMPLATE_CLOUD_PATH = "//cloudtemplate.weiunity.com/websiteTemplate/";
    }
}

