/*
 * Decompiled with CFR 0.152.
 */
package com.xnx3.wangmarket.admin.cache;

import com.xnx3.FileUtil;
import com.xnx3.Lang;
import com.xnx3.j2ee.util.AttachmentUtil;
import com.xnx3.j2ee.util.SystemUtil;
import com.xnx3.wangmarket.admin.entity.Site;

public class Template {
    private Site site;
    private int templateId;
    public static final String newHtml = "<!DOCTYPE html>\n<html>\n<head>\n<meta charset=\"utf-8\">\n<title>\u65b0\u5efa\u9875\u9762</title>\n<meta http-equiv=\"X-UA-Compatible\" content=\"IE=edge,chrome=1\">\n<meta name=\"viewport\" content=\"width=device-width, initial-scale=1, maximum-scale=1\">\n<!--XNX3HTMLEDIT--></head>\n<body>\n\n\n\u9875\u9762\u5185\u5bb9\n\n\n</body>\n</html>";

    public Template(Site site) {
        this.site = site;
        this.templateId = site.getTemplateId() != null ? site.getTemplateId() : 0;
    }

    public Template(Site site, boolean editMode) {
        this.site = site;
        this.templateId = site.getTemplateId();
    }

    public String getIndexTemplateHtml_Only() {
        return FileUtil.read((String)(SystemUtil.getProjectPath() + "/static/template/" + this.templateId + "/index.html"));
    }

    public static String replaceHtmlAnnoTag(String text, String htmlTag, String targetContent) {
        if (text == null) {
            return "";
        }
        text = text.replaceAll("\r\n", "{rn}").replaceAll("\n", "{n}").replaceAll("\r", "{r}");
        text = text.replaceAll("(<!--" + htmlTag + "_Start-->.*?<!--" + htmlTag + "_End-->)", "<!--" + htmlTag + "_Start-->" + targetContent + "<!--" + htmlTag + "_End-->");
        text = text.replaceAll(Template.regex("rn"), "\r\n").replaceAll(Template.regex("n"), "\n").replaceAll(Template.regex("r"), "\r");
        return text;
    }

    public static String getAnnoCenterString(String sourceText, String htmlTag) {
        return Lang.subString((String)sourceText, (String)("<!--" + htmlTag + "_Start-->"), (String)("<!--" + htmlTag + "_End-->"), (int)2);
    }

    public static String getAnnoCenterStringById(String sourceText, String htmlTag, String id) {
        return Lang.subString((String)sourceText, (String)("<!--" + htmlTag + "_Start--><!--id=" + id + "-->"), (String)("<!--" + htmlTag + "_End-->"), (int)2);
    }

    public static boolean isAnnoCenterStringById_Have(String sourceText, String htmlTag, String id) {
        return sourceText.indexOf("<!--" + htmlTag + "_Start--><!--id=" + id + "-->") > -1;
    }

    public static boolean isAnnoConfigById_Have(String sourceText, int id) {
        return sourceText.indexOf("<!--id=" + id + "-->") > -1;
    }

    public static String getConfigValue(String sourceText, String configName) {
        if (sourceText.indexOf("<!--" + configName + "=") > -1) {
            return Lang.subString((String)sourceText, (String)("<!--" + configName + "="), (String)"-->", (int)2);
        }
        return "";
    }

    public static String setConfigValue(String sourceText, String configName, String configValue) {
        String value = Template.getConfigValue(sourceText, configName);
        return sourceText.replaceAll("<!--" + configName + "=" + value + "-->", "<!--" + configName + "=" + configValue + "-->");
    }

    public static int getConfigValue(String sourceText, String configName, int defaultValue) {
        return Lang.stringToInt((String)Template.getConfigValue(sourceText, configName), (int)defaultValue);
    }

    public static String regex(String regexString) {
        return "\\{" + regexString + "\\}";
    }

    public String replaceForEditModeTag(String text) {
        text = text.replaceAll("src=\"data", "src=\"" + AttachmentUtil.netUrl() + "site/" + this.site.getId() + "/data");
        text = text.replaceAll("\"news/", "\"" + AttachmentUtil.netUrl() + "site/" + this.site.getId() + "/news/");
        text = text.replaceAll("\"images/", "\"" + AttachmentUtil.netUrl() + "site/" + this.site.getId() + "/images/");
        text = text.replaceAll("controllerRegEditMode", "edit");
        text = text.replaceAll(Template.regex("_masterSiteUrl"), SystemUtil.get((String)"MASTER_SITE_URL"));
        return text;
    }

    public static String replaceAll(String sourceText, String regex, String replacement) {
        if (sourceText == null) {
            return null;
        }
        if (regex == null || replacement == null) {
            return sourceText;
        }
        replacement = replacement.replaceAll("\\$", "\\\\\\$");
        return sourceText.replaceAll(regex, replacement);
    }
}

