/*
 * Decompiled with CFR 0.152.
 */
package com.xnx3.wangmarket.admin.cache;

import com.xnx3.DateUtil;
import com.xnx3.FileUtil;
import com.xnx3.bean.TagA;
import com.xnx3.j2ee.util.AttachmentUtil;
import com.xnx3.j2ee.util.Page;
import com.xnx3.j2ee.util.SystemUtil;
import com.xnx3.wangmarket.admin.cache.Template;
import com.xnx3.wangmarket.admin.entity.News;
import com.xnx3.wangmarket.admin.entity.Site;
import com.xnx3.wangmarket.admin.entity.SiteColumn;
import com.xnx3.wangmarket.admin.entity.SiteData;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GenerateHTML {
    private int linuxTime = DateUtil.timeForUnix10();
    public int templateId;
    private Site site;
    private boolean editMode;
    public static Map<String, String> commonMap = new HashMap<String, String>();
    private String columnAList = null;

    public GenerateHTML(Site site) {
        this.templateId = site.getTemplateId() != null ? site.getTemplateId() : 0;
        this.site = site;
        this.editMode = false;
    }

    public void setEditMode(boolean editMode) {
        this.editMode = editMode;
    }

    public String wapIndex() {
        String pageHtml = FileUtil.read((String)(SystemUtil.getProjectPath() + "/static/template/" + this.templateId + "/index.html"));
        pageHtml = this.assemblyCommon(pageHtml);
        pageHtml = this.replacePublicTag(pageHtml);
        pageHtml = pageHtml.replaceAll(GenerateHTML.regex("title"), this.site.getName());
        return pageHtml;
    }

    public String pcIndex() {
        String pageHtml = FileUtil.read((String)(SystemUtil.getProjectPath() + "/static/template/" + this.templateId + "/index.html"));
        pageHtml = this.assemblyCommon(pageHtml);
        pageHtml = this.replacePublicTag(pageHtml);
        pageHtml = pageHtml.replaceAll(GenerateHTML.regex("title"), this.site.getName());
        return pageHtml;
    }

    public String replacePublicTag(String text) {
        text = text.replaceAll(GenerateHTML.regex("OSSUrl"), AttachmentUtil.netUrl());
        text = text.replaceAll(GenerateHTML.regex("AttachmentFileUrl"), AttachmentUtil.netUrl());
        text = text.replaceAll(GenerateHTML.regex("resUrl"), AttachmentUtil.netUrl());
        text = text.replaceAll(GenerateHTML.regex("linuxTime"), this.linuxTime + "");
        text = text.replaceAll(GenerateHTML.regex("masterSiteUrl"), SystemUtil.get((String)"MASTER_SITE_URL"));
        text = text.replaceAll(GenerateHTML.regex("siteId"), this.site.getId() + "");
        text = text.replaceAll(GenerateHTML.regex("siteDomain"), this.site.getDomain());
        text = text.replaceAll(GenerateHTML.regex("siteName"), this.site.getName());
        text = text.replaceAll(GenerateHTML.regex("siteTemplateId"), this.site.getTemplateId() + "");
        text = text.replaceAll(GenerateHTML.regex("site.name"), this.site.getName());
        text = text.replaceAll(GenerateHTML.regex("site.id"), this.site.getId() + "");
        text = text.replaceAll(GenerateHTML.regex("site.domain"), this.site.getDomain());
        text = text.replaceAll(GenerateHTML.regex("site.templateId"), this.site.getTemplateId() + "");
        text = text.replaceAll(GenerateHTML.regex("site.username"), this.site.getUsername());
        text = text.replaceAll(GenerateHTML.regex("site.phone"), this.site.getPhone());
        text = text.replaceAll(GenerateHTML.regex("site.qq"), this.site.getQq());
        text = text.replaceAll(GenerateHTML.regex("site.keywords"), this.site.getKeywords());
        text = text.replaceAll(GenerateHTML.regex("site.address"), this.site.getAddress());
        text = text.replaceAll(GenerateHTML.regex("site.companyName"), this.site.getCompanyName());
        this.publicTag_init_ColumnAList();
        text = text.replaceAll(GenerateHTML.regex("columnAList"), this.columnAList);
        if (this.editMode) {
            text = text.replaceAll(GenerateHTML.regex("basePath"), SystemUtil.get((String)"MASTER_SITE_URL"));
            text = text.replaceAll(GenerateHTML.regex("edit"), "edit");
            text = text.replaceAll(GenerateHTML.regex("ossEditUrl"), AttachmentUtil.netUrl() + "site/" + this.site.getId() + "/");
            text = text.replaceAll(GenerateHTML.regex("editLinuxTime"), "?v=" + DateUtil.timeForUnix10());
        } else {
            text = text.replaceAll(GenerateHTML.regex("basePath"), AttachmentUtil.netUrl() + "site/" + this.site.getId() + "/");
            text = text.replaceAll(GenerateHTML.regex("edit"), "");
            text = text.replaceAll(GenerateHTML.regex("ossEditUrl"), "");
            text = text.replaceAll(GenerateHTML.regex("editLinuxTime"), "");
        }
        return text;
    }

    private void publicTag_init_ColumnAList() {
        if (this.columnAList == null) {
            this.columnAList = "";
            String cal = this.site.getColumnId();
            if (cal != null && cal.indexOf(",") > -1) {
                String[] calA = cal.split(",");
                for (int i = 0; i < calA.length; ++i) {
                    if (calA[i].length() <= 0) continue;
                    this.columnAList = this.columnAList + "<a href=\"lc" + calA[i] + "_1.html\">" + calA[i] + "</a>";
                }
            }
        }
    }

    public String assemblyCommon(String text) {
        Pattern p = Pattern.compile(GenerateHTML.regex("include=(.*?)"));
        Matcher m = p.matcher(text);
        while (m.find()) {
            String templateVarName = m.group(1);
            String key = this.templateId + templateVarName;
            String templateVarText = commonMap.get(key);
            templateVarText = FileUtil.read((String)(SystemUtil.getProjectPath() + "/static/template/" + this.templateId + "/common/" + templateVarName + ".html"));
            commonMap.put(key, templateVarText);
            String reg = GenerateHTML.regex("include=" + templateVarName);
            text = text.replaceAll(reg, templateVarText);
        }
        return text;
    }

    public static String regex(String regexString) {
        return "\\{" + regexString + "\\}";
    }

    public String replaceSiteColumnTag(String text, SiteColumn siteColumn) {
        if (siteColumn == null) {
            return text;
        }
        text = text.replaceAll(GenerateHTML.regex("siteColumn.id"), siteColumn.getId() + "");
        text = text.replaceAll(GenerateHTML.regex("siteColumn.name"), siteColumn.getName());
        text = text.replaceAll(GenerateHTML.regex("siteColumn.type"), siteColumn.getType() + "");
        text = text.replaceAll(GenerateHTML.regex("siteColumn.used"), siteColumn.getUsed() + "");
        String url = siteColumn.getUrl();
        if (siteColumn.getType() - SiteColumn.TYPE_NEWS == 0 || siteColumn.getType() - SiteColumn.TYPE_IMAGENEWS == 0) {
            url = "lc" + siteColumn.getId() + "_1.html";
        } else if (siteColumn.getType() - SiteColumn.TYPE_PAGE == 0) {
            url = "c" + siteColumn.getId() + ".html";
        }
        if (url == null) {
            url = "#";
        }
        text = text.replaceAll(GenerateHTML.regex("siteColumn.url"), url);
        return text;
    }

    public String replaceListTag(String text, Page page, SiteColumn siteColumn) {
        text = this.replaceSiteColumnTag(text, siteColumn);
        text = text.replaceAll(GenerateHTML.regex("page.allRecordNumber"), page.getAllRecordNumber() + "");
        text = text.replaceAll(GenerateHTML.regex("page.currentPageNumber"), page.getCurrentPageNumber() + "");
        text = text.replaceAll(GenerateHTML.regex("page.lastPageNumber"), page.getLastPageNumber() + "");
        text = text.replaceAll(GenerateHTML.regex("page.haveNextPage"), page.isHaveNextPage() + "");
        text = text.replaceAll(GenerateHTML.regex("page.haveUpPage"), page.isHaveUpPage() + "");
        if (this.editMode) {
            text = text.replaceAll(GenerateHTML.regex("page.firstPage"), "list.do?cid=" + siteColumn.getId() + "&client=wap&editMode=edit&currentPage=1");
            text = text.replaceAll(GenerateHTML.regex("page.upPage"), "list.do?cid=" + siteColumn.getId() + "&client=wap&editMode=edit&currentPage=" + page.getUpPageNumber());
            text = text.replaceAll(GenerateHTML.regex("page.nextPage"), "list.do?cid=" + siteColumn.getId() + "&client=wap&editMode=edit&currentPage=" + page.getNextPageNumber());
            text = text.replaceAll(GenerateHTML.regex("page.lastPage"), "list.do?cid=" + siteColumn.getId() + "&client=wap&editMode=edit&currentPage=" + page.getLastPageNumber());
            String upList = "";
            for (int i = 0; i < page.getUpList().size(); ++i) {
                TagA tagA = (TagA)page.getUpList().get(i);
                upList = upList + "<li class=\"page_pageList\"><a href=" + tagA.getHref() + ">" + tagA.getTitle() + "</a></li>";
            }
            text = text.replaceAll(GenerateHTML.regex("page.upList"), upList);
            String nextList = "";
            for (int i = 0; i < page.getNextList().size(); ++i) {
                TagA tagA = (TagA)page.getNextList().get(i);
                nextList = nextList + "<li class=\"page_pageList\"><a href=" + tagA.getHref() + ">" + tagA.getTitle() + "</a></li>";
            }
            text = text.replaceAll(GenerateHTML.regex("page.nextList"), nextList);
        } else {
            text = text.replaceAll(GenerateHTML.regex("page.firstPage"), "lc" + siteColumn.getId() + "_1.html");
            text = text.replaceAll(GenerateHTML.regex("page.upPage"), "lc" + siteColumn.getId() + "_" + page.getUpPageNumber() + ".html");
            text = text.replaceAll(GenerateHTML.regex("page.nextPage"), "lc" + siteColumn.getId() + "_" + page.getNextPageNumber() + ".html");
            text = text.replaceAll(GenerateHTML.regex("page.lastPage"), "lc" + siteColumn.getId() + "_" + page.getLastPageNumber() + ".html");
            String upList = "";
            for (int i = 0; i < page.getUpList().size(); ++i) {
                TagA tagA = (TagA)page.getUpList().get(i);
                upList = upList + "<li class=\"page_pageList\"><a href=lc" + siteColumn.getId() + "_" + tagA.getPageNumber() + ".html>" + tagA.getTitle() + "</a></li>";
            }
            text = text.replaceAll(GenerateHTML.regex("page.upList"), upList);
            String nextList = "";
            for (int i = 0; i < page.getNextList().size(); ++i) {
                TagA tagA = (TagA)page.getNextList().get(i);
                nextList = nextList + "<li class=\"page_pageList\"><a href=lc" + siteColumn.getId() + "_" + tagA.getPageNumber() + ".html>" + tagA.getTitle() + "</a></li>";
            }
            text = text.replaceAll(GenerateHTML.regex("page.nextList"), nextList);
        }
        return text;
    }

    public String replaceNewsListItem(String itemText, News news) {
        String titlePic = news.getTitlepic();
        if (titlePic == null) {
            titlePic = SystemUtil.get((String)"MASTER_SITE_URL") + "default/aboutUs.jpg";
        }
        String text = itemText.replaceAll(GenerateHTML.regex("news.id"), news.getId() + "");
        text = text.replaceAll(GenerateHTML.regex("news.addtime"), DateUtil.intToString((int)news.getAddtime(), (String)"yyyy-MM-dd"));
        text = Template.replaceAll(text, GenerateHTML.regex("news.title"), news.getTitle() + "");
        text = Template.replaceAll(text, GenerateHTML.regex("news.intro"), news.getIntro() + "");
        if (this.editMode) {
            if (titlePic.indexOf("http://") == -1) {
                titlePic = AttachmentUtil.netUrl() + "site/" + news.getSiteid() + "/news/" + titlePic;
            }
            text = text.replaceAll(GenerateHTML.regex("news.titlepic"), titlePic);
            text = text.replaceAll(GenerateHTML.regex("news.url"), "news.do?id=" + news.getId() + "&editMode=edit");
        } else {
            if (titlePic.indexOf("http://") == -1) {
                titlePic = "news/" + titlePic;
            }
            text = text.replaceAll(GenerateHTML.regex("news.titlepic"), titlePic);
            text = text.replaceAll(GenerateHTML.regex("news.url"), news.getId() + ".html");
        }
        return text;
    }

    public String getGeneratePcIndexHtml() {
        try {
            Thread.sleep(300L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return AttachmentUtil.getTextByPath((String)("site/" + this.site.getId() + "/index.html"));
    }

    public void generateIndexHtml(String htmlText, SiteData siteData) {
        if (htmlText == null) {
            return;
        }
        if (this.site.getClient() - Site.CLIENT_PC == 0) {
            htmlText = htmlText.replaceAll("<!--templateStyleCss-->", "<link href=\"" + AttachmentUtil.netUrl() + "template/" + this.site.getTemplateId() + "/style.css\" rel=\"stylesheet\" type=\"text/css\">");
        } else {
            htmlText = FileUtil.read((String)(SystemUtil.getProjectPath() + "/static/template/" + this.templateId + "/index.html"));
            htmlText = this.assemblyCommon(htmlText);
            htmlText = this.replacePublicTag(htmlText);
        }
        htmlText = htmlText.replaceAll(GenerateHTML.regex("title"), this.site.getName());
        htmlText = htmlText.replaceAll(GenerateHTML.regex("keywords"), this.site.getKeywords());
        htmlText = htmlText.replaceAll(GenerateHTML.regex("description"), siteData == null ? this.site.getName() : siteData.getIndexDescription());
        this.generateIndexHtml(htmlText);
    }

    public void generateListHtml(String htmlText, SiteColumn siteColumn, int pageNumber) {
        htmlText = htmlText.replaceAll(GenerateHTML.regex("title"), siteColumn.getName() + "_" + this.site.getName());
        htmlText = htmlText.replaceAll(GenerateHTML.regex("keywords"), siteColumn.getName() + "," + this.site.getKeywords());
        htmlText = htmlText.replaceAll(GenerateHTML.regex("description"), siteColumn.getName());
        AttachmentUtil.putStringFile((String)("site/" + this.site.getId() + "/lc" + siteColumn.getId() + "_" + pageNumber + ".html"), (String)htmlText);
    }

    public void generateViewHtml(Site site, News news, SiteColumn siteColumn, String text) {
        String pageHtml = FileUtil.read((String)(SystemUtil.getProjectPath() + "/static/template/" + this.templateId + "/page.html"));
        pageHtml = this.assemblyCommon(pageHtml);
        pageHtml = this.replaceSiteColumnTag(pageHtml, siteColumn);
        pageHtml = this.replacePublicTag(pageHtml);
        pageHtml = this.replaceNewsListItem(pageHtml, news);
        pageHtml = pageHtml.replaceAll(GenerateHTML.regex("title"), news.getTitle() + "_" + site.getName());
        pageHtml = pageHtml.replaceAll(GenerateHTML.regex("keywords"), news.getTitle() + "," + site.getKeywords());
        pageHtml = Template.replaceAll(pageHtml, GenerateHTML.regex("description"), news.getIntro() + "");
        pageHtml = Template.replaceAll(pageHtml, GenerateHTML.regex("text"), this.replaceNewsText(text));
        String generateUrl = "";
        generateUrl = news.getType() - News.TYPE_PAGE == 0 ? "site/" + site.getId() + "/c" + news.getCid() + ".html" : "site/" + site.getId() + "/" + news.getId() + ".html";
        AttachmentUtil.putStringFile((String)generateUrl, (String)pageHtml);
    }

    public String replaceNewsText(String text) {
        if (text == null) {
            return "";
        }
        text = Template.replaceAll(text, GenerateHTML.regex("prefixUrl"), AttachmentUtil.netUrl() + "site/" + this.site.getId() + "/");
        return text;
    }

    public String restoreNewsText(String text) {
        if (text == null) {
            return "";
        }
        text = text.replaceAll("\\{prefixUrl\\}", AttachmentUtil.netUrl() + "site/" + this.site.getId() + "/");
        return text;
    }

    public void generateIndexHtml(String htmlText) {
        AttachmentUtil.putStringFile((String)("site/" + this.site.getId() + "/index.html"), (String)htmlText);
    }
}

