/*
 * Decompiled with CFR 0.152.
 */
package com.xnx3.robot;

import com.xnx3.Lang;
import com.xnx3.SystemUtil;
import com.xnx3.media.ColorUtil;
import com.xnx3.robot.support.CoordBean;
import com.xnx3.robot.support.RgbImageComparerBean;
import com.xnx3.swing.DialogUtil;
import java.awt.AWTException;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;

public class Robot {
    public static int screenWidth;
    public static int screenHeight;
    public static Map<String, BufferedImage> bufferedImageList;
    public static final int SIM_ACCURATE_VERY = 0;
    public static final int SIM_ACCURATE = 31;
    public static final int SIM_BLUR = 61;
    public static final int SIM_BLUR_VERY = 81;
    private Class useClass;
    java.awt.Robot robot;

    public Robot() {
        float v = SystemUtil.getJavaSpecificationVersion();
        if (v > 0.0f && (double)v < 1.7) {
            DialogUtil.showMessageDialog((String)"\u8bf7\u4f7f\u7528 JDK 1.7 \u53ca\u4ee5\u4e0a\u7248\u672c\u8fdb\u884c\u5f00\u53d1\u3002\u63a8\u8350\u4f7f\u7528JDK1.7");
        }
        try {
            this.robot = new java.awt.Robot();
        }
        catch (AWTException e) {
            e.printStackTrace();
        }
    }

    public void setSourcePath(Class c) {
        this.useClass = c;
    }

    public int StringToKey(String key) {
        switch (key) {
            case "a": {
                return 65;
            }
            case "b": {
                return 66;
            }
            case "c": {
                return 67;
            }
            case "d": {
                return 68;
            }
            case "e": {
                return 69;
            }
            case "f": {
                return 70;
            }
            case "g": {
                return 71;
            }
            case "h": {
                return 72;
            }
            case "i": {
                return 73;
            }
            case "j": {
                return 74;
            }
            case "k": {
                return 75;
            }
            case "l": {
                return 76;
            }
            case "m": {
                return 77;
            }
            case "n": {
                return 78;
            }
            case "o": {
                return 79;
            }
            case "p": {
                return 80;
            }
            case "q": {
                return 81;
            }
            case "r": {
                return 82;
            }
            case "s": {
                return 83;
            }
            case "t": {
                return 84;
            }
            case "u": {
                return 85;
            }
            case "v": {
                return 86;
            }
            case "w": {
                return 87;
            }
            case "x": {
                return 88;
            }
            case "y": {
                return 89;
            }
            case "z": {
                return 90;
            }
            case "0": {
                return 48;
            }
            case "1": {
                return 49;
            }
            case "2": {
                return 50;
            }
            case "3": {
                return 51;
            }
            case "4": {
                return 52;
            }
            case "5": {
                return 53;
            }
            case "6": {
                return 54;
            }
            case "7": {
                return 55;
            }
            case "8": {
                return 56;
            }
            case "9": {
                return 57;
            }
            case ".": {
                return 46;
            }
        }
        return 0;
    }

    public void press(int key) {
        this.robot.keyPress(key);
        this.robot.delay(5);
        this.robot.keyRelease(key);
    }

    public void press(int key1, int key2) {
        this.robot.keyPress(key1);
        this.robot.delay(5);
        this.robot.keyPress(key2);
        this.robot.keyRelease(key1);
        this.robot.keyRelease(key2);
    }

    public java.awt.Robot getRobot() {
        return this.robot;
    }

    public void sendString(String text) {
        for (int i = 0; i < text.length(); ++i) {
            String s = text.substring(i, i + 1);
            int key = this.StringToKey(s);
            if (key == 0) {
                switch (s) {
                    case "!": {
                        this.press(16, 49);
                        break;
                    }
                    case "@": {
                        this.press(16, 50);
                        break;
                    }
                    case "#": {
                        this.press(16, 51);
                        break;
                    }
                    case "$": {
                        this.press(16, 52);
                        break;
                    }
                    case "%": {
                        this.press(16, 53);
                        break;
                    }
                    case "^": {
                        this.press(16, 54);
                        break;
                    }
                    case "&": {
                        this.press(16, 55);
                        break;
                    }
                    case "*": {
                        this.press(16, 56);
                        break;
                    }
                    case "(": {
                        this.press(16, 57);
                        break;
                    }
                    case ")": {
                        this.press(16, 48);
                        break;
                    }
                    case "_": {
                        this.press(16, 45);
                        break;
                    }
                    case ":": {
                        this.press(16, 59);
                        break;
                    }
                }
                continue;
            }
            this.press(key);
        }
    }

    public void mouseLeftClick(int x, int y) {
        this.mouseClick(x, y, 16);
    }

    public void mouseRightClick(int x, int y) {
        this.mouseClick(x, y, 4);
    }

    public void delay(int ms) {
        this.robot.delay(ms);
    }

    public void mouseClick(int x, int y, int buttons) {
        this.robot.mouseMove(x, y);
        this.robot.delay(20);
        this.robot.mousePress(buttons);
        this.robot.delay(20);
        this.robot.mouseRelease(buttons);
    }

    public void mousePressRight() {
        this.robot.mousePress(4);
    }

    public void mouseReleaseRight() {
        this.robot.mousePress(4);
    }

    public void mousePressLeft() {
        this.robot.mousePress(16);
    }

    public void mouseReleaseLeft() {
        this.robot.mousePress(16);
    }

    public void mouseWheel(int wheelAmt) {
        this.robot.mouseWheel(wheelAmt);
    }

    public boolean imageDelaySearch(int xStart, int yStart, int xEnd, int yEnd, BufferedImage image, int sim, int maxDelay) {
        for (int time = 0; time < maxDelay; time += 200) {
            List<CoordBean> list = this.imageSearch(xStart, yStart, xEnd, yEnd, image, sim);
            if (list.size() > 0) {
                return true;
            }
            this.delay(200);
        }
        return false;
    }

    public void screenCapture(int xStart, int yStart, int xEnd, int yEnd, String filePath) {
        BufferedImage image = this.robot.createScreenCapture(new Rectangle(xStart, yStart, xEnd - xStart, yEnd - yStart));
        this.saveScreenCapture(image, filePath);
    }

    public BufferedImage screenCapture() {
        return this.robot.createScreenCapture(new Rectangle(0, 0, screenWidth, screenHeight));
    }

    public void screenCapture(String filePath) {
        BufferedImage image = this.robot.createScreenCapture(new Rectangle(0, 0, screenWidth, screenHeight));
        this.saveScreenCapture(image, filePath);
    }

    public void saveScreenCapture(BufferedImage image, String filePath) {
        try {
            ImageIO.write((RenderedImage)image, "png", new File(filePath));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public BufferedImage getResourceImage(String fileName) {
        BufferedImage localImg = bufferedImageList.get(fileName);
        if (localImg != null) {
            return localImg;
        }
        if (this.useClass == null) {
            DialogUtil.showMessageDialog((String)"\u8bf7\u5148\u6267\u884c\u65b9\u6cd5 robot.setResourcePath(Class) \u8bbe\u7f6e\u8d44\u6e90\u8def\u5f84");
            return null;
        }
        try {
            InputStream inputStream = this.useClass.getResourceAsStream("res/" + fileName);
            if (inputStream != null) {
                localImg = ImageIO.read(inputStream);
            }
        }
        catch (FileNotFoundException ee) {
            ee.printStackTrace();
        }
        catch (IOException eee) {
            eee.printStackTrace();
        }
        if (localImg == null) {
            return null;
        }
        bufferedImageList.put(fileName, localImg);
        return localImg;
    }

    public RgbImageComparerBean getPX(BufferedImage bufferedImage) {
        int width = bufferedImage.getWidth();
        int height = bufferedImage.getHeight();
        int minx = bufferedImage.getMinX();
        int miny = bufferedImage.getMinY();
        RgbImageComparerBean rgb = new RgbImageComparerBean();
        int[][] colorArray = new int[width][height];
        for (int i = minx; i < width; ++i) {
            for (int j = miny; j < height; ++j) {
                colorArray[i][j] = bufferedImage.getRGB(i, j);
            }
        }
        rgb.setColorArray(colorArray);
        return rgb;
    }

    public List<CoordBean> imageSearch(int xStart, int yStart, int xEnd, int yEnd, String searchImageName, int sim) {
        String[] names = searchImageName.split("\\|");
        ArrayList<CoordBean> list = new ArrayList<CoordBean>();
        for (int i = 0; i < names.length; ++i) {
            List<CoordBean> l = this.imageSearch(xStart, yStart, xEnd, yEnd, this.getResourceImage(names[i]), sim);
            Lang.listAppend(list, l);
        }
        return list;
    }

    public List<CoordBean> imageSearch(BufferedImage sourceImage, BufferedImage searchImage, int sim) {
        ArrayList<CoordBean> list = new ArrayList<CoordBean>();
        RgbImageComparerBean pxSource = this.getPX(sourceImage);
        RgbImageComparerBean pxSearch = this.getPX(searchImage);
        int[][] px = pxSource.getColorArray();
        int[][] pxS = pxSearch.getColorArray();
        int pxSXMax = pxSearch.getImgWidth() - 1;
        int pxSYMax = pxSearch.getImgHeight() - 1;
        int xSearchEnd = pxSource.getImgWidth() - pxSearch.getImgWidth();
        int ySearchEnd = pxSource.getImgHeight() - pxSearch.getImgHeight();
        int contentSearchX = 1;
        int contentSearchY = 1;
        double pxPercent = 0.99f;
        if (sim > 0) {
            pxPercent = (double)sim / 255.0 / 4.0;
        }
        for (int x = 0; x < xSearchEnd; ++x) {
            for (int y = 0; y < ySearchEnd; ++y) {
                int yes;
                boolean contrast = false;
                if (sim < 32) {
                    int pxY;
                    int pxX;
                    if (this.colorCompare(px[x][y], pxS[0][0], sim) && this.colorCompare(px[pxX = x + pxSearch.getImgWidth() - 1][y], pxS[pxSXMax][0], sim) && this.colorCompare(px[x][pxY = y + pxSearch.getImgHeight() - 1], pxS[0][pxSYMax], sim) && this.colorCompare(px[pxX][pxY], pxS[pxSXMax][pxSYMax], sim)) {
                        if (pxSXMax > 2) {
                            contentSearchX = (int)Math.ceil(pxSXMax / 2);
                        }
                        if (pxSYMax > 2) {
                            contentSearchY = (int)Math.ceil(pxSYMax / 2);
                        }
                        if (this.colorCompare(px[x + contentSearchX][y + contentSearchY], pxS[contentSearchX][contentSearchY], sim)) {
                            contrast = true;
                        }
                    }
                } else {
                    contrast = true;
                }
                if (sim < 62) {
                    int i;
                    if (contrast) {
                        yes = 0;
                        int ySour = y + contentSearchY;
                        for (i = 0; i < pxSearch.getImgWidth(); ++i) {
                            if (!this.colorCompare(px[x + i][ySour], pxS[i][contentSearchY], sim)) continue;
                            ++yes;
                        }
                        contrast = (double)(yes / pxSearch.getImgWidth()) > pxPercent;
                    }
                    if (contrast) {
                        yes = 0;
                        int xSour = x + contentSearchX;
                        for (i = 0; i < pxSearch.getImgHeight(); ++i) {
                            if (!this.colorCompare(px[xSour][y + i], pxS[contentSearchX][i], sim)) continue;
                            ++yes;
                        }
                        contrast = (double)(yes / pxSearch.getImgHeight()) > pxPercent;
                    }
                } else {
                    contrast = true;
                }
                if (!contrast) continue;
                yes = 0;
                for (int xS = 0; xS < pxSearch.getImgWidth(); ++xS) {
                    for (int yS = 0; yS < pxSearch.getImgHeight(); ++yS) {
                        if (!this.colorCompare(px[x + xS][y + yS], pxS[xS][yS], sim)) continue;
                        ++yes;
                    }
                }
                if (!((double)(yes / pxSearch.getPxCount()) > pxPercent)) continue;
                CoordBean coord = new CoordBean();
                coord.setX(x);
                coord.setY(y);
                list.add(coord);
            }
        }
        return list;
    }

    public List<CoordBean> imageSearch(int xStart, int yStart, int xEnd, int yEnd, BufferedImage searchImage, int sim) {
        BufferedImage cutImage = this.robot.createScreenCapture(new Rectangle(xStart, yStart, xEnd - xStart, yEnd - yStart));
        List<CoordBean> list = this.imageSearch(cutImage, searchImage, 31);
        ArrayList<CoordBean> l = new ArrayList<CoordBean>();
        for (int i = 0; i < list.size(); ++i) {
            CoordBean c = list.get(i);
            c.setX(xStart + c.getX());
            c.setY(yStart + c.getY());
            l.add(c);
        }
        return l;
    }

    public List<CoordBean> imageSearch(String imageName, int sim) {
        BufferedImage cutImage = this.robot.createScreenCapture(new Rectangle(0, 0, screenWidth, screenHeight));
        List<CoordBean> list = this.imageSearch(cutImage, this.getResourceImage(imageName), 31);
        return list;
    }

    public boolean colorCompare(Color color1, Color color2, int sim) {
        return Math.abs(color1.getRed() - color2.getRed()) <= sim && Math.abs(color1.getGreen() - color2.getGreen()) <= sim && Math.abs(color1.getBlue() - color2.getBlue()) <= sim;
    }

    public boolean colorCompare(int pxSource, int pxSearch, int sim) {
        if (sim == 0) {
            return pxSearch == pxSource;
        }
        Color sourceRgb = ColorUtil.intToColor((int)pxSource);
        Color searchRgb = ColorUtil.intToColor((int)pxSearch);
        return this.colorCompare(sourceRgb, searchRgb, sim);
    }

    public boolean getColorCompare(int x, int y, String hex, int sim) {
        Color color = this.getPixelColor(x, y);
        Color c2 = ColorUtil.hexToColor((String)hex);
        return this.colorCompare(color, c2, sim);
    }

    public Color getPixelColor(int x, int y) {
        return this.robot.getPixelColor(x, y);
    }

    public static void main(String[] args) {
        Robot robot = new Robot();
        robot.mouseRightClick(499, 400);
    }

    static {
        bufferedImageList = new HashMap<String, BufferedImage>();
        screenWidth = (int)Toolkit.getDefaultToolkit().getScreenSize().getWidth();
        screenHeight = (int)Toolkit.getDefaultToolkit().getScreenSize().getHeight();
    }
}

