/*
 * Decompiled with CFR 0.152.
 */
package com.xnx3.net;

import com.aliyun.oss.OSSClient;
import com.aliyun.oss.model.ListObjectsRequest;
import com.aliyun.oss.model.OSSObjectSummary;
import com.aliyun.oss.model.ObjectListing;
import com.aliyun.oss.model.PutObjectResult;
import com.aliyuncs.AcsRequest;
import com.aliyuncs.DefaultAcsClient;
import com.aliyuncs.exceptions.ClientException;
import com.aliyuncs.http.MethodType;
import com.aliyuncs.http.ProtocolType;
import com.aliyuncs.profile.DefaultProfile;
import com.aliyuncs.profile.IClientProfile;
import com.aliyuncs.sts.model.v20150401.AssumeRoleRequest;
import com.aliyuncs.sts.model.v20150401.AssumeRoleResponse;
import com.xnx3.ConfigManagerUtil;
import com.xnx3.Lang;
import com.xnx3.media.ImageUtil;
import com.xnx3.net.ossbean.PutResult;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;

public class OSSUtil {
    public static String endpoint = "";
    public static String accessKeyId = "";
    public static String accessKeySecret = "";
    public static String bucketName = "";
    public static String roleArn = "";
    public static String url = "";
    public static String region_cn_hangzhou = "cn-hangzhou";
    public static final String sta_api_version = "2015-04-01";
    private static OSSClient ossClient;

    public static void refreshUrl() {
        if (url == null || url.length() == 0) {
            url = bucketName + "." + endpoint;
        }
        if (url.indexOf("://") == -1) {
            url = "http://" + url;
        }
        url = url + "/";
    }

    public static OSSClient getOSSClient() {
        if (ossClient == null) {
            System.out.println("create OSSCLient");
            if (accessKeyId.length() < 10) {
                System.out.println("\u60a8\u672a\u5f00\u542fOSS\u5bf9\u8c61\u5b58\u50a8\u670d\u52a1\uff01\u82e5\u8981\u4f7f\u7528OSS\uff0c\u53ef\u53c2\u8003\uff1ahttp://www.guanleiming.com/2327.html");
                return null;
            }
            ossClient = new OSSClient(endpoint, accessKeyId, accessKeySecret);
        }
        return ossClient;
    }

    public static void createFolder(String folderName) {
        if (folderName.lastIndexOf("/") < folderName.length() - 1) {
            folderName = folderName + "/";
        }
        OSSUtil.getOSSClient().putObject(bucketName, folderName, (InputStream)new ByteArrayInputStream(new byte[0]));
    }

    public static PutResult put(String filePath, String fileName, InputStream inputStream) {
        String fileSuffix = Lang.subString((String)fileName, (String)".", null, (int)3);
        String name = Lang.uuid() + "." + fileSuffix;
        String path = filePath + name;
        PutObjectResult pr = OSSUtil.getOSSClient().putObject(bucketName, path, inputStream);
        return new PutResult(name, path, url + path);
    }

    public static void deleteObject(String filePath) {
        OSSUtil.getOSSClient().deleteObject(bucketName, filePath);
    }

    public static PutResult put(String path, InputStream inputStream) {
        PutObjectResult pr = OSSUtil.getOSSClient().putObject(bucketName, path, inputStream);
        String name = Lang.subString((String)path, (String)"/", null, (int)3);
        return new PutResult(name, path, url + path);
    }

    public static PutResult put(String filePath, String localPath) {
        File file = new File(localPath);
        FileInputStream input = null;
        try {
            input = new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        return OSSUtil.put(filePath, localPath, input);
    }

    public static PutResult putImageByUrl(String filePath, String imageUrl) {
        if (imageUrl == null) {
            return null;
        }
        String suffix = Lang.findFileSuffix((String)imageUrl);
        BufferedImage bufferedImage = ImageUtil.getBufferedImageByUrl((String)imageUrl);
        if (suffix == null) {
            suffix = "jpg";
        }
        return OSSUtil.put(filePath + "." + suffix, ImageUtil.bufferedImageToInputStream((BufferedImage)bufferedImage, (String)suffix));
    }

    public static AssumeRoleResponse.Credentials createSTS(String roleSessionName, String policy) {
        String accessKeyId = OSSUtil.accessKeyId;
        String accessKeySecret = OSSUtil.accessKeySecret;
        ProtocolType protocolType = ProtocolType.HTTPS;
        try {
            AssumeRoleResponse response = OSSUtil.assumeRole(accessKeyId, accessKeySecret, roleArn, roleSessionName, policy, protocolType);
            AssumeRoleResponse.Credentials credentials = response.getCredentials();
            return credentials;
        }
        catch (ClientException e) {
            e.printStackTrace();
            System.out.println("Failed to get a token.");
            System.out.println("Error code: " + e.getErrCode());
            System.out.println("Error message: " + e.getErrMsg());
            return null;
        }
    }

    static AssumeRoleResponse assumeRole(String accessKeyId, String accessKeySecret, String roleArn, String roleSessionName, String policy, ProtocolType protocolType) throws ClientException {
        DefaultProfile profile = DefaultProfile.getProfile((String)region_cn_hangzhou, (String)accessKeyId, (String)accessKeySecret);
        DefaultAcsClient client = new DefaultAcsClient((IClientProfile)profile);
        AssumeRoleRequest request = new AssumeRoleRequest();
        request.setVersion(sta_api_version);
        request.setMethod(MethodType.POST);
        request.setProtocol(protocolType);
        request.setRoleArn(roleArn);
        request.setRoleSessionName(roleSessionName);
        request.setPolicy(policy);
        AssumeRoleResponse response = (AssumeRoleResponse)client.getAcsResponse((AcsRequest)request);
        return response;
    }

    public static PutResult putStringFile(String path, String text, String encode) {
        try {
            return OSSUtil.put(path, new ByteArrayInputStream(text.getBytes(encode)));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static PutResult putStringFile(String path, String text) {
        return OSSUtil.putStringFile(path, text, "UTF-8");
    }

    public static long getFolderSize(String filePath) {
        ListObjectsRequest listObjectsRequest = new ListObjectsRequest(bucketName);
        listObjectsRequest.setPrefix(filePath);
        listObjectsRequest.setMaxKeys(Integer.valueOf(1000));
        boolean have = true;
        String nextMarker = null;
        int size = 0;
        while (have) {
            if (nextMarker != null) {
                listObjectsRequest.setMarker(nextMarker);
            }
            ObjectListing listO = OSSUtil.getOSSClient().listObjects(listObjectsRequest);
            for (OSSObjectSummary objectSummary : listO.getObjectSummaries()) {
                size = (int)((long)size + objectSummary.getSize());
            }
            have = listO.isTruncated();
            nextMarker = listO.getNextMarker();
        }
        return size;
    }

    public static List<OSSObjectSummary> getFolderObjectList(String filePath) {
        ListObjectsRequest listObjectsRequest = new ListObjectsRequest(bucketName);
        listObjectsRequest.setPrefix(filePath);
        listObjectsRequest.setMaxKeys(Integer.valueOf(1000));
        ArrayList<OSSObjectSummary> list = new ArrayList<OSSObjectSummary>();
        boolean have = true;
        String nextMarker = null;
        while (have) {
            if (nextMarker != null) {
                listObjectsRequest.setMarker(nextMarker);
            }
            ObjectListing listO = OSSUtil.getOSSClient().listObjects(listObjectsRequest);
            for (OSSObjectSummary objectSummary : listO.getObjectSummaries()) {
                list.add(objectSummary);
            }
            have = listO.isTruncated();
            nextMarker = listO.getNextMarker();
        }
        return list;
    }

    public static void main(String[] args) throws FileNotFoundException {
        OSSUtil.putStringFile("test.txt", "test");
    }

    static {
        endpoint = ConfigManagerUtil.getSingleton("xnx3Config.xml").getValue("aliyunOSS.endpoint");
        accessKeyId = ConfigManagerUtil.getSingleton("xnx3Config.xml").getValue("aliyunOSS.accessKeyId");
        accessKeySecret = ConfigManagerUtil.getSingleton("xnx3Config.xml").getValue("aliyunOSS.accessKeySecret");
        bucketName = ConfigManagerUtil.getSingleton("xnx3Config.xml").getValue("aliyunOSS.bucketName");
        roleArn = ConfigManagerUtil.getSingleton("xnx3Config.xml").getValue("aliyunOSS.roleArn");
        OSSUtil.refreshUrl();
    }
}

