/*
 * Decompiled with CFR 0.152.
 */
package com.xnx3.net;

import com.sun.mail.util.MailSSLSocketFactory;
import java.security.GeneralSecurityException;
import java.util.Date;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;

public class MailsUtil {
    private Properties properties = new Properties();
    public boolean debug = false;
    public final String BR = "\n";
    private String username;
    private String password;
    private String mailSmtpPort = "25";

    public MailsUtil(String host, String username, String password) {
        this.properties.put("mail.smtp.host", host);
        this.properties.put("mail.smtp.auth", "true");
        this.username = username;
        this.password = password;
    }

    public void setSSLSmtpPort(String mailSmtpPort) {
        this.mailSmtpPort = mailSmtpPort;
        MailSSLSocketFactory sf = null;
        try {
            sf = new MailSSLSocketFactory();
        }
        catch (GeneralSecurityException e) {
            e.printStackTrace();
        }
        sf.setTrustAllHosts(true);
        this.properties.put("mail.smtp.ssl.enable", "true");
        this.properties.put("mail.smtp.ssl.socketFactory", sf);
        this.properties.put("mail.smtp.port", mailSmtpPort);
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public void setMailSmtpPort(String mailSmtpPort) {
        this.mailSmtpPort = mailSmtpPort;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendMail(String targetMail, String title, String content) {
        Transport trans = null;
        try {
            Session mailSession = Session.getInstance((Properties)this.properties, (Authenticator)new Authenticator(){

                public PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(MailsUtil.this.username, MailsUtil.this.password);
                }
            });
            mailSession.setDebug(this.debug);
            MimeMessage mailMessage = new MimeMessage(mailSession);
            mailMessage.setFrom((Address)new InternetAddress(this.username));
            mailMessage.setRecipient(MimeMessage.RecipientType.TO, (Address)new InternetAddress(targetMail));
            mailMessage.setSubject(title);
            mailMessage.setText(content);
            mailMessage.setSentDate(new Date());
            mailMessage.saveChanges();
            trans = mailSession.getTransport("smtp");
            Transport.send((Message)mailMessage);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                trans.close();
            }
            catch (MessagingException e) {
                e.printStackTrace();
            }
        }
    }

    public void sendHtmlMail(String targetMail, String title, String content) {
        this.sendHtmlMail(targetMail, title, content, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendHtmlMail(String targetMail, String title, String content, String replayTo) {
        Transport trans = null;
        try {
            Session mailSession = Session.getInstance((Properties)this.properties, (Authenticator)new Authenticator(){

                public PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(MailsUtil.this.username, MailsUtil.this.password);
                }
            });
            mailSession.setDebug(this.debug);
            MimeMessage mailMessage = new MimeMessage(mailSession);
            mailMessage.setFrom((Address)new InternetAddress(this.username));
            mailMessage.setRecipient(MimeMessage.RecipientType.TO, (Address)new InternetAddress(targetMail));
            mailMessage.setSubject(title);
            if (replayTo != null && replayTo.length() > 3) {
                Address[] add = new Address[]{new InternetAddress(replayTo)};
                mailMessage.setReplyTo(add);
            }
            MimeMultipart mainPart = new MimeMultipart();
            MimeBodyPart html = new MimeBodyPart();
            html.setContent((Object)content, "text/html; charset=utf-8");
            mainPart.addBodyPart((BodyPart)html);
            mailMessage.setContent((Multipart)mainPart);
            mailMessage.setSentDate(new Date());
            mailMessage.saveChanges();
            trans = mailSession.getTransport("smtp");
            Transport.send((Message)mailMessage);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                trans.close();
            }
            catch (MessagingException e) {
                e.printStackTrace();
            }
        }
    }
}

