/*
 * Decompiled with CFR 0.152.
 */
package com.xnx3.net;

import com.aliyun.mns.client.CloudAccount;
import com.aliyun.mns.client.CloudQueue;
import com.aliyun.mns.client.CloudTopic;
import com.aliyun.mns.client.MNSClient;
import com.aliyun.mns.common.ClientException;
import com.aliyun.mns.common.ServiceException;
import com.aliyun.mns.common.utils.ServiceSettings;
import com.aliyun.mns.model.Message;
import com.aliyun.mns.model.QueueMeta;
import com.aliyun.mns.model.SubscriptionMeta;
import com.aliyun.mns.model.TopicMeta;
import com.xnx3.BaseVO;
import java.util.ArrayList;
import java.util.List;

public class MNSUtil {
    String accessKeyId;
    String accessKeySecret;
    String endpoint;
    private MNSClient mnsClient = null;
    public CloudAccount account;

    public MNSUtil() {
        this.accessKeyId = ServiceSettings.getMNSAccessKeyId();
        this.accessKeySecret = ServiceSettings.getMNSAccessKeySecret();
        this.endpoint = ServiceSettings.getMNSAccountEndpoint();
    }

    public MNSUtil(String accessKeyId, String accessKeySecret, String endpoint) {
        this.accessKeyId = accessKeyId;
        this.accessKeySecret = accessKeySecret;
        this.endpoint = endpoint;
    }

    public MNSClient getMNSClient() {
        if (this.mnsClient == null) {
            this.account = new CloudAccount(this.accessKeyId, this.accessKeySecret, this.endpoint);
            this.mnsClient = this.account.getMNSClient();
        }
        return this.mnsClient;
    }

    public void close() {
        this.mnsClient.close();
    }

    public CloudQueue getQueue(String queueName) {
        return this.getMNSClient().getQueueRef(queueName);
    }

    public CloudQueue createQueue(String queueName) {
        QueueMeta qMeta = new QueueMeta();
        qMeta.setQueueName(queueName);
        return this.createQueue(qMeta);
    }

    public CloudQueue createQueue(String queueName, long delaySeconds) {
        QueueMeta qMeta = new QueueMeta();
        qMeta.setQueueName(queueName);
        qMeta.setDelaySeconds(Long.valueOf(delaySeconds));
        qMeta.setPollingWaitSeconds(Integer.valueOf(30));
        return this.createQueue(qMeta);
    }

    public CloudQueue createQueue(QueueMeta qMeta) {
        try {
            return this.getMNSClient().createQueue(qMeta);
        }
        catch (ClientException ce) {
            this.clientException(ce);
        }
        catch (ServiceException se) {
            this.serviceException(se);
        }
        catch (Exception e) {
            this.exception(e);
        }
        return null;
    }

    public Message putMessage(String queueName, String messageBody) {
        Message message = new Message();
        message.setMessageBody(messageBody);
        return this.putMessage(queueName, message);
    }

    public Message putMessage(String queueName, Message message) {
        try {
            CloudQueue queue = this.getMNSClient().getQueueRef(queueName);
            Message putMsg = queue.putMessage(message);
            return putMsg;
        }
        catch (ClientException ce) {
            this.clientException(ce);
        }
        catch (ServiceException se) {
            this.serviceException(se);
        }
        catch (Exception e) {
            this.exception(e);
        }
        return null;
    }

    public List<Message> listMessage(String queueName) {
        ArrayList batchPopMessage = null;
        CloudQueue queue = this.getMNSClient().getQueueRef(queueName);
        batchPopMessage = queue.batchPopMessage(15);
        if (batchPopMessage == null) {
            batchPopMessage = new ArrayList();
        }
        return batchPopMessage;
    }

    public void deleteMessage(String queueName, Message message) {
        CloudQueue queue = this.getMNSClient().getQueueRef(queueName);
        queue.deleteMessage(message.getReceiptHandle());
    }

    public void deleteQueue(String queueName) {
        try {
            CloudQueue queue = this.getMNSClient().getQueueRef(queueName);
            queue.delete();
        }
        catch (ClientException ce) {
            this.clientException(ce);
        }
        catch (ServiceException se) {
            this.serviceException(se);
        }
        catch (Exception e) {
            this.exception(e);
        }
    }

    private void serviceException(ServiceException se) {
        if (se.getErrorCode().equals("QueueNotExist")) {
            System.out.println("Queue is not exist.Please create before use");
        } else if (se.getErrorCode().equals("TimeExpired")) {
            System.out.println("The request is time expired. Please check your local machine timeclock");
        }
        se.printStackTrace();
    }

    private void clientException(ClientException ce) {
        System.out.println("Something wrong with the network connection between client and MNS service.Please check your network and DNS availablity.");
        ce.printStackTrace();
    }

    private void exception(Exception e) {
        System.out.println("Unknown exception happened!\uff0cexception:" + e.getMessage());
        e.printStackTrace();
    }

    public void createTopic(String topicName) {
        TopicMeta meta = new TopicMeta();
        meta.setTopicName(topicName);
        try {
            CloudTopic cloudTopic = this.getMNSClient().createTopic(meta);
        }
        catch (Exception e) {
            System.out.println("create topic error, " + e.getMessage());
            e.printStackTrace();
        }
    }

    public BaseVO createSubScription(String topicName, SubscriptionMeta subMeta) {
        BaseVO vo = new BaseVO();
        CloudTopic topic = this.getMNSClient().getTopicRef(topicName);
        try {
            String subUrl = topic.subscribe(subMeta);
            vo.setBaseVO(1, subUrl);
        }
        catch (Exception e) {
            vo.setBaseVO(0, e.getMessage());
            System.out.println("subscribe/unsubribe error");
            e.printStackTrace();
        }
        return vo;
    }

    public static void main(String[] args) {
        MNSUtil mns = new MNSUtil();
        String queueName = "testaaaaa";
        CloudQueue cq = mns.createQueue(queueName);
        mns.putMessage(queueName, "\u54c8\u54c81");
        mns.putMessage(queueName, "\u54c8\u54c83");
        List<Message> list = mns.listMessage(queueName);
        System.out.println("\u6d88\u606f\u6761\u6570:" + list.size());
        for (int i = 0; i < list.size(); ++i) {
            Message message = list.get(i);
            System.out.println(message.getMessageId() + ":" + message.getMessageBody());
            mns.deleteMessage(queueName, message);
        }
        mns.close();
    }
}

