/*
 * Decompiled with CFR 0.152.
 */
package com.xnx3.net;

import com.xnx3.ConfigManagerUtil;
import com.xnx3.Lang;
import com.xnx3.bean.UploadBean;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.List;
import org.csource_.common.MyException;
import org.csource_.common.NameValuePair;
import org.csource_.fastdfs.ClientGlobal;
import org.csource_.fastdfs.FileInfo;
import org.csource_.fastdfs.ServerInfo;
import org.csource_.fastdfs.StorageClient;
import org.csource_.fastdfs.StorageServer;
import org.csource_.fastdfs.TrackerClient;
import org.csource_.fastdfs.TrackerGroup;
import org.csource_.fastdfs.TrackerServer;

public class FastDFSUtil {
    TrackerClient tracker = null;
    TrackerServer trackerServer = null;
    StorageClient client = null;
    StorageServer storageServer = null;
    ServerInfo[] servers = null;
    NameValuePair[] meta_list = null;

    public void open() {
        this.tracker = new TrackerClient();
        try {
            this.trackerServer = this.tracker.getConnection();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.client = new StorageClient(this.trackerServer, this.storageServer);
        this.meta_list = new NameValuePair[4];
        this.meta_list[0] = new NameValuePair("width", "800");
        this.meta_list[1] = new NameValuePair("heigth", "600");
        this.meta_list[2] = new NameValuePair("bgcolor", "#FFFFFF");
        this.meta_list[3] = new NameValuePair("author", "Mike");
        String group_name = null;
        StorageServer[] storageServers = null;
        try {
            storageServers = this.tracker.getStoreStorages(this.trackerServer, group_name);
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        if (storageServers == null) {
            this.debug("get store storage servers fail, error code: " + this.tracker.getErrorCode());
        } else {
            this.debug("store storage servers count: " + storageServers.length);
            for (int k = 0; k < storageServers.length; ++k) {
                this.debug(k + 1 + ". " + storageServers[k].getInetSocketAddress().getAddress().getHostAddress() + ":" + storageServers[k].getInetSocketAddress().getPort());
            }
        }
    }

    public void close() {
        try {
            if (this.storageServer != null) {
                this.storageServer.close();
            }
            if (this.trackerServer != null) {
                this.trackerServer.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public UploadBean upload(String local_filename) {
        String[] results = null;
        try {
            String suffix = Lang.findFileSuffix((String)local_filename);
            if (suffix == null) {
                suffix = ClientGlobal.defaultSuffix;
            }
            results = this.client.upload_file(local_filename, suffix, this.meta_list);
        }
        catch (IOException | MyException e) {
            e.printStackTrace();
        }
        return this.trimUploadBean(results);
    }

    public UploadBean upload(byte[] file_buff, String file_ext_name) {
        String[] results = null;
        try {
            results = this.client.upload_file(file_buff, file_ext_name, this.meta_list);
        }
        catch (IOException | MyException e) {
            e.printStackTrace();
        }
        return this.trimUploadBean(results);
    }

    private UploadBean trimUploadBean(String[] results) {
        UploadBean uploadBean = new UploadBean();
        if (results == null) {
            this.debug("upload file fail, error code: " + this.client.getErrorCode());
            uploadBean.setErrorInfo("upload file fail, error code: " + this.client.getErrorCode());
        } else {
            String group_name = results[0];
            String remote_filename = results[1];
            try {
                FileInfo fileInfo = this.client.get_file_info(group_name, remote_filename);
                uploadBean.setCrc32((int)fileInfo.getCrc32());
                uploadBean.setCreateTimestamp(fileInfo.getCreateTimestamp());
                uploadBean.setErrorInfo("");
                uploadBean.setFileSize(fileInfo.getFileSize());
                uploadBean.setGroupName(group_name);
                uploadBean.setRemoteFileName(remote_filename);
                uploadBean.setSourceIpAddr(fileInfo.getSourceIpAddr());
                uploadBean.setSuccess(true);
            }
            catch (IOException | MyException e) {
                e.printStackTrace();
            }
        }
        return uploadBean;
    }

    public boolean download(String remoteFileName, String localFileName) {
        try {
            int result = this.client.download_file(ClientGlobal.groupName, remoteFileName, localFileName);
            if (result == 0) {
                return true;
            }
            this.debug("download file failure ! error code:" + result);
            return false;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        catch (MyException e) {
            e.printStackTrace();
            return false;
        }
    }

    public byte[] download(String remoteFileName) {
        byte[] result = null;
        try {
            result = this.client.download_file(ClientGlobal.groupName, remoteFileName);
            return result;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        catch (MyException e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean delete(String remoteFileName) {
        boolean result = false;
        try {
            int r = this.client.delete_file(ClientGlobal.groupName, remoteFileName);
            if (r == 0) {
                result = true;
            } else {
                this.debug("delete file failure ! error code : " + r);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (MyException e) {
            e.printStackTrace();
        }
        return result;
    }

    public FileInfo getFileInfo(String remoteFileName) {
        FileInfo fileInfo = null;
        try {
            fileInfo = this.client.get_file_info(ClientGlobal.groupName, remoteFileName);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (MyException e) {
            e.printStackTrace();
        }
        return fileInfo;
    }

    private void debug(String text) {
        if (ClientGlobal.debug.booleanValue()) {
            System.out.println(text);
        }
    }

    public static void main(String[] args) {
        FastDFSUtil client = new FastDFSUtil();
        client.open();
        UploadBean upload = client.upload("/jar_file/mysql-connector-java-3.0.17-ga-bin.jar");
        boolean result = client.download("M00/07/65/CgAA-lVRp9-AYn-mAAPCLZlIvsE337.txt", "/Users/apple/Desktop/1.jar");
        client.close();
    }

    static {
        String d;
        ClientGlobal.g_connect_timeout = Lang.stringToInt((String)ConfigManagerUtil.getSingleton("xnx3Config.xml").getValue("FastDFS.connect_timeout"), (int)5);
        if (ClientGlobal.g_connect_timeout < 0) {
            ClientGlobal.g_connect_timeout = 5;
        }
        ClientGlobal.g_connect_timeout *= 1000;
        ClientGlobal.g_network_timeout = Lang.stringToInt((String)ConfigManagerUtil.getSingleton("xnx3Config.xml").getValue("FastDFS.network_timeout"), (int)30);
        if (ClientGlobal.g_network_timeout < 0) {
            ClientGlobal.g_network_timeout = 30;
        }
        ClientGlobal.g_network_timeout *= 1000;
        ClientGlobal.g_charset = ConfigManagerUtil.getSingleton("xnx3Config.xml").getValue("FastDFS.charset");
        if (ClientGlobal.g_charset == null || ClientGlobal.g_charset.length() == 0) {
            ClientGlobal.g_charset = "ISO8859-1";
        }
        ClientGlobal.debug = (d = ConfigManagerUtil.getSingleton("xnx3Config.xml").getValue("FastDFS.debug")) != null ? Boolean.valueOf(d.equals("true")) : Boolean.valueOf(false);
        ClientGlobal.groupName = ConfigManagerUtil.getSingleton("xnx3Config.xml").getValue("FastDFS.default_group_name");
        if (ClientGlobal.groupName == null || ClientGlobal.groupName.length() == 0) {
            ClientGlobal.g_charset = "group1";
        }
        if ((ClientGlobal.defaultSuffix = ConfigManagerUtil.getSingleton("xnx3Config.xml").getValue("FastDFS.default_fileSuffix")) == null || ClientGlobal.defaultSuffix.length() == 0) {
            ClientGlobal.defaultSuffix = "xnx3";
        }
        List list = ConfigManagerUtil.getSingleton("xnx3Config.xml").getList("FastDFS.tracker_servers.tracker_server");
        String[] szTrackerServers = new String[list.size()];
        String[] parts = new String[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            szTrackerServers[i] = (String)list.get(i);
        }
        InetSocketAddress[] tracker_servers = new InetSocketAddress[szTrackerServers.length];
        for (int i = 0; i < szTrackerServers.length; ++i) {
            parts = szTrackerServers[i].split("\\:", 2);
            if (parts.length != 2) {
                try {
                    throw new MyException("the value of item \"tracker_server\" is invalid, the correct format is host:port");
                }
                catch (MyException e) {
                    e.printStackTrace();
                }
            }
            tracker_servers[i] = new InetSocketAddress(parts[0].trim(), Integer.parseInt(parts[1].trim()));
        }
        ClientGlobal.g_tracker_group = new TrackerGroup(tracker_servers);
        ClientGlobal.g_tracker_http_port = Lang.stringToInt((String)ConfigManagerUtil.getSingleton("xnx3Config.xml").getValue("FastDFS.tracker_http_port"), (int)80);
        String ast = ConfigManagerUtil.getSingleton("xnx3Config.xml").getValue("FastDFS.anti_steal_token");
        ClientGlobal.g_anti_steal_token = ast != null ? ast.equals("true") : false;
        if (ClientGlobal.g_anti_steal_token) {
            ClientGlobal.g_secret_key = ConfigManagerUtil.getSingleton("xnx3Config.xml").getValue("FastDFS.secret_key");
        }
    }
}

