/*
 * Decompiled with CFR 0.152.
 */
package com.xnx3.microsoft;

import com.jacob.activeX.ActiveXComponent;
import com.jacob.com.Variant;
import com.xnx3.Lang;
import com.xnx3.Log;
import com.xnx3.bean.ActiveBean;
import com.xnx3.swing.TrayUtil;
import java.awt.PopupMenu;
import java.awt.TrayIcon;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import javax.swing.ImageIcon;

public class SystemUtil
extends Lang {
    private ActiveXComponent activeDm;
    private ActiveXComponent activePlugin365;
    private Log log;

    public SystemUtil(ActiveBean activeBean) {
        this.activeDm = activeBean.getDm();
        this.activePlugin365 = activeBean.getPlugin365();
        this.log = new Log();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean beep(int frequency, int time) {
        Variant[] var = new Variant[2];
        int result = 0;
        try {
            var[0] = new Variant(frequency);
            var[1] = new Variant(time);
            result = this.activeDm.invoke("Beep", var).getInt();
        }
        catch (Exception e) {
            this.log.debug((Object)this, "beep", "\u5f02\u5e38\u6355\u83b7:" + e.getMessage());
        }
        finally {
            var = null;
        }
        return result == 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean exitSystem(int type) {
        Variant[] var = new Variant[1];
        int result = 0;
        try {
            var[0] = new Variant(type);
            result = this.activeDm.invoke("ExitOs", var).getInt();
        }
        catch (Exception e) {
            this.log.debug((Object)this, "exitSystem", "\u5f02\u5e38\u6355\u83b7:" + e.getMessage());
        }
        finally {
            var = null;
        }
        return result == 1;
    }

    public boolean exitSystemByLogout() {
        return this.exitSystem(0);
    }

    public boolean exitSystemByRestart() {
        return this.exitSystem(2);
    }

    public boolean exitSystemByShutdown() {
        return this.exitSystem(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDir(int type) {
        Variant[] var = new Variant[1];
        String result = null;
        try {
            var[0] = new Variant(type);
            result = this.activeDm.invoke("GetDir", var).getString();
        }
        catch (Exception e) {
            this.log.debug((Object)this, "getDir", "\u5f02\u5e38\u6355\u83b7:" + e.getMessage());
        }
        finally {
            var = null;
        }
        return result;
    }

    public String getDirForTemp() {
        return this.getDir(3);
    }

    public String getDirForProcess() {
        return this.getDir(4);
    }

    public String getDiskSerial() {
        String result = null;
        try {
            result = this.activeDm.invoke("GetDiskSerial").getString();
            if (result == null || result.length() == 0) {
                result = null;
                this.log.debug((Object)this, "getDiskSerial", "\u83b7\u53d6\u672c\u673a\u7684\u786c\u76d8\u5e8f\u5217\u53f7\u5fc5\u987b\u8981\u6709\u7ba1\u7406\u5458\u6743\u9650\uff01");
            }
        }
        catch (Exception e) {
            this.log.debug((Object)this, "getDiskSerial", "\u5f02\u5e38\u6355\u83b7:" + e.getMessage());
        }
        return result;
    }

    public int getScreenDepth() {
        int result = 0;
        try {
            result = this.activeDm.invoke("GetScreenDepth").getInt();
        }
        catch (Exception e) {
            this.log.debug((Object)this, "getScreenDepth", "\u5f02\u5e38\u6355\u83b7:" + e.getMessage());
        }
        return result;
    }

    public int getScreenHeight() {
        int result = 0;
        try {
            result = this.activeDm.invoke("GetScreenHeight").getInt();
        }
        catch (Exception e) {
            this.log.debug((Object)this, "getScreenHeight", "\u5f02\u5e38\u6355\u83b7:" + e.getMessage());
        }
        return result;
    }

    public int getScreenWidth() {
        int result = 0;
        try {
            result = this.activeDm.invoke("GetScreenWidth").getInt();
        }
        catch (Exception e) {
            this.log.debug((Object)this, "getScreenWidth", "\u5f02\u5e38\u6355\u83b7:" + e.getMessage());
        }
        return result;
    }

    public int getSystemRunTime() {
        int result = 0;
        try {
            result = this.activeDm.invoke("GetTime").getInt();
        }
        catch (Exception e) {
            this.log.debug((Object)this, "getSystemRunTime", "\u5f02\u5e38\u6355\u83b7:" + e.getMessage());
        }
        return result;
    }

    public String getDirForWindow() {
        return this.getDir(2);
    }

    public String getDirForSystem32() {
        return this.getDir(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setScreen(int width, int height, int depth) {
        Variant[] var = new Variant[3];
        int result = 0;
        try {
            var[0] = new Variant(width);
            var[1] = new Variant(height);
            var[2] = new Variant(depth);
            result = this.activeDm.invoke("SetScreen", var).getInt();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.log.debug((Object)this, "setScreen", "\u5f02\u5e38\u6355\u83b7:" + e.getMessage());
        }
        finally {
            var = null;
        }
        return result == 1;
    }

    public boolean setScreenDepth(int depth) {
        return this.setScreen(this.getScreenWidth(), this.getScreenHeight(), depth);
    }

    public boolean setScreenWidth(int width, int height) {
        return this.setScreen(width, height, this.getScreenDepth());
    }

    public boolean getUAC() {
        int result = 0;
        try {
            result = this.activeDm.invoke("CheckUAC").getInt();
        }
        catch (Exception e) {
            this.log.debug((Object)this, "getUAC", "\u5f02\u5e38\u6355\u83b7:" + e.getMessage());
        }
        return result == 1;
    }

    public boolean setUAC(boolean use) {
        int result = 0;
        int uac = 0;
        if (use) {
            uac = 1;
        }
        try {
            result = this.activeDm.invoke("SetUAC", uac).getInt();
        }
        catch (Exception e) {
            this.log.debug((Object)this, "setUAC", "\u5f02\u5e38\u6355\u83b7:" + e.getMessage());
        }
        return result == 1;
    }

    public static int getPid() {
        RuntimeMXBean runtime = ManagementFactory.getRuntimeMXBean();
        String name = runtime.getName();
        try {
            return Integer.parseInt(name.substring(0, name.indexOf(64)));
        }
        catch (Exception e) {
            return -1;
        }
    }

    public static String cmd(String command) {
        try {
            Process process = Runtime.getRuntime().exec("cmd.exe /c " + command);
            InputStream inputStream = process.getInputStream();
            BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
            StringBuffer str = new StringBuffer();
            String line = "";
            while ((line = reader.readLine()) != null) {
                str.append(line + "\n");
            }
            reader.close();
            process.destroy();
            return str.toString();
        }
        catch (IOException e) {
            e.printStackTrace();
            return e.getMessage();
        }
    }

    public static void registerDll(String dllFilePath) {
        try {
            Runtime.getRuntime().exec("cmd.exe /c regsvr32 " + dllFilePath);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void openUrl(String url) {
        try {
            Runtime.getRuntime().exec("cmd.exe /c start iexplore " + url);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static String getComputerName() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void run(String path) {
        try {
            Runtime.getRuntime().exec("cmd  /c  start  " + path);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String enumProcess() {
        String result = null;
        try {
            result = this.activePlugin365.invoke("EnumProcess").getString();
        }
        catch (Exception e) {
            this.log.debug((Object)this, "enumProcess", "\u5f02\u5e38\u6355\u83b7:" + e.getMessage());
        }
        return result;
    }

    public int getProcessPriority(int hwnd) {
        int result = 0;
        try {
            result = this.activePlugin365.invoke("GetProcessPriority", hwnd).getInt();
        }
        catch (Exception e) {
            this.log.debug((Object)this, "getProcessPriority", "\u5f02\u5e38\u6355\u83b7:" + e.getMessage());
        }
        return result;
    }

    public boolean setProcessPriority(int hwnd, int mode) {
        boolean result = true;
        try {
            this.activePlugin365.invoke("setProcessPriority", hwnd, mode);
        }
        catch (Exception e) {
            result = false;
            this.log.debug((Object)this, "setProcessPriority", "\u5f02\u5e38\u6355\u83b7:" + e.getMessage());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addTray(int hwnd, String title) {
        boolean result = true;
        Variant[] var = new Variant[2];
        try {
            var[0] = new Variant(hwnd);
            var[1] = new Variant((Object)title);
            this.activePlugin365.invoke("AddTray", var);
        }
        catch (Exception e) {
            result = false;
            e.printStackTrace();
            this.log.debug((Object)this, "addTray", "\u5f02\u5e38\u6355\u83b7:" + e.getMessage());
        }
        finally {
            var = null;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean showTipTray(int hwnd, String title, String message, int mode) {
        boolean result = true;
        Variant[] var = new Variant[4];
        try {
            var[0] = new Variant(hwnd);
            var[1] = new Variant((Object)message);
            var[2] = new Variant((Object)title);
            var[3] = new Variant(mode);
            this.activePlugin365.invoke("TipTray", var);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.log.debug((Object)this, "showTipTray", "\u5f02\u5e38\u6355\u83b7:" + e.getMessage());
        }
        finally {
            var = null;
        }
        return result;
    }

    public boolean showTipTrayForNoIcon(int hwnd, String title, String message) {
        return this.showTipTray(hwnd, title, message, 0);
    }

    public boolean showTipTrayForInfo(int hwnd, String title, String message) {
        return this.showTipTray(hwnd, title, message, 1);
    }

    public boolean showTipTrayForWarn(int hwnd, String title, String message) {
        return this.showTipTray(hwnd, title, message, 2);
    }

    public boolean showTipTrayForError(int hwnd, String title, String message) {
        return this.showTipTray(hwnd, title, message, 3);
    }

    public boolean showTipTrayForProcedure(int hwnd, String title, String message) {
        return this.showTipTray(hwnd, title, message, 4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean delTray(int hwnd) {
        boolean result = true;
        Variant[] var = new Variant[1];
        try {
            var[0] = new Variant(hwnd);
            this.activePlugin365.invoke("DelTray", var);
        }
        catch (Exception e) {
            result = false;
            e.printStackTrace();
            this.log.debug((Object)this, "delTray", "\u5f02\u5e38\u6355\u83b7:" + e.getMessage());
        }
        finally {
            var = null;
        }
        return result;
    }

    public static TrayIcon createTray(URL imageURL, String title, PopupMenu popupMenu) {
        ImageIcon icon = new ImageIcon(imageURL);
        return TrayUtil.createTray((ImageIcon)icon, (String)title, (PopupMenu)popupMenu);
    }
}

