/*
 * Decompiled with CFR 0.152.
 */
package com.xnx3;

import com.swetake.util.Qrcode;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import javax.imageio.ImageIO;

public class QRCodeUtil {
    public static BufferedImage createQRCoder(String content) {
        int size = 90;
        Qrcode testQrcode = new Qrcode();
        testQrcode.setQrcodeErrorCorrect('M');
        testQrcode.setQrcodeEncodeMode('B');
        testQrcode.setQrcodeVersion(7);
        String testString = content;
        byte[] d = null;
        try {
            d = testString.getBytes("utf-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        BufferedImage bi = new BufferedImage(size, size, 12);
        Graphics2D g = bi.createGraphics();
        g.setBackground(Color.WHITE);
        g.clearRect(0, 0, size, size);
        g.setColor(Color.BLACK);
        if (d.length > 0 && d.length < 120) {
            boolean[][] s = testQrcode.calQrcode(d);
            for (int i = 0; i < s.length; ++i) {
                for (int j = 0; j < s.length; ++j) {
                    if (!s[j][i]) continue;
                    g.fillRect(j * 2, i * 2, 2, 2);
                }
            }
        }
        g.dispose();
        bi.flush();
        return bi;
    }

    public static void main(String[] args) throws IOException {
        BufferedImage bi = QRCodeUtil.createQRCoder("http://saizhuo.wang.market");
        System.out.println(bi);
        try {
            ImageIO.write((RenderedImage)bi, "jpg", new File("/images/test.jpg"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

