/*
 * Decompiled with CFR 0.152.
 */
package com.xnx3;

import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.FileConfiguration;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.configuration.XMLConfiguration;
import org.apache.commons.configuration.reloading.FileChangedReloadingStrategy;
import org.apache.commons.configuration.reloading.ReloadingStrategy;
import org.apache.commons.io.IOUtils;

public class ConfigManagerUtil {
    private static HashMap hashMap = new HashMap();
    FileConfiguration config;

    private ConfigManagerUtil(String configFileName) {
        try {
            this.config = null;
            if (configFileName.toLowerCase().endsWith("xml")) {
                this.config = new XMLConfiguration(configFileName);
            } else if (configFileName.toLowerCase().endsWith("properties")) {
                this.config = new PropertiesConfiguration(configFileName);
            }
            this.config.setReloadingStrategy((ReloadingStrategy)new FileChangedReloadingStrategy());
            hashMap.put(configFileName, this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static ConfigManagerUtil getSingleton(String configFileName) {
        if (hashMap.get(configFileName) == null) {
            hashMap.put(configFileName, new ConfigManagerUtil(configFileName));
        }
        return (ConfigManagerUtil)hashMap.get(configFileName);
    }

    public FileConfiguration getFileConfiguration() {
        return this.config;
    }

    public String selectValue(String path) {
        return this.config.getString(path);
    }

    public String getValue(String path) {
        return this.config.getString(path);
    }

    public List getList(String name) {
        return this.config.getList(name);
    }

    public void setValue(String path, String value) {
        this.config.setProperty(path, (Object)value);
    }

    public String[] selectValues(String path) {
        return this.config.getStringArray(path);
    }

    public void reload() {
        this.config.reload();
    }

    public String toFileContent() throws ConfigurationException {
        StringWriter stringWriter = new StringWriter();
        this.config.save((Writer)stringWriter);
        String returnValue = stringWriter.toString();
        IOUtils.closeQuietly((Writer)stringWriter);
        return returnValue;
    }

    public String getFilePath() {
        return this.config.getFile().getAbsolutePath();
    }

    public void save() throws ConfigurationException {
        this.config.save();
    }

    public static void main(String[] args) {
        ConfigManagerUtil.getSingleton("xnx3Config.xml").getValue("mail.host");
    }
}

