---
title: Text Formatting in HTML
localeTitle: Formato de texto en HTML
---
## Formato de texto en HTML

HTML le proporciona una gran cantidad de elementos útiles para el formato de texto. Permite hacer tu texto: negrita, cursiva, marca y mucho más. Cambiar el estilo de tu texto no es sin ninguna razón: lo principal es hacer que el lector revise algunas notas importantes.

### Audaz y fuerte

Puede cambiar fácilmente el significado de su texto usando el elemento HTML `<b>` . Hace que las palabras estén en negrita, cuya función es seleccionar el fragmento de secuencia. Por ejemplo:
```
The most important part of your code is <b>the end</b>, because if you <b>don't close</b> the element, it will affect to <b>everything</b>! 
```

También puede usar `<strong>` también - también agrega importancia "fuerte" semántica. Su navegador no reconoce una diferencia entre esos dos elementos, pero existe.

### Cursiva y enfatizada

Generalmente se usa cuando se cita algo o se pone una traducción de una palabra en muchos artículos. Los pone en cursiva - solo imagina un poco pateado en las letras correctas. Por ejemplo:
```
Theatre - <i>teatos</i>, <i>teates</i> and <i>teatron</i>. 
```

También puede usar `<em>` , también agrega una importancia semántica "enfatizada". Su navegador no reconoce una diferencia entre esos dos elementos, pero existe.

### Pequeña

Hace que su texto sea más pequeño que el tamaño normal de la fuente usada. El significado de este elemento se cambió en HTML5: representa comentarios laterales y letra pequeña.

`Normal, <small>small</small>, normal, <small>small</small>!`

### Marcado

El elemento `<mark>` hace que su texto sea marcado - en diferentes palabras, hace que su texto esté resaltado. Puede usarlo para decirle a los lectores que es una de las cosas importantes en su artículo. Por ejemplo:

`HTML is full of things and <mark>it's our journey</mark> to get known them better!`

### Eliminado

El elemento `<del>` hace que tu texto sea tachado en el centro. Es útil mostrar cambios en sus documentos.

`WWI started in <del>1913</del> 1914 year.`

### Insertado

La etiqueta `<ins>` hace que su texto se inserte en el artículo. Usar otras palabras que lo hace mucho más fácil de entender - agregó. Muestra una línea debajo del texto insertado.

`HTML isn't boring. <ins>You can make a lot of combinations of elements!</ins>`

### Suscrito

El uso del elemento `<sub>` le proporciona un formato útil como texto con subíndices (mostrándolo más pequeño en la parte inferior). Hay un código de ejemplo:

`This was in 2003 year <sub>(needs a link).`

### Superíndice

Si desea hacer un texto opuesto al subíndice, puede utilizar fácilmente el elemento `<sup>` . Muestra un texto más pequeño en la parte superior.

`10<sup>x+y</sup> = 1000`