---
title: Semantic HTML Elements
localeTitle: Elementos semánticos de HTML
---
## Elementos semánticos de HTML

El elemento `<em>` marca el texto como enfatizado sobre el texto que lo rodea. Normalmente, el navegador lo muestra en _cursiva_ , pero puede agregar otros estilos usando CSS.

Los elementos HTML semánticos proporcionan significado a los navegadores, desarrolladores y usuarios de un sitio. En contraste con elementos como `<div>` o `<span>` , los elementos semánticos como `<header>` y `<footer>` explican más claramente el propósito de cada sección de un sitio web.

### ¿Por qué usar elementos semánticos?

Los desarrolladores utilizan elementos semánticos para mejorar lo siguiente:

*   accesibilidad: ayuda a las tecnologías de asistencia a leer e interpretar tu página web
*   capacidad de búsqueda: ayuda a las computadoras a dar sentido a tu contenido
*   Internacionalización: solo el 13% del mundo son hablantes nativos de inglés.
*   Interoperabilidad: ayude a otros programadores a comprender la estructura de su página web 1

### Elementos semánticos útiles

*   `<header>` define un encabezado para el documento o una sección
*   `<footer>` define un pie de página para el documento o una sección
*   `<nav>` define los enlaces de navegación en el documento
*   `<main>` define el contenido principal de un documento
*   `<section>` define una sección en el documento; la especificación define esto como "una agrupación temática de contenido, generalmente con un encabezado", por lo que puede pensar que es como un capítulo
*   `<article>` define un artículo en el documento
*   `<aside>` define el contenido aparte del contenido de la página
*   `<address>` define la información de contacto del autor / propietario de un documento o artículo.
*   `<figure>` define contenido autónomo, como ilustraciones, diagramas, fotos, bloques de código, etc. 2

### Elementos semánticos menos conocidos

*   `<bdi>` define una sección de texto que podría tener el formato en una dirección diferente a la de otro texto (por ejemplo, una cita en hebreo o árabe en un artículo de otro tipo en inglés)
*   `<details>` define detalles adicionales que las personas pueden ver u ocultar (como una información sobre herramientas)
*   `<dialog>` define un cuadro de diálogo o ventana
*   `<figcaption>` define el título para un `<figure>`
*   `<mark>` define el texto marcado o resaltado
*   `<menuitem>` define un comando / elemento de menú que el usuario puede seleccionar desde un menú emergente
*   `<meter>` define una medida escalar dentro de un rango conocido (un indicador)
*   `<progress>` define el progreso de una tarea
*   `<rp>` define qué mostrar en los navegadores que no admiten las anotaciones de ruby
*   `<rt>` define una explicación / pronunciación de los caracteres (para tipografía del este de Asia)
*   `<ruby>` define una anotación de rubí (para tipografía del este asiático)
*   `<summary>` define un encabezado visible para un elemento `<details>`
*   `<time>` define una fecha / hora
*   `<wbr>` define un posible salto de línea 2

### Fuentes

1.  [Lee, Michelle. "Una visión general de la semántica HTML5". _CodePen_ . 16 de febrero de 2016. Acceso: 24 de octubre de 2017](https://codepen.io/mi-lee/post/an-overview-of-html5-semantics)
2.  [Bidaux, Vincent. "Elementos semánticos HTML5 y Webflow: la guía esencial". _Webflow_ 16 de diciembre de 2016. Acceso: 24 de octubre de 2017](https://webflow.com/blog/html5-semantic-elements-and-webflow-the-essential-guide)

#### Más información:

Para más información: https://codepen.io/mi-lee/post/an-overview-of-html5-semantics

Consulte el [artículo de MDN Web Docs](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/em) .