---
title: HTML Entities
localeTitle: Entidades HTML
---
# Entidades HTML

## Visión de conjunto

### ¿Qué son las entidades HTML?

Las entidades HTML son caracteres que se utilizan para reemplazar caracteres reservados en HTML o para caracteres que no aparecen en su teclado. Algunos caracteres están reservados en HTML. Si usa los signos menor que (<) o mayor que (>) en su texto, el navegador puede mezclarlos con las etiquetas.

### ¿Para qué se usan?

Como se mencionó, las entidades HTML se utilizan para reemplazar los caracteres reservados que están reservados por HTML.

### ¿Cómo los usas?

Una entidad de carácter se parece a esto:

```html

<!-- format &[entity_name]; --> 
 <!-- example for a less-than sign (<) --> 
 &lt; 
```

O

```html

<!-- &#[entity_number]; --> 
 <!-- example for a less-than sign (<) --> 
 &#60; 
```

## Guia de referencia

Esta no es, de ninguna manera, una lista exhaustiva, pero los enlaces a continuación podrán darle más entidades si las siguientes no funcionan para sus necesidades. Codificación feliz: pajarita:

| Personaje | Nombre de la entidad | Número de entidad | Descripción | | ------- | ----------- | ----------- | ------- | | | | `&#32;` | Espacio | | ! | | `&#33;` | Signo de exclamación | | "| | `&#34;` | Comillas | | # | | `&#35;` | Signo de número | $ | | `&#36;` | Signo de dólar | | ¢ | `&cent;` | `&#162;` | Signo de ciento | | € | `&euro;` | `&#8364;` | Signo del euro | £ | `&pound;` | `&#163;` | Signo de GBP | | ¥ | `&yen;` | `&#165;` | Signo de yen | | % | | `&#37;` | Signo de porcentaje | & | `&amp;` | `&#38;` | Ampersand | | '| | `&#39;` | Apóstrofe | | (| | `&#40;` | Apertura / Paréntesis izquierdo | | ) | | `&#41;` | Cierre / Paréntesis Derecho | | \* | | `&#42;` | Asterisco | | + | | `&#43;` | Signo más | | , | | `&#44;` | Coma | | - | | `&#45;` | Guión | | . | | `&#46;` | Periodo | | / | | `&#47;` | Slash | | © | `&copy;` | `&#169;` | Derechos de autor | | ® | `&reg;` | `&#174;` | Marca registrada | | "| `&quot;` | `&#34;` | comillas dobles | | `>` | `&gt;` | `&#62;` | Signo mayor que | | `<` | `&lt;` | `&#60;` | Signo menor que | | `•` | `&bull;` | `&#8226` | Punto de bala |

#### Más información:

Hay un montón de referencias de HTML entites por ahí; algunos ejemplos son:

*   [Tabla de Entidades - W3](https://dev.w3.org/html5/html-author/charref)
*   [Escuelas w3](https://www.w3schools.com/html/html_entities.asp)
*   [Freeformatter](https://www.freeformatter.com/html-entities.html)