---
title: Section Tag
localeTitle: Etiqueta de sección
---
## Sección

El elemento HTML `<section>` define una sección dentro de una página HTML que se usa cuando no hay un elemento HTML semántico más específico para representarlo. Normalmente, un elemento `<section>` incluirá un elemento de encabezado ( `<h1>` - `<h6>` ) como elemento secundario.

Por ejemplo, una página web podría dividirse en varias secciones, como las secciones de bienvenida, contenido y contacto.

Un elemento `<section>` no debe usarse en lugar de un elemento `<div>` si se necesita un contenedor genérico. Se debe utilizar para definir secciones dentro de una página HTML.

```html

<html> 
 <head> 
  <title>Section Example</title> 
 </head> 
 <body> 
  <section> 
    <h1>Heading</h1> 
    <p>Bunch of awesome content</p> 
  </section> 
 </body> 
 </html> 
```

#### Más información:

*   [MDN Web Docs](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/section)
*   [Escuelas w3](https://www.w3schools.com/tags/tag_section.asp)