---
title: Header Tag
localeTitle: Etiqueta de encabezado
---
## Etiqueta de encabezado

La etiqueta `<header>` es un contenedor que se utiliza para enlaces de navegación o contenido introductorio. Por lo general, puede incluir elementos de encabezado, como `<h1>` , `<h2>` , pero también puede incluir otros elementos como un formulario de búsqueda, logotipo, información del autor, etc.

# Corresponde al rubro más importante. Mientras nos movemos a otras etiquetas como

## ,

### , etc disminuye el grado de importancia. Aunque no es obligatorio, la etiqueta `<header>` está diseñada para contener el encabezado de las secciones adyacentes. También se puede utilizar más de una vez en un documento HTML. Es importante tener en cuenta que la etiqueta `<header>` no introduce una nueva sección, sino que es simplemente el encabezado de una sección.

Aquí hay un ejemplo usando la etiqueta `<header>` :

```html

<article> 
  <header> 
    <h1>Heading of Page</h1> 
  </header> 
    <p>Lorem ipsum dolor sit amet, consectetur adipiscing elit.</p> 
 </article> 
```

#### Más información:

*   [MDN](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/header)
*   [Escuelas w3](https://www.w3schools.com/tags/tag_header.asp)