---
title: Doctype Tag
localeTitle: Doctype Tag
---
## Doctype Tag

El código HTML siempre está acompañado por su "boilerplate" de etiquetas. La primera etiqueta encontrada en cualquier archivo HTML debe ser una declaración de Doctype. El doctype html5 `<!DOCTYPE html>` es un preámbulo requerido que se utiliza para informar al navegador qué [modo de renderización](https://developer.mozilla.org/en-US/docs/Quirks_Mode_and_Standards_Mode) usar (HTML5 vs. XHTML). Asegúrese de colocar el doctype en la parte superior del documento.

```html

<!DOCTYPE html> 
 <html> 
    <head> 
        <meta charset=UTF-8> 
        <title>Document Title</title> 
    </head> 
    <body> 
        <p>Document content.</p> 
    </body> 
 </html> 
```

#### Más información:

*   [Doctype: MDN](https://developer.mozilla.org/en-US/docs/Glossary/Doctype)
*   [Introducción a HTML5: MDN](https://developer.mozilla.org/en-US/docs/Web/Guide/HTML/HTML5/Introduction_to_HTML5)
*   [Modo Quirks y Modo Estándar: MDN](https://developer.mozilla.org/en-US/docs/Quirks_Mode_and_Standards_Mode)