---
title: Blockquote Tag
localeTitle: Etiqueta Blockquote
---
## Etiqueta Blockquote

### Propósito

El elemento HTML `<blockquote>` rompe una cita del contenido circundante. Esto permite al lector ver claramente la cita como material atribuido a su autor original.

### Uso

Al igual que las etiquetas "H" envían señales a un lector de que la información es importante, blockquote alerta al lector de que la información que están leyendo proviene de una fuente externa. La etiqueta `<blockquote>` puede incluir una URL para la fuente de la cita que se puede obtener usando el atributo cite, mientras que una representación de texto de la fuente se puede dar usando el elemento `<cite>` .

### Ejemplo

```html

<blockquote cite="https://www.cnet.com/news/tim-cook-maintains-steve-jobs-beatles-business-model/"> 
 “My model for business is The Beatles. They were four guys who kept each other's kind of negative tendencies in check. 
 They balanced each other and the total was greater than the sum of the parts. 
 That's how I see business: great things in business are never done by one person, they're done by a team of people.” 
 </blockquote> 
 <cite>Steve Jobs</cite> 
```

#### Más información:

[blockquote MDN](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/blockquote)