---
title: Href
localeTitle: Href
---
## Href

La referencia de hipertexto (HREF) es un atributo HTML que se usa para especificar un destino de enlace o un Localizador uniforme de recursos (URL). Más comúnmente verá el atributo HREF emparejado con una etiqueta de anclaje `<a>` .

El atributo HREF obtiene el significado exacto de un enlace según el elemento que lo esté utilizando. Por ejemplo, cuando se utiliza con la etiqueta `<a>` , hace referencia a la ubicación de un objeto expreso como una URL. Cuando se usa el atributo HREF con la etiqueta `<image>` , el atributo HREF hace referencia a la URL de la imagen a representar.

### Ejemplos:

Enlace a la página principal de Google:

\-> El texto "Visitar la página de inicio de Google actúa como el enlace a la página de inicio

```html

<a href="https://www.google.com">Visit Google's Homepage</a> 
```

La imagen como enlace:

\-> Logotipo de Google que hace referencia a la página principal de Google

```html

<a href="https://www.google.com"> 
 <img border="0" alt="Google" src="https://www.google.com/logos/doodles/2015/googles-new-logo-5078286822539264.3-hp2x.gif" width="100" height="100"> 
```

Etiquetas que utilizan HREF:

```html

<a> 
 <area> 
 <base> 
 <cursor> 
 <discard> 
 <feImage> 
 <hatch> 
 <image> 
 <link> 
 <mesh> 
 <meshgradient> 
 <mpath> 
 <pattern> 
 <script> 
 <textPath> 
 <use> 
```

#### Más información:

[WTF es un href de todos modos](https://tomayko.com/blog/2008/wtf-is-an-href-anyway) [MDN](https://developer.mozilla.org/en-US/docs/Web/SVG/Attribute/href)