---
title: Difference between Git and GitHub
localeTitle: Diferencia entre Git y GitHub
---
## Diferencia entre Git y GitHub

Git y Github son dos cosas diferentes. [Git](https://git-scm.com/) es el [sistema de control de versiones](https://en.wikipedia.org/wiki/Version_control) , mientras que [GitHub](https://github.com/) es un servicio para alojar repositorios de Git y ayudar a las personas a colaborar en la escritura de software. Sin embargo, a menudo se confunden por su nombre similar, debido al hecho de que GitHub se construye sobre Git, y porque muchos sitios web y artículos no hacen la diferencia entre ellos lo suficientemente clara.

![Git no es GitHub](https://i.imgur.com/EkjwJdr.png)

### Git

Git es el sistema de control de versiones distribuido. Git es responsable de realizar un seguimiento de los cambios en el contenido, generalmente los archivos de código fuente.

Para más información, hay un [artículo completo sobre el propio Git](https://guide.freecodecamp.org/git) .

### GitHub

GitHub es una empresa que proporciona hosting de repositorio Git. Eso significa que proporcionan una solución llave en mano para alojar repositorios Git en sus servidores. Eso puede ser útil para mantener una copia de seguridad de su repositorio (Git solo rastrea los cambios realizados en sus archivos a lo largo del tiempo, todavía se debe hacer una copia de seguridad de la repo), y tener un lugar centralizado para guardar y compartir su código con otros.

Más que un simple servicio de alojamiento de repositorios Git, GitHub es una [forja de software](https://en.wikipedia.org/wiki/Forge_(software)) . Eso significa que también proporciona un [rastreador de problemas](https://en.wikipedia.org/wiki/Issue_tracking_system) , herramientas para [revisar el código](https://en.wikipedia.org/wiki/Code_review) y otras herramientas para colaborar con otras personas y crear software.

GitHub no es el único que ofrece este tipo de servicio. Uno de sus principales competidores es [GitLab](https://gitlab.com) . Para más información sobre esto, consulte el [artículo sobre Git hosting](https://guide.freecodecamp.org/git/git-hosting) .