---
title: Algorithms
localeTitle: Algoritmos
---
## Algoritmos

En informática, un algoritmo es una especificación inequívoca de cómo resolver una clase de problemas. Los algoritmos pueden realizar cálculos, procesamiento de datos y tareas de razonamiento automatizado.

Un algoritmo es un método efectivo que se puede expresar en una cantidad finita de espacio y tiempo y en un lenguaje formal bien definido para calcular una función. Comenzando desde un estado inicial y una entrada inicial (quizás vacía), las instrucciones describen un cálculo que, cuando se ejecuta, avanza a través de un número finito de estados sucesivos bien definidos, que eventualmente producen "salida" y terminan en un estado final final. La transición de un estado a otro no es necesariamente determinista; algunos algoritmos, conocidos como algoritmos aleatorios, incorporan entrada aleatoria.

Hay ciertos requisitos que un algoritmo debe cumplir:

1.  Definitividad: Cada paso en el proceso se establece con precisión.
2.  Computabilidad efectiva: Cada paso del proceso puede ser llevado a cabo por una computadora.
3.  Finitud: El programa terminará con éxito.

Algunos tipos comunes de algoritmos incluyen algoritmos de clasificación, algoritmos de búsqueda y algoritmos de compresión. Las clases de algoritmos incluyen Gráficos, Programación dinámica, Clasificación, Búsqueda, Cadenas, Matemáticas, Geometría computacional, Optimización y Varios. Aunque técnicamente no es una clase de algoritmos, las estructuras de datos a menudo se agrupan con ellos.

### Eficiencia

Los algoritmos se juzgan más comúnmente por su eficiencia y la cantidad de recursos informáticos que requieren para completar su tarea. Una forma común de evaluar un algoritmo es observar su complejidad de tiempo. Esto muestra cómo crece el tiempo de ejecución del algoritmo a medida que crece el tamaño de entrada. Debido a que los algoritmos actuales deben operarse en grandes entradas de datos, es esencial que nuestros algoritmos tengan un tiempo de ejecución razonablemente rápido.

### Clasificación de los algoritmos

Los algoritmos de clasificación vienen en varios sabores dependiendo de su necesidad. Algunos, muy comunes y ampliamente utilizados son:

#### Ordenación rápida

No hay discusión de clasificación que pueda terminar sin una clasificación rápida. El concepto básico está en el siguiente enlace. [Ordenación rápida](http://me.dt.in.th/page/Quicksort/)

#### Combinar clasificación

Es el algoritmo de clasificación que se basa en el concepto de cómo se ordenan las matrices ordenadas que se combinan para dar una matriz ordenada. Lea más sobre esto aquí. [Combinar clasificación](https://www.geeksforgeeks.org/merge-sort/)

El currículo de freeCodeCamp enfatiza fuertemente la creación de algoritmos. Esto se debe a que los algoritmos de aprendizaje son una buena manera de practicar las habilidades de programación. Los entrevistadores suelen probar candidatos en algoritmos durante las entrevistas de trabajo del desarrollador.

### Recursos adicionales

[Introducción a los algoritmos | Curso intensivo: Informática](https://www.youtube.com/watch?v=rL8X2mlNHPM)

Este video ofrece una introducción accesible y animada a los algoritmos que se centran en los algoritmos de clasificación y búsqueda de gráficos.

[¿Qué es un algoritmo y por qué debería importarte? | academia Khan](https://www.youtube.com/watch?v=CvSOaYi89B4)

Este video presenta algoritmos y describe brevemente algunos usos de alto perfil de ellos.

[15 Clasificación de los algoritmos en 6 minutos | Timo Bingmann](https://www.youtube.com/watch?v=kPRA0W1kECg)

Este video muestra visualmente algunos algoritmos de clasificación populares que se enseñan comúnmente en los cursos de programación y ciencias de la computación.

[Visualizador de algoritmos](http://algo-visualizer.jasonpark.me)

Este es también un muy buen proyecto de código abierto que te ayuda a visualizar algoritmos.