---
title: Behavioral patterns
localeTitle: Patrones de comportamiento
---
## Patrones de comportamiento

Los patrones de diseño de comportamiento son patrones de diseño que identifican problemas comunes de comunicación entre objetos y realizan estos patrones. Al hacerlo, estos patrones aumentan la flexibilidad para llevar a cabo esta comunicación, haciendo que el software sea más confiable y fácil de mantener.

Ejemplos de este tipo de patrón de diseño incluyen:

1.  **Patrón de cadena de responsabilidad** : los objetos de comando se manejan o pasan a otros objetos mediante objetos de procesamiento que contienen lógica.
2.  **Patrón de comando** : los objetos de comando encapsulan una acción y sus parámetros.
3.  **Patrón de intérprete** : implemente un lenguaje informático especializado para resolver rápidamente un conjunto específico de problemas.
4.  **Patrón de iterador** : los iteradores se utilizan para acceder a los elementos de un objeto agregado de forma secuencial sin exponer su representación subyacente.
5.  **Patrón de mediador** : proporciona una interfaz unificada a un conjunto de interfaces en un subsistema.
6.  **Patrón de recuerdo** : proporciona la capacidad de restaurar un objeto a su estado anterior (retroceso).
7.  **Patrón de objeto nulo** : diseñado para actuar como un valor predeterminado de un objeto.
8.  **Patrón de observador** : también conocido como P **ublish / Subscribe** o **Event Listener** . Los objetos se registran para observar un evento que puede ser provocado por otro objeto.
9.  **Patrón de referencia débil** : desacoplar un observador de un observable.
10.  **Pila de protocolos** : las comunicaciones se manejan mediante varias capas, que forman una jerarquía de encapsulación.
11.  **Patrón de** tarea programada: una tarea está programada para realizarse en un intervalo determinado o en un tiempo de reloj (usado en computación en tiempo real).
12.  **Patrón de visitante de servicio único** : optimice la implementación de un visitante que se asigna, se usa solo una vez y luego se elimina.
13.  **Patrón de especificación** : lógica empresarial recombinante de forma booleana.
14.  **Patrón de estado** : una forma limpia de que un objeto cambie parcialmente su tipo en tiempo de ejecución.
15.  **Patrón de estrategia** : los algoritmos se pueden seleccionar sobre la marcha.
16.  **Patrón de método de plantilla** : describe el esqueleto del programa de un programa.
17.  **Patrón de visitante** : una forma de separar un algoritmo de un objeto.

### Fuentes

[https://en.wikipedia.org/wiki/Behavioral\_pattern](https://en.wikipedia.org/wiki/Behavioral_pattern)