---
title: Text Formatting in HTML
---

## Text Formatting in HTML
HTML provides you a lot of useful elements for text formatting. It allows to make your text: bold, italic, mark and much more. Changing the style of your text isn't without any reason - the main thing is just make the reader to take a look for some important notes.

### Bold and Strong
You can easily change your text meaning by using HTML `<b>` element. It makes words bold, which function is singling out the fragment of sequence. For example: 

```
The most important part of your code is <b>the end</b>, because if you <b>don't close</b> the element, it will affect to <b>everything</b>!
```

You can also use `<strong>` as well - it adds also semantic "strong" importance. Your browser doesn't recognize a difference between those two elements, but it exists. 

### Italic and Emphasized
Usually used when quote something or putting a translate of word in a lot of articles. It makes them italic - just imagine a little kicked in the right letters. For example: 

```
Theatre - <i>teatos</i>, <i>teates</i> and <i>teatron</i>.
```

You can also use `<em>` as well - it adds also semantic "emphasized" importance. Your browser doesn't recognize a difference between those two elements, but it exists. 

### Small 
It makes your text smaller than normal size of used font. This element's meaning was changed in HTML5 - it represents side-comments and small print. 

``` 
Normal, <small>small</small>, normal, <small>small</small>!
``` 

### Marked
Element `<mark>` makes your text marked - in different words, it makes your text highlighted. You can use it to tell readers that is one of important things in your article. For example:

``` 
HTML is full of things and <mark>it's our journey</mark> to get known them better!
``` 

### Deleted 
The element `<del>` makes your text striked in the center. It's useful to show changes in your documents. 

``` 
WWI started in <del>1913</del> 1914 year.
``` 

### Inserted 
Tag `<ins>` makes your text inserted to the article. Using other words that makes it much easier to understand - added. It shows a line under inserted text.

``` 
HTML isn't boring. <ins>You can make a lot of combinations of elements!</ins> 
``` 

### Subscripted 
Using element `<sub>` gives you a useful formatting as subscripted text (showing it smaller on the bottom). There is an example code: 

``` 
This was in 2003 year <sub>(needs a link)</sub>.
``` 

### Superscripted 
If you want to make an opposite to subscripted text, you can easily use `<sup>` element. It shows a smaller text on the top. 

``` 
10<sup>x+y</sup> = 1000
``` 
