---
title: Semantic HTML Elements
---

## Semantic HTML Elements
The `<em>` element marks text as being emphasized above the text around it. Typically, the browser renders this in *italics*, but you can add other styles using CSS.

Semantic HTML elements provide meaning to browsers, developers, and users of a site. In contrast to elements like `<div>` or `<span>`, semantic elements like `<header>` and `<footer>` more clearly explain the purpose of each section of a website.

### Why Use Semantic Elements?

Developers use semantic elements to enhance the following:

* accessibility: help assistive technologies read and interpret your webpage
* searchability: help computers make sense of your content
* internationalization: only 13% of the world are English native speakers
* interoperability: help other programmers understand the structure of your webpage <sup>1</sup>

### Useful Semantic Elements

* `<header>` defines a header for the document or a section
* `<footer>` defines a footer for the document or a section
* `<nav>` defines navigation links in the document
* `<main>` defines the main content of a document
* `<section>` defines a section in the document—the spec defines this as “a thematic grouping of content, typically with a heading," so you can think of it as being like a chapter
* `<article>` defines an article in the document
* `<aside>` defines content aside from the page content
* `<address>` defines the contact information for the author/owner of a document or an article
* `<figure>` defines self-contained content, like illustrations, diagrams, photos, code blocks, etc. <sup>2</sup>

### Lesser-known Semantic Elements

* `<bdi>` defines a section of text that might be formatted in a different direction from other text (for instance, a quote in Hebrew or Arabic in an otherwise-English article)
* `<details>` defines additional details that people can view or hide (like a tooltip)
* `<dialog>` defines a dialog box or window
* `<figcaption>` defines the caption for a `<figure>`
* `<mark>` defines marked or highlighted text
* `<menuitem>` defines a command/menu item that the user can select from a popup menu
* `<meter>` defines a scalar measurement within a known range (a gauge)
* `<progress>` defines the progress of a task
* `<rp>` defines what to show in browsers that do not support ruby annotations
* `<rt>` defines an explanation/pronunciation of characters (for east asian typography)
* `<ruby>` defines a ruby annotation (for east asian typography)
* `<summary>` defines a visible heading for a `<details>` element
* `<time>` defines a date/time
* `<wbr>` defines a possible line-break <sup>2</sup>

### Sources
1. [Lee, Michelle. "An Overview of HTML5 Semantics." *CodePen*. February 16, 2016. Accessed: October 24, 2017](https://codepen.io/mi-lee/post/an-overview-of-html5-semantics)
2. [Bidaux, Vincent. "HTML5 semantic elements and Webflow: the essential guide." *Webflow*. December 16, 2016. Accessed: October 24, 2017](https://webflow.com/blog/html5-semantic-elements-and-webflow-the-essential-guide)

#### More Information:
For more information: https://codepen.io/mi-lee/post/an-overview-of-html5-semantics

Refer to the [MDN Web Docs article](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/em).
