---
title: Meta Tag
---
## Meta Tag


The `<meta>` tag provides the metadata about the HTML document. 

This metadata is used to specify a page's charset, description, keywords, the author, and the viewport of the page. 

This metadata will not appear on the website itself, but it will be used by the browers and search engines to determine how the page will display content and assess search engine optimization (SEO). 

The metadata is assigned to the <head></head> of the HTML document:
```html
<head>
  <meta charset="UTF-8">
  <meta name="description" content="Short description of website content here">
  <meta name="keywords" content="HTML,CSS,XML,JavaScript">
  <meta name="author" content="Jane Smith">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
<!-- HTML5 introduced a method to let web designers take control over the viewport, through the <meta> tag. The viewport is the user's visible area of a web page. A <meta> viewport element gives the browser instructions on how to control the page's dimensions and scaling. -->  
</head>
```
#### More Information:
For additional information on the <meta> tag, please visit the following:
(https://www.w3schools.com/TAgs/tag_meta.asp "w3schools.com <meta> tag")
(https://developer.mozilla.org/en-US/docs/Web/HTML/Element/meta "MDN <meta> tag")



