---
title: Header Tag
---
## Header Tag

The `<header>` tag is a container which is used for navigational links or introductory content.
It may typically include heading elements, such as `<h1>`, `<h2>`, but may also include other elements such as a search form, logo, author information etc.
<h1> corresponds to the most important heading. As we move to other tags like <h2>, <h3>, etc the degree of importance decreases.
Although not required, the `<header>` tag is intended to contain the surrounding sections heading. It may also be used more than once in an HTML document. It is important to note that the `<header>` tag does not introduce a new section, but is simply the head of a section.

Here's an example using the `<header>` tag:

```html
<article>
  <header>
    <h1>Heading of Page</h1>
  </header>
    <p>Lorem ipsum dolor sit amet, consectetur adipiscing elit.</p>
</article>
```

#### More Information:
- [MDN](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/header)
- [W3 Schools](https://www.w3schools.com/tags/tag_header.asp)



