---
title: Head Tag
---
## Head Tag

The `<head>` tag contains information about a webpage. Along with `<body>`, it is one of the two required elements of an HTML document. `<head>` must be the first child of an `<html>` element. There can only be one `<head>` element on a page.

The `<head>` element contains information about how a webpage should be displayed, also known as metadata. The document title, links to stylesheets, and `<script>` tags linking to JavaScript files should all be placed in the `<head>`.  The `<head>` should not contain any page content.

  ```html
  <html>
  <head>
    <title>Document Titles Belong in the Head</title>
  </head>
  <body>
    <p>This paragraph is content. It goes in the body!</p>
  </body>
</html>
  ```
#### More Information:

- [MDN](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/head)


