---
title: Body Tag
---

## Body Tag

The `<body>` tag contains the content for a webpage. Along with `<head>`, it is one of the two required elements of an HTML document. `<body>` must be the second child of an `<html>` element. There can only be one `<body>` element on a page.

The `<body>` element should contain all of a page's content, including all display elements. The `<body>` element can also contain `<script>` tags, generally scripts that must be run after a page's content has been loaded.


```html
<html>
    <head>
        <title>Document Titles Belong in the Head</title>
    </head>
    <body>
        <p>This paragraph is content. It goes in the body!</p>
    </body>
</html>
```


#### More Information:
<a href='https://developer.mozilla.org/en-US/docs/Web/HTML/Element/body' target='_blank' rel='nofollow'>MDN</a>
