---
title: Placeholder Attribute
---
## Placeholder Attribute | HTML5

Specifies a short hint that describes the expected value of an `<input>` or `<textarea>` form control.

The placeholder attribute must not contain carriage returns or line-feeds.

NOTE: Do not use the placeholder attribute instead of a &lt;label&gt; element, their purposes are different. The &lt;label&gt; attribute describes the role of the form element (i.e. it indicates what kind of information is expected), and the placeholder attribute is a hint about the format that the content should take.

### Example

Input Example

```html
<form>
    <input type="text" name="fname" placeholder="First Name">
    <input type="text" name="lname" placeholder="Last Name">
</form>
```

Textarea Example

```html
<textarea placeholder="Describe yourself here..."></textarea>
```

### Compatibility

This is an HTML5 Attribute.

#### More Information:

[HTML placeholder Attribute](https://www.w3schools.com/tags/att_placeholder.asp) on w3schools.com