---
title: Font Color Attribute
---

## Font Color Attribute
This attribute is used to set a color to the text enclosed in a ```<font>``` tag.

### Syntax:
 ```html
 <font color= "color">
 ```
 
### Important:
This attribute is not supported in HTML5. Instead, this [freeCodeCamp article](https://guide.freecodecamp.org/css/colors) specifies a CSS method, which can be used.

### Note:
A color can also be specified using a 'hex code' or an 'rgb code', instead of using a name.
 
### Example:
1. Color name attribute
```html
<html>
  <body>
   <font color="green">Font color example using color attribute</font>
 </body>
</html>
```
2. Hex code attribute
```html
<html>
  <body>
   <font color="#00FF00">Font color example using color attribute</font>
  </body>
</html>
```
3. RGB attribute
```html
<html>
  <body>
    <font color="rgb(0,255,0)">Font color example using color attribute</font>
  </body>
</html>
```
