---
title: A Target Attribute
---
## A Target Attribute

The `<a target>` attribute specifies where to open the linked document in an `a` (anchor) tag.
<br>
 
#### Examples:


A target attribute with the value of “_blank” opens the linked document in a new window or tab.


```html
	<a href="https://www.freecodecamp.org" target="_blank">freeCodeCamp</a>
```

A target attribute with the value of “_self” opens the linked document in the same frame as it was clicked (this is the default and usually does not need to be specified).

```html
	<a href="https://www.freecodecamp.org" target="_self">freeCodeCamp</a>
```


```html
	<a href="https://www.freecodecamp.org">freeCodeCamp</a>
```

A target attribute with the value of “_parent” opens the linked document in the parent frame.

```html
	<a href="https://www.freecodecamp.org" target="_parent">freeCodeCamp</a>
```

A target attribute with the value of “_top” opens the linked document in the full body of the window.

```html
	<a href="https://www.freecodecamp.org" target="_top">freeCodeCamp</a>
```

A target attribute with the value of _"framename"_ Opens the linked document in a specified named frame.

```html
	<a href="https://www.freecodecamp.org" target="framename">freeCodeCamp</a>
```


#### More Information:

Target Attribute: <a href="https://www.w3schools.com/tags/att_a_target.asp" target="_blank">w3schools</a>  
