---
title: GUI Options
---

## GUI Options for Git

Most people prefer to use Git as a [CLI (command-line interface)](https://en.wikipedia.org/wiki/Command-line_interface) tool, but there are plenty of [GUI (graphical user interface)](https://en.wikipedia.org/wiki/Graphical_user_interface) tools allowing you to use Git in a graphical way. GUI tools can useful to get a better view of the state of your Git repository, and some might find them easier to use than the CLI. However, knowing how to use the CLI is highly recommended because it will be the same interface on every platform, because it is generally considered to be more efficient, and because it is required as soon as you want to do something even a little bit complex.

## List of Git GUI Based Solutions
* [GitKraken](https://www.gitkraken.com) is a popular Git GUI for Windows, Mac and Linux. It is proprietary but free for non-commercial use.
* [GitHub Desktop](https://desktop.github.com/) is the Git client application provided by GitHub, allowing better integration with GitHub than other solutions. It is available for Windows and Mac, but not yet for Linux. It is free and open source.
* [SourceTree](https://www.sourcetreeapp.com/) is another Git GUI for Windows and Mac by Atlassian. It has many features such as interactive rebase, designed to make using Git easier for beginners.
* [Git Tower](https://www.git-tower.com/mac/) is available for Mac and Windows.
* [TortoiseGit](https://tortoisegit.org/) is a Windows Shell Interface to Git based on TortoiseSVN. It's open source and can be built with freely available software.
* [SmartGit](https://www.syntevo.com/smartgit/) is a Git client free for a non-commercial use for Windows, Mac and Linux.
