---
title: Difference between Git and GitHub
---
## Difference between Git and GitHub

Git and GitHub are two different things. [Git](https://git-scm.com/) is the [version control system](https://en.wikipedia.org/wiki/Version_control), while [GitHub](https://github.com/) is a service for hosting Git repos and help people collaborate on writing software. However, they are often confounded because of their similar name, because of the fact that GitHub builds on top of Git, and because many websites and articles don't make the difference between them clear enough.

![Git is not GitHub](https://i.imgur.com/EkjwJdr.png)

### Git

Git is the distributed version control system. Git is responsible for keeping track of changes to content – usually source code files.

For more info, there is a [complete article about Git itself](https://guide.freecodecamp.org/git).

### GitHub

GitHub is a company that provides Git repository hosting. That means that they provide a turnkey solution to host Git repositories on their servers. That can be useful to keep a backup of your repository (Git only tracks the changes made to you files over time, the repo still needs to be backed up), and to have a centralized place to keep and share your code with others.

More than just a Git repository hosting service, GitHub is a [software forge](https://en.wikipedia.org/wiki/Forge_(software)). That means it also provides an [issue tracker](https://en.wikipedia.org/wiki/Issue_tracking_system), tools for [code review](https://en.wikipedia.org/wiki/Code_review), and other tools for collaborating with other people and creating software.

GitHub isn't the only one to provide this kind of service. One of its major competitors is [GitLab](https://gitlab.com). For more on this, look at the [article about Git hosting](https://guide.freecodecamp.org/git/git-hosting).
