---
title: Algorithms
---

## Algorithms

In computer science, an algorithm is an unambiguous specification of how to solve a class of problems. Algorithms can perform calculations, data processing and automated reasoning tasks.

An algorithm is an effective method that can be expressed within a finite amount of space and time and in a well-defined formal language for calculating a function. Starting from an initial state and initial input (perhaps empty), the instructions describe a computation that, when executed, proceeds through a finite number of well-defined successive states, eventually producing "output" and terminating at a final ending state. The transition from one state to the next is not necessarily deterministic; some algorithms, known as randomized algorithms, incorporate random input.

There are certain requirements that an algorithm must abide by:
<ol>
  <li>Definiteness: Each step in the process is precisely stated.</li>
  <li>Effective Computability: Each step in the process can be carried out by a computer.</li>
  <li>Finiteness: The program will eventually successfully terminate.</li>
</ol>

Some common types of algorithms include sorting algorithms, search algorithms, and compression algorithms. Classes of algorithms include Graph, Dynamic Programming, Sorting, Searching, Strings, Math, Computational Geometry, Optimization, and Miscellaneous. Although technically not a class of algorithms, Data Structures are often grouped with them. 

### Efficiency

Algorithms are most commonly judged by their efficiency and the amount of computing resources they require to complete their task. A common way to evaluate an algorithm is to look at its time complexity. This shows how the running time of the algorithm grows as the input size grows. Since algorithms today have to operate on large data inputs, it is essential for our algorithms to have a reasonably fast running time.

### Sorting Algorithms

Sorting algorithms come in various flavors depending on your necessity.
Some, very common and widely used are:

#### Quick Sort

There is no sorting discussion which can finish without quick sort. The basic concept is in the link below.
[Quick Sort](http://me.dt.in.th/page/Quicksort/)

#### Merge Sort
It is the sorting algorithm which relies on the concept how to sorted arrays are merged to give one sorted arrays. Read more about it here-
[Merge Sort](https://www.geeksforgeeks.org/merge-sort/)

freeCodeCamp's curriculum heavily emphasizes creating algorithms. This is because learning algorithms is a good way to practice programming skills. Interviewers most commonly test candidates on algorithms during developer job interviews.

### Further Resources

[Intro to Algorithms | Crash Course: Computer Science](https://www.youtube.com/watch?v=rL8X2mlNHPM)

This video gives an accessible and lively introduction to algorithms focusing on sorting and graph search algorithms. 

[What is an Algorithm and Why Should you Care? | Khan Academy](https://www.youtube.com/watch?v=CvSOaYi89B4)

This video introduces algorithms and briefly discusses some high profile uses of them. 

[15 Sorting Algorithms in 6 Minutes | Timo Bingmann](https://www.youtube.com/watch?v=kPRA0W1kECg)

This video visually demonstrates some popular sorting algorithms that are commonly taught in programming and Computer Science courses.

[Algorithm Visualizer](http://algo-visualizer.jasonpark.me)

This is a really good open source project that helps you visualize algorithms. 

[Infographic on how Machine Learning Algorithms Work](https://www.boozallen.com/content/dam/boozallen_site/sig/pdf/infographic/how-do-machines-learn.pdf)

This infographic shows you how unsupervised and supervised machine learning algorithms work.
