<?php
/**
 * Open Source Social Network
 *
 * @package   (softlab24.com).ossn
 * @author    OSSN Core Team <info@softlab24.com>
 * @copyright (C) SOFTLAB24 LIMITED
 * @license   Open Source Social Network License (OSSN LICENSE)  http://www.opensource-socialnetwork.org/licence
 * @link      https://www.opensource-socialnetwork.org/
 */

$en = array(
	'home' => 'Home',
	'site:index' => 'Welcome',
	'news:feed' => 'News Feed',
	'new:feed' => 'News Feed',
	'photos:ossn' => 'Photos',
	'admin:view:site' => 'View Site',
	
	'home:top:heading' => "Welcome to %s! Join now to make new friends, create groups, add photos, and much more.",
	'create:account' => 'Create an account',
	'its:free' => "It's free and always will be.",
	
	'register:ok:message' => "Your account has been registered. An activation email has been sent to your mailbox. If you didn't receive the email, please check your spam/junk folder.",
	
	'copyright' => '&copy; COPYRIGHT',
	'powered' => 'Powered by the Open Source Social Network.',
	
	'name' => 'Name',
	'birthdate' => 'Birthdate',
	'first:name' => 'First Name',
	'last:name' => 'Last Name',
	'email' => 'Email',
	'email:again' => 'Re-enter Email',
	'username' => 'Username',
	'password' => 'Password',
	'day' => 'Day',
	'month' => 'Month',
	'year' => 'Year',
	'male' => 'Male',
	'female' => 'Female',
	'account:create:notice' => 'By clicking Create an account, you agree to our',
	'gender' => 'Gender',
	
	'account:settings' => 'Account Settings',
	'page:error' => 'Page Not Found!',
	'page:error:text' => 'The page you requested is unavailable or may have been deleted.',
	'page:error:heading' => '404',
	
	'search:users' => 'People',
	'admin:logout' => 'Log out',
	'logout' => 'Log out',
	
	'ossn:like:this' => '%s liked this',
	'ossn:like:you:and:this' => 'You and %s liked this',
	'ossn:like:people' => '%s People',
	'ossn:like:person' => '%s Person',
	'ossn:liked:you' => 'You liked this',
	'ossn:unlike' => 'Unlike',
	'ossn:like' => 'Like',
	
	'admin:components' => 'Components',
	'admin:dashboard' => 'Dashboard',
	'admin:install' => 'Installer',
	'admin:themes' => 'Themes',
	'admin:basic' => 'Basic',
	'admin:cache' => 'Cache',
	'admin:mode' => 'Mode',
	'configure' => 'Configure',
	'admin:help' => 'Help',
	'admin:support' => 'Support',
	
	'ossn:update:check:error' => 'Error',
	
	'upload' => 'Upload',
	'save' => 'Save',
	'add' => 'Add',
	'edit' => 'Edit',
	'search' => 'Search',
	'delete' => 'Delete',
	
	'admin:users' => 'List Users',
	'admin:add:user' => 'Add User',
	'admin:user:deleted' => 'User has been deleted!',
	'admin:user:delete:error' => 'Unable to delete user. Please try again later.',
	
	'type' => 'Type',
	'normal' => 'Normal',
	'admin' => 'Administrator',
	
	'lastlogin' => 'Last Login',
	
	'my:version' => 'My OSSN Version',
	'online:users' => 'Users Online',
	'themes' => 'Themes',
	'users' => 'Users',
	'components' => 'Components',
	'available:updates' => 'Available Updates',
	'website:name' => 'Website Name',
	'owner:email' => 'Owner Email',
	'default:lang' => 'Default Language',
	
	'timeline' => 'Timeline',
	'photos' => 'Photos',
	'friends' => 'Friends',
	'links' => 'Links',
	'ossn:add:user:mail:subject' => "%s please confirm your email address for %s!",
	'ossn:add:user:mail:body' => "Before you can start using %s, you must confirm your email address.

Please confirm your email address by clicking on the link below:

%s

You may copy and paste the address to your browser manually in case the link does not work.

%s",
	'user:friends' => 'Friends',
	'user:account:validated' => 'Account has been validated successfully!',
	'user:account:validate:fail' => 'Cannot validate account! Please try again later.',
	
	'cache:enabled' => 'Cache successfully enabled!',
	'cache:disabled' => 'Cache successfully disabled!',
	'cache:enable' => 'Enable Cache',
	'cache:disable' => 'Disable Cache',
	
	'cache:1' => 'Enabled',
	'cache:0' => 'Disabled',
	'cache:notice' => 'Stores CSS and Javascript files in a cache to improve site performance.',
	
	'theme:install:notice' => 'Upload a valid .zip theme package.',
	'com:install:notice' => 'Upload a valid .zip component package.',
	
	'login:error' => 'Invalid username or passsword!',
	'login:error:sub' => "We couldn't log you in. Please check your username or password and try again.",
	'login:success' => 'You are now logged in!',
	'com:installed' => 'Component has been uploaded to your components list, you can now enable it from components page.',
	'com:install:error' => 'Cannot upload component, make sure it is a valid package.',
	'settings:saved' => 'Settings saved',
	'com:deleted' => 'Component has been deleted!',
	'com:delete:error' => 'Cannot delete component! Please try again later.',
	'com:disabled' => 'Successfully disabled!',
	'com:enabled' => 'Component Enabled!',
	
	'theme:delete:active' => 'Cannot delete active theme.',
	'theme:deleted' => 'Theme has been deleted.',
	'theme:delete:error' => 'Cannot delete theme! Please try again later.',
	'theme:enabled' => 'Theme has been successfully enabled!',
	'theme:installed' => 'Theme has been successfully installed!',
	'theme:install:error' => 'Unable to install theme. Make sure it is compatible with the OSSN version you are using.',
	
	'fields:require' => 'All fields are required!',
	'username:error' => 'Username is invalid.',
	'password:error' => 'Password must be more than 5 characters.',
	'account:created' => 'Your account has been created.',
	'account:create:error:admin' => 'Account registration failed! Please try again later.',
	'user:updated' => 'User has been updated!',
	'logged:out' => 'You are now logged out!',
	'username:inuse' => 'The following username has already been used. Please select a different username.',
	'email:inuse' => 'The email address you used already exists in our database. Please try another email address.',
	'email:invalid' => 'Email address is invalid! Make sure the email address you entered is correct.',
	'email:error:matching' => "Email addresses do not match.",
	'account:created:email' => "Your account has been registered! We have sent you an account activation email. If you didn't receive the email, please check your spam/junk folder",
	
	'administration' => 'Administration',
	
	'privacy' => 'Privacy',
	'close' => 'Closed',
	'open' => 'Open',
	'public' => 'Public',
	'friends' => 'Friends',
	'privacy:public:note' => 'Everyone on this site can see this.',
	'privacy:friends:note' => 'Only your friends can see this.',
	
	'add:friend' => 'Add friend',
	'cancel:request' => 'Cancel Request',
	'remove:friend' => 'Unfriend',
	'no:friends' => 'No Friends',
	'settings' => 'Settings',
	'ossn:add:friend:error' => 'Cannot add friend!',
	'ossn:friend:request:submitted' => 'Your friend request has been sent!',
	
	/* Upgrades */
	'upgrade:file:load:error' => 'Cannot load upgrade file!',
	'upgrade:success' => "Your website has been upgraded successfully to release %s.",
	'upgrade:failed' => "Cannot upgrade your site to release %s.",
	'upgrade:not:available' => 'Nothing to upgrade!',
	
	'site:login' => 'Login',
	/* Page errors */
	'system:error:title' => 'Something went wrong!',
	'system:error:text' => 'Something went wrong! Reload this page and try again.',
	
	/* Password Reset */
	'reset:login' => 'Reset Password',
	'reset:password' => 'Reset your password',
	'enter:new:password' => 'Enter your new password below and click reset.',
	'reset' => 'Reset',
	'enter:emai:reset:pwd' => 'Enter the email address of your account in order to reset the password.',
	'ossn:reset:password:subject' => 'Reset your password',
	'ossn:reset:password:body' => "Hello %s,
	
Please click the link below to reset password or copy the link and paste into your browser's address bar:

%s

%s",
	'passord:reset:success' => 'Password successfully changed!',
	'passord:reset:fail' => 'Cannot reset password! Please try again later.',
	'password:reset:email:required' => 'Email cannot be empty!',
	'passord:reset:email:success' => 'Password reset instructions have been sent to your email address.',
	
	'erros:reporting' => 'Error Reporting',
	'erros:off' => 'Off',
	'erros:on' => 'On',
	'basic:settings' => 'Basic Settings',
	
	'ossn:new:version:error' => 'Unknown',
	'ossn:version:avaialbe' => "%s",
	
	'ossn:exception:title' => 'A system error has occurred. Please try again later. You may email the details of this error to the system administrator at %s.',
	'ossn:securitytoken:failed' => 'The action you requested is invalid.',
	'ossn:component:delete:exception' => 'Are you sure you want to delete this component?',
	'ossn:user:delete:exception' => 'Are you sure you want to delete this user?',
	
	//access
	'title:access:1' => 'Private',
	'title:access:2' => 'Public',
	'title:access:3' => 'Friends',
	
	'upload:file:error:ini_size' => 'The file you tried to upload is too large.',
	'upload:file:error:form_size' => 'The file you tried to upload is too large.',
	'upload:file:error:partial' => 'The file upload did not complete.',
	'upload:file:error:no_file' => 'No file was selected.',
	'upload:file:error:no_tmp_dir' => 'Cannot save the uploaded file.',
	'upload:file:error:cant_write' => 'Cannot save the uploaded file.',
	'upload:file:error:extension' => 'Cannot save the uploaded file.',
	'upload:file:error:unknown' => 'The file upload failed.',
	
	'ossn:post:size:exceed' => 'The action you requested exceeds the size limit.',
	
	'admin:com:installer' => 'Component Installer',
	'admin:theme:installer' => 'Theme Installer',
	'admin:cache:settings' => 'Cache Settings',
	'admin:user:list' => 'Users List',
	'admin:edit:user' => 'Edit User',
	'admin:login' => 'Login',
	'admin:notification:email' => 'Site Notification Email',
	'notification_email' => 'Notification Email (noreply@domain.com)',
	'owner_email' => 'Owner Email (mysite@domain.com)',
	'ossn:websitename' => 'Name of your website',
	'ossn:user:validation:resend' => 'Your account is not validated! You must validate your account before logging in. Another validation email has been sent to your email address.',
	'site:timepassed:text' => '%s ago',
	// localization of passed time: 16 time elements (even = singular / odd = plural)
	'site:timepassed:data' => 'second|seconds|minute|minutes|hour|hours|day|days|week|weeks|month|months|year|years|decade|decades',
	'ossn:notification:no:notification' => 'Nothing to show',
	'admin:button:enable' => 'Enable',
	'admin:button:enabled' => 'Enabled',
	'admin:button:disable' => 'Disable',
	'admin:button:configure' => 'Configure',
	'admin:button:delete' => 'Delete',
	'admin:component:author' => 'Author',
	'admin:component:website' => 'Website',
	'admin:sidemenu:components' => 'Components',
	'admin:sidemenu:themes' => 'Themes',
	'admin:sidemenu:settings' => 'Site Settings',
	'admin:sidemenu:usermanager' => 'User Manager',
	'cancel' => 'Cancel',
	'ossn:language:complete' => 'Complete',
	'ossn:pagination:first' => 'First',
	'ossn:pagination:last' => 'Last',
	'validate' => 'Validate',
	'admin:users:unvalidated' => 'Unvalidated Users',
	'admin:user:validated' => 'User validated',
	'admin:user:validate:error' => 'Could not validate user.',
	
	//v3.0
	//admin
	'my:files:version' => 'My Ossn Files Version',
	'cache:flush:error' => 'Can not flush cache, make sure cache is enabled in cache settings',
	'cache:flushed' => 'Cache flushed successfully',
	'ossn:version' => 'OSSN version', 
	'php:extension' => 'PHP extension',
	'php:version' => 'PHP version',
	'php:function' => 'PHP function',
	'admin:old:com' => "Your ossn_com.xml file is based on old version of Ossn. Please update '%s' component.",
	'admin:old:theme' => "Your ossn_theme.xml file is based on old version of Ossn. Please update '%s' theme.",
	'admin:button:disabled' => 'Disabled',
	'admin:flush:cache' => 'Flush Cache',
	'admin:com:version' => 'Version',
	'admin:com:author' => 'Author',
	'admin:com:author:url' => 'Author URL',
	'admin:com:license' => 'License',
	'admin:com:requirements' => 'Requirements',
	'admin:com:availability' => 'Availability',
	'ossn:exception:make:sure' => 'Are you sure?',
	'ossn:premium' => 'Premium Version',
	'datepicker:days' => "Su, Mo, Tu, We, Th, Fr, Sa",
	'datepicker:months' => "Jan., Feb., Mar., Apr., May, June, July, Aug., Sep., Oct., Nov., Dec.",
	/*
	 * List of ISO 639-1 language codes
	 * http://en.wikipedia.org/wiki/List_of_ISO_639-1_codes
	 */
	"aa" => "Afar",
	"ab" => "Abkhazian",
	"af" => "Afrikaans",
	"am" => "Amharic",
	"ar" => "Arabic",
	"as" => "Assamese",
	"ay" => "Aymara",
	"az" => "Azerbaijani",
	"ba" => "Bashkir",
	"be" => "Byelorussian",
	"bg" => "Bulgarian",
	"bh" => "Bihari",
	"bi" => "Bislama",
	"bn" => "Bengali; Bangla",
	"bo" => "Tibetan",
	"br" => "Breton",
	"ca" => "Catalan",
	"co" => "Corsican",
	"cs" => "Czech",
	"cy" => "Welsh",
	"da" => "Danish",
	"de" => "German",
	"dz" => "Bhutani",
	"el" => "Greek",
	"en" => "English",
	"eo" => "Esperanto",
	"es" => "Spanish",
	"et" => "Estonian",
	"eu" => "Basque",
	"fa" => "Persian",
	"fi" => "Finnish",
	"fj" => "Fiji",
	"fo" => "Faeroese",
	"fr" => "French",
	"fy" => "Frisian",
	"ga" => "Irish",
	"gd" => "Scots / Gaelic",
	"gl" => "Galician",
	"gn" => "Guarani",
	"gu" => "Gujarati",
	"he" => "Hebrew",
	"ha" => "Hausa",
	"hi" => "Hindi",
	"hr" => "Croatian",
	"hu" => "Hungarian",
	"hy" => "Armenian",
	"ia" => "Interlingua",
	"id" => "Indonesian",
	"ie" => "Interlingue",
	"ik" => "Inupiak",
	"is" => "Icelandic",
	"it" => "Italian",
	"iu" => "Inuktitut",
	"iw" => "Hebrew (obsolete)",
	"ja" => "Japanese",
	"ji" => "Yiddish (obsolete)",
	"jw" => "Javanese",
	"ka" => "Georgian",
	"kk" => "Kazakh",
	"kl" => "Greenlandic",
	"km" => "Cambodian",
	"kn" => "Kannada",
	"ko" => "Korean",
	"ks" => "Kashmiri",
	"ku" => "Kurdish",
	"ky" => "Kirghiz",
	"la" => "Latin",
	"ln" => "Lingala",
	"lo" => "Laothian",
	"lt" => "Lithuanian",
	"lv" => "Latvian/Lettish",
	"mg" => "Malagasy",
	"mi" => "Maori",
	"mk" => "Macedonian",
	"ml" => "Malayalam",
	"mn" => "Mongolian",
	"mo" => "Moldavian",
	"mr" => "Marathi",
	"ms" => "Malay",
	"mt" => "Maltese",
	"my" => "Burmese",
	"na" => "Nauru",
	"ne" => "Nepali",
	"nl" => "Dutch",
	"no" => "Norwegian",
	"oc" => "Occitan",
	"om" => "(Afan) Oromo",
	"or" => "Oriya",
	"pa" => "Punjabi",
	"pl" => "Polish",
	"ps" => "Pashto / Pushto",
	"pt" => "Portuguese",
	"qu" => "Quechua",
	"rm" => "Rhaeto-Romance",
	"rn" => "Kirundi",
	"ro" => "Romanian",
	"ru" => "Russian",
	"rw" => "Kinyarwanda",
	"sa" => "Sanskrit",
	"sd" => "Sindhi",
	"sg" => "Sangro",
	"sh" => "Serbo-Croatian",
	"si" => "Singhalese",
	"sk" => "Slovak",
	"sl" => "Slovenian",
	"sm" => "Samoan",
	"sn" => "Shona",
	"so" => "Somali",
	"sq" => "Albanian",
	"sr" => "Serbian",
	"ss" => "Siswati",
	"st" => "Sesotho",
	"su" => "Sundanese",
	"sv" => "Swedish",
	"sw" => "Swahili",
	"ta" => "Tamil",
	"te" => "Tegulu",
	"tg" => "Tajik",
	"th" => "Thai",
	"ti" => "Tigrinya",
	"tk" => "Turkmen",
	"tl" => "Tagalog",
	"tn" => "Setswana",
	"to" => "Tonga",
	"tr" => "Turkish",
	"ts" => "Tsonga",
	"tt" => "Tatar",
	"tw" => "Twi",
	"ug" => "Uigur",
	"uk" => "Ukrainian",
	"ur" => "Urdu",
	"uz" => "Uzbek",
	"vi" => "Vietnamese",
	"vo" => "Volapuk",
	"wo" => "Wolof",
	"xh" => "Xhosa",
	"yi" => "Yiddish",
	"yo" => "Yoruba",
	"za" => "Zuang",
	"zh" => "Chinese",
	"zu" => "Zulu"
);
ossn_register_languages('en', $en);
