<?php
/**
 * Open Source Social Network
 *
 * @package   (softlab24.com).ossn
 * @author    OSSN Core Team <info@softlab24.com>
 * @copyright (C) SOFTLAB24 LIMITED
 * @license   Open Source Social Network License (OSSN LICENSE)  http://www.opensource-socialnetwork.org/licence
 * @link      https://www.opensource-socialnetwork.org/
 */
$OssnMessages     = new OssnMessages;
$params['count'] =  $OssnMessages->recentChat(ossn_loggedin_user()->guid, true);
?>
<div class="messages-inner">

    <div class="ossn-notification-messages">
        <?php
        if ($params['recent']) {
            foreach ($params['recent'] as $message) {
                if ($message->answered) {
                    $user = ossn_user_by_guid($message->message_from);
                    $text = ossn_call_hook('messages', 'message:smilify', null, $message->message);
                    $replied = "<i class='fa fa-reply'></i><div class='reply-text'>{$text}</div>";
                } else {
                    $user = ossn_user_by_guid($message->message_from);
                    $text = ossn_call_hook('messages', 'message:smilify', null, $message->message);
                    $replied = "<div class='reply-text-from'>{$text}</div>";
                }
                if ($message->viewed == 0 && $message->message_from !== ossn_loggedin_user()->guid) {
                    $new = 'message-new';
                } else {
                    $new = '';
                }
                ?>
                <div class="user-item <?php echo $new; ?>"
                     onclick="Ossn.redirect('messages/message/<?php echo $user->username; ?>');">
                    <div class="user-item-inner">
                        <div class="image"><img
                                src="<?php echo ossn_site_url(); ?>avatar/<?php echo $user->username; ?>/small"/></div>
                        <div class="data">
                            <div class="name">
				<?php echo $user->fullname; ?>
			    </div>
			     <div class="time"><?php echo ossn_user_friendly_time($message->time); ?> </div>				
                            <div class="reply"><?php echo $replied; ?></div>
                        </div>
                    </div>
                </div>
            <?php
            }

        }
		echo ossn_view_pagination($params['count'],10, array(
							'offset_name' => 'offset_message_xhr_recent',															 
		));
		?>

    </div>
</div>
<div class="bottom-all">
    <a href="<?php echo ossn_site_url("messages/all"); ?>"><?php echo ossn_print('see:all'); ?></a>
</div>
