[//]: (copy freecodecamps most current contributing guidlines, also make a page for the w3develops pages mentioned below.)
# Contribution Guidelines

Hello 👋!

w3Develops.org is possible, thanks to thousands of kind volunteers like you. We are grateful for your contributions and we are excited to welcome you aboard.

We strictly enforce our ["Code of Conduct"](https://www.w3develops.org/code-of-conduct). Take a moment to read it. It's only 196 words long.

Happy contributing 🎉!

## Here are some fun ways that you can help

You can choose to contribute to any area that interests you:

1. [Contribute to this open source codebase](#contribute-to-this-open-source-codebase). Help to edit [guide articles](https://w3develops.org/guide), [coding projects](https://w3develops.org/projects), or fix bugs on the learning platform.

2. Help campers on our [public forum](https://www.w3develops.org/forum/). Answer their coding questions or give them feedback on their coding projects.

3. Help us add subtitles or closed captions to our [YouTube channel videos](https://www.youtube.com/channel/UC8butISFwT-Wl7EV0hUK0BQ/videos).

## Contribute to this open source codebase

Our open source codebase consisting of many of [coding projects](https://w3develops.org/projects) and [guide articles](https://w3develops.org/guide).

You can help us to:

- [📝 Clarify, Write and Update our guide](#clarify-write-and-update-our-guide)

- [💻 Create, Update and Fix Bugs in our coding projects](#create-update-and-fix-bugs-in-our-coding-projects)

- [Translate the website](#translate-the-website)

- [🛠 Fix bugs in w3Develops.org's learning platform](#help-us-fix-bugs-in-w3developsorgs-learning-platform)

### Clarify, Write and Update our guides

**What is the guide?**

Our guides will help you get a quick understanding of what a study group or project collaboration group is. These are short, plain English explanations that you can read before signing up to join a study group or project collaboration group.

**What can I write an guide about?**

We welcome your help writing these guides. You don't have to be an expert in a topic to write about it but you should know how a study group or project collaboration group operates. This entire Guide is open source, so even if you make a mistake, another contributor will eventually correct it.

To help find a guide to write about go to our [projects page](https://w3develops.org/projects) or [study groups page](https://w3develops.org/groups), find a topic you are knowedgable in write the article, then open a pull request to replace the current page with your updated version. A [pull request](https://help.github.com/articles/about-pull-requests/) is how you'll suggest changes. It lets others know about, review, and eventually adopt your changes.

### Create, Update and Fix Bugs in our coding projects

All our coding projects are curated by the community, bringing in expert knowledge from volunteers like you.

You can help expand them and make their wording clearer. You can update the user stories to explain the concept better and even remove redundant ones. You can also improve the projects themselves and create new ones for users to try to recreate.

### Translate the website

You can help us translate our Guide for a language that you speak.

We would love your help in improving the quality of these translations. We aim for millions of people to use the English language version of w3develops.org, and we expect millions more to use these translated versions as well.

### Help us fix bugs in w3Develops.org's learning platform

You are not required to be an expert on all the technologies we use them in order to contribute.

Feel free to ask us questions on the related issue threads, and we will be glad to clarify. When in doubt, you can reach Jonathan Jackson [`@jondevops`](https://github.com/jondevops) from our platform dev team to help you with this.

## Frequently Asked Questions

**How can I report a bug that is not on board?**

If you're confident it's a new bug, go ahead and create a new GitHub issue. Be sure to include as much information as possible so that we can reproduce the bug. We have a pre-defined issue template to help you through this.

Please note that any issues that seek coding help or personal help with study group members will be closed. The issue tracker is strictly for codebase related issues and discussions. Whenever in doubt, you should [seek assistance on the forum](https://www.w3develops.org/forum) before making a report.

**How can I report a security issue?**

Please don't create GitHub issues for security issues. Instead, please send an email to `security@w3develops.org` and we'll look into it immediately.

**I am stuck on something that is not included in this documentation. How can I get help?**

Feel free to ask for help in:

- [The "Contributors" category of our public forum](https://www.w3develops.org/forum)
- [Our public contributors chat room on Discord](https://discord.gg/ckQ52gA)

We are excited to help you contribute to any of the topics that you would like to work on. Make sure you search for your query before posting a new one. Be polite and patient. Our community of volunteers and moderators are always around to guide you through your queries.

**I am new to GitHub and Open Source in general:**

Read freeCodeCamps [How to Contribute to Open Source Guide](https://github.com/freeCodeCamp/how-to-contribute-to-open-source).

**What do these different labels that are tagged on issues mean?**

Our community moderators [triage](https://en.wikipedia.org/wiki/Software_bug#Bug_management) issues and pull requests based on their priority, severity, and other factors. You can [find a complete glossary of their meanings here](https://github.com/w3develops/w3develops/labels).

You should go through 'help wanted' or 'first timers welcome' issues for a quick overview of what is available for you to work on. These are up for grabs, and you do not need to seek permission before working on them.

If these issues lack clarity on what needs to be done, feel free to ask questions in the comments.

**I found a typo, should I report an issue before I can make a pull request?**

For typos and other wording changes, you can directly open pull requests without first creating an issue. Issues are more for discussing larger problems associated with code or structural aspects of the curriculum.
