Computer Modern Web Fonts
=========================

This repo contains the core Computer Modern fonts, converted from their original
sources into WOFF2 web fonts and hosted via jsdelivr CDN.

View the [example](https://vsalvino.github.io/computer-modern/).

Fonts are converted via FontForge from sources at: https://cm-unicode.sourceforge.io/

To use the fonts via CDN, copy the links below.


## Computer Modern Bright

Add to `<head>`:
```html
<link src="https://cdn.jsdelivr.net/gh/vsalvino/computer-modern@main/fonts/bright.css" rel="stylesheet">
```

Or import in CSS:
```css
@import url("https://cdn.jsdelivr.net/gh/vsalvino/computer-modern@main/fonts/bright.css");
```

Use in CSS:
```css
font-family: "Computer Modern Bright", sans-serif;
```

## Computer Modern Concrete

Add to `<head>`:
```html
<link src="https://cdn.jsdelivr.net/gh/vsalvino/computer-modern@main/fonts/concrete.css" rel="stylesheet">
```

Or import in CSS:
```css
@import url("https://cdn.jsdelivr.net/gh/vsalvino/computer-modern@main/fonts/concrete.css");
```

Use in CSS:
```css
font-family: "Computer Modern Concrete", serif;
```

## Computer Modern Sans

Add to `<head>`:
```html
<link src="https://cdn.jsdelivr.net/gh/vsalvino/computer-modern@main/fonts/sans.css" rel="stylesheet">
```

Or import in CSS:
```css
@import url("https://cdn.jsdelivr.net/gh/vsalvino/computer-modern@main/fonts/sans.css");
```

Use in CSS:
```css
font-family: "Computer Modern Sans", sans-serif;
```

## Computer Modern Serif

Add to `<head>`:
```html
<link src="https://cdn.jsdelivr.net/gh/vsalvino/computer-modern@main/fonts/serif.css" rel="stylesheet">
```

Or import in CSS:
```css
@import url("https://cdn.jsdelivr.net/gh/vsalvino/computer-modern@main/fonts/serif.css");
```

Use in CSS:
```css
font-family: "Computer Modern Serif", serif;
```

## Computer Modern Typewriter

Add to `<head>`:
```html
<link src="https://cdn.jsdelivr.net/gh/vsalvino/computer-modern@main/fonts/typewriter.css" rel="stylesheet">
```

Or import in CSS:
```css
@import url("https://cdn.jsdelivr.net/gh/vsalvino/computer-modern@main/fonts/typewriter.css");
```

Use in CSS:
```css
font-family: "Computer Modern Typewriter", monospace;
```
