// Copyright © 2021 VMware, Inc. All Rights Reserved.
// Copyright © 2013 Tsubai Masanari
// Copyright © 2013 Bryan Venteicher <bryanv@FreeBSD.org>
// SPDX-License-Identifier: BSD-2-Clause

/* automatically generated by rust-bindgen 0.57.0 */

use crate::pci::DmaObject;
use core::convert::TryInto;
use x86::current::paging::PAddr;

#[repr(C)]
#[derive(Copy, Clone, Debug, Default, Eq, Hash, Ord, PartialEq, PartialOrd)]
pub struct __BindgenBitfieldUnit<Storage> {
    storage: Storage,
}
impl<Storage> __BindgenBitfieldUnit<Storage> {
    #[inline]
    pub const fn new(storage: Storage) -> Self {
        Self { storage }
    }
}
impl<Storage> __BindgenBitfieldUnit<Storage>
where
    Storage: AsRef<[u8]> + AsMut<[u8]>,
{
    #[inline]
    pub fn get_bit(&self, index: usize) -> bool {
        debug_assert!(index / 8 < self.storage.as_ref().len());
        let byte_index = index / 8;
        let byte = self.storage.as_ref()[byte_index];
        let bit_index = if cfg!(target_endian = "big") {
            7 - (index % 8)
        } else {
            index % 8
        };
        let mask = 1 << bit_index;
        byte & mask == mask
    }
    #[inline]
    pub fn set_bit(&mut self, index: usize, val: bool) {
        debug_assert!(index / 8 < self.storage.as_ref().len());
        let byte_index = index / 8;
        let byte = &mut self.storage.as_mut()[byte_index];
        let bit_index = if cfg!(target_endian = "big") {
            7 - (index % 8)
        } else {
            index % 8
        };
        let mask = 1 << bit_index;
        if val {
            *byte |= mask;
        } else {
            *byte &= !mask;
        }
    }
    #[inline]
    pub fn get(&self, bit_offset: usize, bit_width: u8) -> u64 {
        debug_assert!(bit_width <= 64);
        debug_assert!(bit_offset / 8 < self.storage.as_ref().len());
        debug_assert!((bit_offset + (bit_width as usize)) / 8 <= self.storage.as_ref().len());
        let mut val = 0;
        for i in 0..(bit_width as usize) {
            if self.get_bit(i + bit_offset) {
                let index = if cfg!(target_endian = "big") {
                    bit_width as usize - 1 - i
                } else {
                    i
                };
                val |= 1 << index;
            }
        }
        val
    }
    #[inline]
    pub fn set(&mut self, bit_offset: usize, bit_width: u8, val: u64) {
        debug_assert!(bit_width <= 64);
        debug_assert!(bit_offset / 8 < self.storage.as_ref().len());
        debug_assert!((bit_offset + (bit_width as usize)) / 8 <= self.storage.as_ref().len());
        for i in 0..(bit_width as usize) {
            let mask = 1 << i;
            let val_bit_is_set = val & mask == mask;
            let index = if cfg!(target_endian = "big") {
                bit_width as usize - 1 - i
            } else {
                i
            };
            self.set_bit(index + bit_offset, val_bit_is_set);
        }
    }
}

pub const VMXNET3_BAR1_VRRS: u64 = 0;
pub const VMXNET3_BAR1_UVRS: u64 = 8;
pub const VMXNET3_BAR1_DSL: u64 = 16;
pub const VMXNET3_BAR1_DSH: u64 = 24;
pub const VMXNET3_BAR1_CMD: u64 = 32;
pub const VMXNET3_BAR1_MACL: u64 = 40;
pub const VMXNET3_BAR1_MACH: u64 = 48;
pub const VMXNET3_BAR1_INTR: u64 = 56;
pub const VMXNET3_BAR1_EVENT: u64 = 64;

pub const VMXNET3_CMD_ENABLE: u32 = 3405643776;
pub const VMXNET3_CMD_DISABLE: u32 = 3405643777;
pub const VMXNET3_CMD_RESET: u32 = 3405643778;
pub const VMXNET3_CMD_SET_RXMODE: u32 = 3405643779;
pub const VMXNET3_CMD_SET_FILTER: u32 = 3405643780;
pub const VMXNET3_CMD_VLAN_FILTER: u32 = 3405643781;
pub const VMXNET3_CMD_GET_STATUS: u32 = 4027383808;
pub const VMXNET3_CMD_GET_STATS: u32 = 4027383809;
pub const VMXNET3_CMD_GET_LINK: u32 = 4027383810;
pub const VMXNET3_CMD_GET_MACL: u32 = 4027383811;
pub const VMXNET3_CMD_GET_MACH: u32 = 4027383812;
pub const VMXNET3_CMD_GET_INTRCFG: u32 = 4027383816;

pub const VMXNET3_DMADESC_ALIGN: u32 = 128;
pub const VMXNET3_INIT_GEN: u32 = 1;

pub const VMXNET3_OM_NONE: u32 = 0;
pub const VMXNET3_OM_CSUM: u32 = 2;
pub const VMXNET3_OM_TSO: u32 = 3;

pub const VMXNET3_BTYPE_HEAD: u32 = 0;
pub const VMXNET3_BTYPE_BODY: u32 = 1;

pub const VMXNET3_RCD_RSS_TYPE_NONE: u32 = 0;
pub const VMXNET3_RCD_RSS_TYPE_IPV4: u32 = 1;
pub const VMXNET3_RCD_RSS_TYPE_TCPIPV4: u32 = 2;
pub const VMXNET3_RCD_RSS_TYPE_IPV6: u32 = 3;
pub const VMXNET3_RCD_RSS_TYPE_TCPIPV6: u32 = 4;

pub const VMXNET3_REV1_MAGIC: u32 = 3133079265;

pub const VMXNET3_GOS_UNKNOWN: u32 = 0;
pub const VMXNET3_GOS_LINUX: u32 = 4;
pub const VMXNET3_GOS_WINDOWS: u32 = 8;
pub const VMXNET3_GOS_SOLARIS: u32 = 12;
pub const VMXNET3_GOS_FREEBSD: u32 = 16;
pub const VMXNET3_GOS_PXE: u32 = 20;
pub const VMXNET3_GOS_32BIT: u32 = 1;
pub const VMXNET3_GOS_64BIT: u32 = 2;

pub const VMXNET3_MAX_TX_QUEUES: usize = 8;
pub const VMXNET3_MAX_RX_QUEUES: usize = 16;
pub const VMXNET3_MAX_INTRS: usize = 25;

pub const VMXNET3_ICTRL_DISABLE_ALL: u32 = 1;

pub const VMXNET3_RXMODE_UCAST: u32 = 1;
pub const VMXNET3_RXMODE_MCAST: u32 = 2;
pub const VMXNET3_RXMODE_BCAST: u32 = 4;
pub const VMXNET3_RXMODE_ALLMULTI: u32 = 8;
pub const VMXNET3_RXMODE_PROMISC: u32 = 16;

pub const VMXNET3_EVENT_RQERROR: u32 = 1;
pub const VMXNET3_EVENT_TQERROR: u32 = 2;
pub const VMXNET3_EVENT_LINK: u32 = 4;
pub const VMXNET3_EVENT_DIC: u32 = 8;
pub const VMXNET3_EVENT_DEBUG: u32 = 16;

pub const VMXNET3_MIN_MTU: u32 = 60;
pub const VMXNET3_MAX_MTU: u32 = 9000;

pub const VMXNET3_IMM_AUTO: u8 = 0;
pub const VMXNET3_IMM_ACTIVE: u8 = 1;
pub const VMXNET3_IMM_LAZY: u8 = 2;

pub const VMXNET3_IT_AUTO: u32 = 0;
pub const VMXNET3_IT_LEGACY: u32 = 1;
pub const VMXNET3_IT_MSI: u32 = 2;
pub const VMXNET3_IT_MSIX: u32 = 3;

pub const UPT1_RSS_HASH_TYPE_NONE: u32 = 0;
pub const UPT1_RSS_HASH_TYPE_IPV4: u32 = 1;
pub const UPT1_RSS_HASH_TYPE_TCP_IPV4: u32 = 2;
pub const UPT1_RSS_HASH_TYPE_IPV6: u32 = 4;
pub const UPT1_RSS_HASH_TYPE_TCP_IPV6: u32 = 8;
pub const UPT1_RSS_HASH_FUNC_NONE: u32 = 0;
pub const UPT1_RSS_HASH_FUNC_TOEPLITZ: u32 = 1;
pub const UPT1_RSS_MAX_KEY_SIZE: u32 = 40;
pub const UPT1_RSS_MAX_IND_TABLE_SIZE: u32 = 128;
pub const UPT1_IMOD_NONE: u8 = 0;
pub const UPT1_IMOD_HIGHEST: u8 = 7;
pub const UPT1_IMOD_ADAPTIVE: u8 = 8;
pub const UPT1_F_CSUM: u32 = 1;
pub const UPT1_F_RSS: u32 = 2;
pub const UPT1_F_VLAN: u32 = 4;
pub const UPT1_F_LRO: u32 = 8;

#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct UPT1_TxStats {
    pub tso_packets: u64,
    pub tso_bytes: u64,
    pub ucast_packets: u64,
    pub ucast_bytes: u64,
    pub mcast_packets: u64,
    pub mcast_bytes: u64,
    pub bcast_packets: u64,
    pub bcast_bytes: u64,
    pub error: u64,
    pub discard: u64,
}

#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct UPT1_RxStats {
    pub lro_packets: u64,
    pub lro_bytes: u64,
    pub ucast_packets: u64,
    pub ucast_bytes: u64,
    pub mcast_packets: u64,
    pub mcast_bytes: u64,
    pub bcast_packets: u64,
    pub bcast_bytes: u64,
    pub nobuffer: u64,
    pub error: u64,
}

#[repr(C, packed)]
#[derive(Default, Debug, Copy, Clone)]
pub struct vmxnet3_txdesc {
    pub addr: u64,
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 8usize]>,
}

impl vmxnet3_txdesc {
    #[inline]
    pub fn len(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(0usize, 14u8) as u32) }
    }
    #[inline]
    pub fn set_len(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(0usize, 14u8, val as u64)
        }
    }
    #[inline]
    pub fn gen(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(14usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_gen(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(14usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn pad1(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(15usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_pad1(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(15usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn dtype(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(16usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_dtype(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(16usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn pad2(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(17usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_pad2(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(17usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn offload_pos(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(18usize, 14u8) as u32) }
    }
    #[inline]
    pub fn set_offload_pos(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(18usize, 14u8, val as u64)
        }
    }
    #[inline]
    pub fn hlen(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(32usize, 10u8) as u32) }
    }
    #[inline]
    pub fn set_hlen(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(32usize, 10u8, val as u64)
        }
    }
    #[inline]
    pub fn offload_mode(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(42usize, 2u8) as u32) }
    }
    #[inline]
    pub fn set_offload_mode(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(42usize, 2u8, val as u64)
        }
    }
    #[inline]
    pub fn eop(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(44usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_eop(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(44usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn compreq(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(45usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_compreq(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(45usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn pad3(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(46usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_pad3(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(46usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn vtag_mode(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(47usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_vtag_mode(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(47usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn vtag(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(48usize, 16u8) as u32) }
    }
    #[inline]
    pub fn set_vtag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(48usize, 16u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        len: u32,
        gen: u32,
        pad1: u32,
        dtype: u32,
        pad2: u32,
        offload_pos: u32,
        hlen: u32,
        offload_mode: u32,
        eop: u32,
        compreq: u32,
        pad3: u32,
        vtag_mode: u32,
        vtag: u32,
    ) -> __BindgenBitfieldUnit<[u8; 8usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 8usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 14u8, {
            let len: u32 = unsafe { ::core::mem::transmute(len) };
            len as u64
        });
        __bindgen_bitfield_unit.set(14usize, 1u8, {
            let gen: u32 = unsafe { ::core::mem::transmute(gen) };
            gen as u64
        });
        __bindgen_bitfield_unit.set(15usize, 1u8, {
            let pad1: u32 = unsafe { ::core::mem::transmute(pad1) };
            pad1 as u64
        });
        __bindgen_bitfield_unit.set(16usize, 1u8, {
            let dtype: u32 = unsafe { ::core::mem::transmute(dtype) };
            dtype as u64
        });
        __bindgen_bitfield_unit.set(17usize, 1u8, {
            let pad2: u32 = unsafe { ::core::mem::transmute(pad2) };
            pad2 as u64
        });
        __bindgen_bitfield_unit.set(18usize, 14u8, {
            let offload_pos: u32 = unsafe { ::core::mem::transmute(offload_pos) };
            offload_pos as u64
        });
        __bindgen_bitfield_unit.set(32usize, 10u8, {
            let hlen: u32 = unsafe { ::core::mem::transmute(hlen) };
            hlen as u64
        });
        __bindgen_bitfield_unit.set(42usize, 2u8, {
            let offload_mode: u32 = unsafe { ::core::mem::transmute(offload_mode) };
            offload_mode as u64
        });
        __bindgen_bitfield_unit.set(44usize, 1u8, {
            let eop: u32 = unsafe { ::core::mem::transmute(eop) };
            eop as u64
        });
        __bindgen_bitfield_unit.set(45usize, 1u8, {
            let compreq: u32 = unsafe { ::core::mem::transmute(compreq) };
            compreq as u64
        });
        __bindgen_bitfield_unit.set(46usize, 1u8, {
            let pad3: u32 = unsafe { ::core::mem::transmute(pad3) };
            pad3 as u64
        });
        __bindgen_bitfield_unit.set(47usize, 1u8, {
            let vtag_mode: u32 = unsafe { ::core::mem::transmute(vtag_mode) };
            vtag_mode as u64
        });
        __bindgen_bitfield_unit.set(48usize, 16u8, {
            let vtag: u32 = unsafe { ::core::mem::transmute(vtag) };
            vtag as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C, packed)]
#[derive(Default, Copy, Clone)]
pub struct vmxnet3_txcompdesc {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 16usize]>,
}

impl core::fmt::Debug for vmxnet3_txcompdesc {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> Result<(), core::fmt::Error> {
        f.debug_struct("vmxnet3_txcompdesc")
            .field("eop_idx", &self.eop_idx())
            .field("type", &self.type_())
            .field("gen", &self.gen())
            .finish()
    }
}

impl vmxnet3_txcompdesc {
    #[inline]
    pub fn eop_idx(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(0usize, 12u8) as u32) }
    }
    #[inline]
    pub fn set_eop_idx(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(0usize, 12u8, val as u64)
        }
    }
    #[inline]
    pub fn pad1(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(12usize, 20u8) as u32) }
    }
    #[inline]
    pub fn set_pad1(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(12usize, 20u8, val as u64)
        }
    }
    #[inline]
    pub fn pad2(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(32usize, 32u8) as u32) }
    }
    #[inline]
    pub fn set_pad2(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(32usize, 32u8, val as u64)
        }
    }
    #[inline]
    pub fn pad3(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(64usize, 32u8) as u32) }
    }
    #[inline]
    pub fn set_pad3(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(64usize, 32u8, val as u64)
        }
    }
    #[inline]
    pub fn rsvd(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(96usize, 24u8) as u32) }
    }
    #[inline]
    pub fn set_rsvd(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(96usize, 24u8, val as u64)
        }
    }
    #[inline]
    pub fn type_(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(120usize, 7u8) as u32) }
    }
    #[inline]
    pub fn set_type(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(120usize, 7u8, val as u64)
        }
    }
    #[inline]
    pub fn gen(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(127usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_gen(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(127usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        eop_idx: u32,
        pad1: u32,
        pad2: u32,
        pad3: u32,
        rsvd: u32,
        type_: u32,
        gen: u32,
    ) -> __BindgenBitfieldUnit<[u8; 16usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 16usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 12u8, {
            let eop_idx: u32 = unsafe { ::core::mem::transmute(eop_idx) };
            eop_idx as u64
        });
        __bindgen_bitfield_unit.set(12usize, 20u8, {
            let pad1: u32 = unsafe { ::core::mem::transmute(pad1) };
            pad1 as u64
        });
        __bindgen_bitfield_unit.set(32usize, 32u8, {
            let pad2: u32 = unsafe { ::core::mem::transmute(pad2) };
            pad2 as u64
        });
        __bindgen_bitfield_unit.set(64usize, 32u8, {
            let pad3: u32 = unsafe { ::core::mem::transmute(pad3) };
            pad3 as u64
        });
        __bindgen_bitfield_unit.set(96usize, 24u8, {
            let rsvd: u32 = unsafe { ::core::mem::transmute(rsvd) };
            rsvd as u64
        });
        __bindgen_bitfield_unit.set(120usize, 7u8, {
            let type_: u32 = unsafe { ::core::mem::transmute(type_) };
            type_ as u64
        });
        __bindgen_bitfield_unit.set(127usize, 1u8, {
            let gen: u32 = unsafe { ::core::mem::transmute(gen) };
            gen as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C, packed)]
#[derive(Default, Copy, Clone)]
pub struct vmxnet3_rxdesc {
    pub addr: u64,
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 8usize]>,
}

impl core::fmt::Debug for vmxnet3_rxdesc {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> Result<(), core::fmt::Error> {
        let addr = self.addr;
        f.debug_struct("vmxnet3_rxdesc")
            .field("addr", &format_args!("{:#x}", addr))
            .field("len", &self.len())
            .field("btype", &self.btype())
            .field("gen", &self.gen())
            .finish()
    }
}

impl vmxnet3_rxdesc {
    #[inline]
    pub fn len(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(0usize, 14u8) as u32) }
    }
    #[inline]
    pub fn set_len(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(0usize, 14u8, val as u64)
        }
    }
    #[inline]
    pub fn btype(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(14usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_btype(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(14usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn dtype(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(15usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_dtype(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(15usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn rsvd(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(16usize, 15u8) as u32) }
    }
    #[inline]
    pub fn set_rsvd(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(16usize, 15u8, val as u64)
        }
    }
    #[inline]
    pub fn gen(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(31usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_gen(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(31usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn pad1(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(32usize, 32u8) as u32) }
    }
    #[inline]
    pub fn set_pad1(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(32usize, 32u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        len: u32,
        btype: u32,
        dtype: u32,
        rsvd: u32,
        gen: u32,
        pad1: u32,
    ) -> __BindgenBitfieldUnit<[u8; 8usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 8usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 14u8, {
            let len: u32 = unsafe { ::core::mem::transmute(len) };
            len as u64
        });
        __bindgen_bitfield_unit.set(14usize, 1u8, {
            let btype: u32 = unsafe { ::core::mem::transmute(btype) };
            btype as u64
        });
        __bindgen_bitfield_unit.set(15usize, 1u8, {
            let dtype: u32 = unsafe { ::core::mem::transmute(dtype) };
            dtype as u64
        });
        __bindgen_bitfield_unit.set(16usize, 15u8, {
            let rsvd: u32 = unsafe { ::core::mem::transmute(rsvd) };
            rsvd as u64
        });
        __bindgen_bitfield_unit.set(31usize, 1u8, {
            let gen: u32 = unsafe { ::core::mem::transmute(gen) };
            gen as u64
        });
        __bindgen_bitfield_unit.set(32usize, 32u8, {
            let pad1: u32 = unsafe { ::core::mem::transmute(pad1) };
            pad1 as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C, packed)]
#[derive(Default, Copy, Clone)]
pub struct vmxnet3_rxcompdesc {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 16usize]>,
}

impl core::fmt::Debug for vmxnet3_rxcompdesc {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> Result<(), core::fmt::Error> {
        f.debug_struct("vmxnet3_rxcompdesc")
            .field("rxd_idx", &self.rxd_idx())
            .field("eop", &self.eop())
            .field("sop", &self.sop())
            .field("qid", &self.qid())
            .field("rss_type", &self.rss_type())
            .field("no_csum", &self.no_csum())
            .field("rss_hash", &self.rss_hash())
            .field("len", &self.len())
            .field("error", &self.error())
            .field("vlan", &self.vlan())
            .field("vtag", &self.vtag())
            .field("csum", &self.csum())
            .field("csum_ok", &self.csum_ok())
            .field("udp", &self.udp())
            .field("tcp", &self.tcp())
            .field("ipcsum_ok", &self.ipcsum_ok())
            .field("ipv6", &self.ipv6())
            .field("ipv4", &self.ipv4())
            .field("fragment", &self.fragment())
            .field("fcs", &self.fcs())
            .field("type", &self.type_())
            .field("gen", &self.gen())
            .finish()
    }
}

impl vmxnet3_rxcompdesc {
    #[inline]
    pub fn rxd_idx(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(0usize, 12u8) as u32) }
    }
    #[inline]
    pub fn set_rxd_idx(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(0usize, 12u8, val as u64)
        }
    }
    #[inline]
    pub fn pad1(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(12usize, 2u8) as u32) }
    }
    #[inline]
    pub fn set_pad1(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(12usize, 2u8, val as u64)
        }
    }
    #[inline]
    pub fn eop(&self) -> bool {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(14usize, 1u8) != 0) }
    }
    #[inline]
    pub fn set_eop(&mut self, val: bool) {
        self._bitfield_1.set(14usize, 1u8, val as u64)
    }
    #[inline]
    pub fn sop(&self) -> bool {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(15usize, 1u8) != 0) }
    }
    #[inline]
    pub fn set_sop(&mut self, val: bool) {
        self._bitfield_1.set(15usize, 1u8, val as u64)
    }
    #[inline]
    pub fn qid(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(16usize, 10u8) as u32) }
    }
    #[inline]
    pub fn set_qid(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(16usize, 10u8, val as u64)
        }
    }
    #[inline]
    pub fn rss_type(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(26usize, 4u8) as u32) }
    }
    #[inline]
    pub fn set_rss_type(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(26usize, 4u8, val as u64)
        }
    }
    #[inline]
    pub fn no_csum(&self) -> bool {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(30usize, 1u8) != 0) }
    }
    #[inline]
    pub fn set_no_csum(&mut self, val: bool) {
        self._bitfield_1.set(30usize, 1u8, val as u64)
    }
    #[inline]
    pub fn pad2(&self) -> bool {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(31usize, 1u8) != 0) }
    }
    #[inline]
    pub fn set_pad2(&mut self, val: bool) {
        self._bitfield_1.set(31usize, 1u8, val as u64)
    }
    #[inline]
    pub fn rss_hash(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(32usize, 32u8) as u32) }
    }
    #[inline]
    pub fn set_rss_hash(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(32usize, 32u8, val as u64)
        }
    }
    #[inline]
    pub fn len(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(64usize, 14u8) as u32) }
    }
    #[inline]
    pub fn set_len(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(64usize, 14u8, val as u64)
        }
    }
    #[inline]
    pub fn error(&self) -> bool {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(78usize, 1u8) != 0) }
    }
    #[inline]
    pub fn set_error(&mut self, val: bool) {
        self._bitfield_1.set(78usize, 1u8, val as u64)
    }
    #[inline]
    pub fn vlan(&self) -> bool {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(79usize, 1u8) != 0) }
    }
    #[inline]
    pub fn set_vlan(&mut self, val: bool) {
        self._bitfield_1.set(79usize, 1u8, val as u64)
    }
    #[inline]
    pub fn vtag(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(80usize, 16u8) as u32) }
    }
    #[inline]
    pub fn set_vtag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(80usize, 16u8, val as u64)
        }
    }
    #[inline]
    pub fn csum(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(96usize, 16u8) as u32) }
    }
    #[inline]
    pub fn set_csum(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(96usize, 16u8, val as u64)
        }
    }
    #[inline]
    pub fn csum_ok(&self) -> bool {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(112usize, 1u8) != 0) }
    }
    #[inline]
    pub fn set_csum_ok(&mut self, val: bool) {
        self._bitfield_1.set(112usize, 1u8, val as u64)
    }
    #[inline]
    pub fn udp(&self) -> bool {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(113usize, 1u8) != 0) }
    }
    #[inline]
    pub fn set_udp(&mut self, val: bool) {
        self._bitfield_1.set(113usize, 1u8, val as u64)
    }
    #[inline]
    pub fn tcp(&self) -> bool {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(114usize, 1u8) != 0) }
    }
    #[inline]
    pub fn set_tcp(&mut self, val: bool) {
        self._bitfield_1.set(114usize, 1u8, val as u64)
    }
    #[inline]
    pub fn ipcsum_ok(&self) -> bool {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(115usize, 1u8) != 0) }
    }
    #[inline]
    pub fn set_ipcsum_ok(&mut self, val: bool) {
        self._bitfield_1.set(115usize, 1u8, val as u64)
    }
    #[inline]
    pub fn ipv6(&self) -> bool {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(116usize, 1u8) != 0) }
    }
    #[inline]
    pub fn set_ipv6(&mut self, val: bool) {
        self._bitfield_1.set(116usize, 1u8, val as u64)
    }
    #[inline]
    pub fn ipv4(&self) -> bool {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(117usize, 1u8) != 0) }
    }
    #[inline]
    pub fn set_ipv4(&mut self, val: bool) {
        self._bitfield_1.set(117usize, 1u8, val as u64)
    }
    #[inline]
    pub fn fragment(&self) -> bool {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(118usize, 1u8) != 0) }
    }
    #[inline]
    pub fn set_fragment(&mut self, val: bool) {
        self._bitfield_1.set(118usize, 1u8, val as u64)
    }
    #[inline]
    pub fn fcs(&self) -> bool {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(119usize, 1u8) != 0) }
    }
    #[inline]
    pub fn set_fcs(&mut self, val: bool) {
        self._bitfield_1.set(119usize, 1u8, val as u64)
    }
    #[inline]
    pub fn type_(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(120usize, 7u8) as u32) }
    }
    #[inline]
    pub fn set_type(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(120usize, 7u8, val as u64)
        }
    }
    #[inline]
    pub fn gen(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(127usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_gen(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(127usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        rxd_idx: u32,
        pad1: u32,
        eop: u32,
        sop: u32,
        qid: u32,
        rss_type: u32,
        no_csum: u32,
        pad2: u32,
        rss_hash: u32,
        len: u32,
        error: u32,
        vlan: u32,
        vtag: u32,
        csum: u32,
        csum_ok: u32,
        udp: u32,
        tcp: u32,
        ipcsum_ok: u32,
        ipv6: u32,
        ipv4: u32,
        fragment: u32,
        fcs: u32,
        type_: u32,
        gen: u32,
    ) -> __BindgenBitfieldUnit<[u8; 16usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 16usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 12u8, {
            let rxd_idx: u32 = unsafe { ::core::mem::transmute(rxd_idx) };
            rxd_idx as u64
        });
        __bindgen_bitfield_unit.set(12usize, 2u8, {
            let pad1: u32 = unsafe { ::core::mem::transmute(pad1) };
            pad1 as u64
        });
        __bindgen_bitfield_unit.set(14usize, 1u8, {
            let eop: u32 = unsafe { ::core::mem::transmute(eop) };
            eop as u64
        });
        __bindgen_bitfield_unit.set(15usize, 1u8, {
            let sop: u32 = unsafe { ::core::mem::transmute(sop) };
            sop as u64
        });
        __bindgen_bitfield_unit.set(16usize, 10u8, {
            let qid: u32 = unsafe { ::core::mem::transmute(qid) };
            qid as u64
        });
        __bindgen_bitfield_unit.set(26usize, 4u8, {
            let rss_type: u32 = unsafe { ::core::mem::transmute(rss_type) };
            rss_type as u64
        });
        __bindgen_bitfield_unit.set(30usize, 1u8, {
            let no_csum: u32 = unsafe { ::core::mem::transmute(no_csum) };
            no_csum as u64
        });
        __bindgen_bitfield_unit.set(31usize, 1u8, {
            let pad2: u32 = unsafe { ::core::mem::transmute(pad2) };
            pad2 as u64
        });
        __bindgen_bitfield_unit.set(32usize, 32u8, {
            let rss_hash: u32 = unsafe { ::core::mem::transmute(rss_hash) };
            rss_hash as u64
        });
        __bindgen_bitfield_unit.set(64usize, 14u8, {
            let len: u32 = unsafe { ::core::mem::transmute(len) };
            len as u64
        });
        __bindgen_bitfield_unit.set(78usize, 1u8, {
            let error: u32 = unsafe { ::core::mem::transmute(error) };
            error as u64
        });
        __bindgen_bitfield_unit.set(79usize, 1u8, {
            let vlan: u32 = unsafe { ::core::mem::transmute(vlan) };
            vlan as u64
        });
        __bindgen_bitfield_unit.set(80usize, 16u8, {
            let vtag: u32 = unsafe { ::core::mem::transmute(vtag) };
            vtag as u64
        });
        __bindgen_bitfield_unit.set(96usize, 16u8, {
            let csum: u32 = unsafe { ::core::mem::transmute(csum) };
            csum as u64
        });
        __bindgen_bitfield_unit.set(112usize, 1u8, {
            let csum_ok: u32 = unsafe { ::core::mem::transmute(csum_ok) };
            csum_ok as u64
        });
        __bindgen_bitfield_unit.set(113usize, 1u8, {
            let udp: u32 = unsafe { ::core::mem::transmute(udp) };
            udp as u64
        });
        __bindgen_bitfield_unit.set(114usize, 1u8, {
            let tcp: u32 = unsafe { ::core::mem::transmute(tcp) };
            tcp as u64
        });
        __bindgen_bitfield_unit.set(115usize, 1u8, {
            let ipcsum_ok: u32 = unsafe { ::core::mem::transmute(ipcsum_ok) };
            ipcsum_ok as u64
        });
        __bindgen_bitfield_unit.set(116usize, 1u8, {
            let ipv6: u32 = unsafe { ::core::mem::transmute(ipv6) };
            ipv6 as u64
        });
        __bindgen_bitfield_unit.set(117usize, 1u8, {
            let ipv4: u32 = unsafe { ::core::mem::transmute(ipv4) };
            ipv4 as u64
        });
        __bindgen_bitfield_unit.set(118usize, 1u8, {
            let fragment: u32 = unsafe { ::core::mem::transmute(fragment) };
            fragment as u64
        });
        __bindgen_bitfield_unit.set(119usize, 1u8, {
            let fcs: u32 = unsafe { ::core::mem::transmute(fcs) };
            fcs as u64
        });
        __bindgen_bitfield_unit.set(120usize, 7u8, {
            let type_: u32 = unsafe { ::core::mem::transmute(type_) };
            type_ as u64
        });
        __bindgen_bitfield_unit.set(127usize, 1u8, {
            let gen: u32 = unsafe { ::core::mem::transmute(gen) };
            gen as u64
        });
        __bindgen_bitfield_unit
    }
}
///vmxnet3_driver_shared
#[repr(C, packed)]
pub struct DriverShared {
    pub magic: u32,
    pub pad1: u32,
    pub version: u32,
    pub guest: u32,
    pub vmxnet3_revision: u32,
    pub upt_version: u32,
    pub upt_features: u64,
    pub driver_data: u64,
    pub queue_shared: u64,
    pub driver_data_len: u32,
    pub queue_shared_len: u32,
    pub mtu: u32,
    pub nrxsg_max: u16,
    pub ntxqueue: u8,
    pub nrxqueue: u8,
    pub reserved1: [u32; 4usize],
    pub automask: u8,
    pub nintr: u8,
    pub evintr: u8,
    pub modlevel: [u8; 25usize],
    pub ictrl: u32,
    pub reserved2: [u32; 2usize],
    pub rxmode: u32,
    pub mcast_tablelen: u16,
    pub pad2: u16,
    pub mcast_table: u64,
    pub vlan_filter: [u32; 128usize],
    pub rss: vmxnet3_driver_shared__bindgen_ty_1,
    pub pm: vmxnet3_driver_shared__bindgen_ty_1,
    pub plugin: vmxnet3_driver_shared__bindgen_ty_1,
    pub event: u32,
    pub reserved3: [u32; 5usize],
}

impl DriverShared {
    pub(crate) fn new(nintr: u8, evintr: u8, queue_shared: u64, queue_shared_len: u32) -> Self {
        let mut ds = DriverShared {
            magic: VMXNET3_REV1_MAGIC,
            pad1: 0,
            version: crate::var::VMXNET3_DRIVER_VERSION,
            guest: VMXNET3_GOS_FREEBSD | VMXNET3_GOS_64BIT,
            vmxnet3_revision: 1,
            upt_version: 1,
            upt_features: 0,
            driver_data: 0, // Set through `set_driver_data`
            queue_shared,
            driver_data_len: 0, // Set through `set_driver_data`
            queue_shared_len,
            mtu: 0,       // TODO
            nrxsg_max: 0, // TODO
            ntxqueue: 0,  // TODO
            nrxqueue: 0,  // TODO
            reserved1: [0; 4usize],
            automask: 1,
            nintr,
            evintr,
            modlevel: [0; 25usize], // See belows
            ictrl: VMXNET3_ICTRL_DISABLE_ALL,
            reserved2: [0; 2usize],
            rxmode: VMXNET3_RXMODE_UCAST | VMXNET3_RXMODE_BCAST, // TODO: More?
            mcast_tablelen: 0,                                   // TODO: ?
            pad2: 0,
            mcast_table: 0, // TODO: ?
            vlan_filter: [0; 128usize],
            rss: Default::default(), // TODO: ?
            pm: Default::default(),
            plugin: Default::default(),
            event: 0,
            reserved3: [0; 5usize],
        };

        for i in 0..nintr {
            ds.modlevel[i as usize] = UPT1_IMOD_ADAPTIVE;
        }

        ds
    }

    pub(crate) fn set_driver_data(&mut self, paddr: PAddr) {
        use crate::vmx::VMXNet3;
        self.driver_data = paddr.into();
        self.driver_data_len = core::mem::size_of::<VMXNet3>().try_into().unwrap();
    }
}

#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct vmxnet3_driver_shared__bindgen_ty_1 {
    pub version: u32,
    pub len: u32,
    pub paddr: u64,
}

impl DmaObject for DriverShared {}

#[repr(C, packed)]
#[derive(Copy, Clone)]
pub struct vmxnet3_txq_shared {
    pub npending: u32,
    pub intr_threshold: u32,
    pub reserved1: u64,
    pub cmd_ring: u64,
    pub data_ring: u64,
    pub comp_ring: u64,
    pub driver_data: u64,
    pub reserved2: u64,
    pub cmd_ring_len: u32,
    pub data_ring_len: u32,
    pub comp_ring_len: u32,
    pub driver_data_len: u32,
    pub intr_idx: u8,
    pub pad1: [u8; 7usize],
    pub stopped: u8,
    pub pad2: [u8; 3usize],
    pub error: u32,
    pub stats: UPT1_TxStats,
    pub pad3: [u8; 88usize],
}

#[repr(C, packed)]
#[derive(Copy, Clone)]
pub struct vmxnet3_rxq_shared {
    pub update_rxhead: u8,
    pub pad1: [u8; 7usize],
    pub reserved1: u64,
    pub cmd_ring: [u64; 2usize],
    pub comp_ring: u64,
    pub driver_data: u64,
    pub reserved2: u64,
    pub cmd_ring_len: [u32; 2usize],
    pub comp_ring_len: u32,
    pub driver_data_len: u32,
    pub intr_idx: u8,
    pub pad2: [u8; 7usize],
    pub stopped: u8,
    pub pad3: [u8; 3usize],
    pub error: u32,
    pub stats: UPT1_RxStats,
    pub pad4: [u8; 88usize],
}

#[repr(C, packed)]
#[derive(Copy, Clone)]
pub struct vmxnet3_rss_shared {
    pub hash_type: u16,
    pub hash_func: u16,
    pub hash_key_size: u16,
    pub ind_table_size: u16,
    pub hash_key: [u8; 40usize],
    pub ind_table: [u8; 128usize],
}
