I've published two new video tutorials on [my YouTube channel](https://www.youtube.com/channel/UC1XihgHdkNOQd5IBHnIZWbA).
The videos introduce a new series: **"Dive into C++14"**.

Like the previous series, dedicated to the C++11 standard, **"Dive into C++14"** will show the convenience and power of the latest standard (C++14) through videos regarding various topics.

The format of the videos is what makes **"Dive into C++11"** and **"Dive into C++14"** different from other tutorials: well-commented and well-formatted independently compilable chronologically sequential code segments will show the audience the thought process behind writing modern C++14 code. 

**Dive into C++14 - [1] - Introduction to C++14 core language features**
</br>[Watch on YouTube](https://www.youtube.com/watch?v=WZYKzCsACiw)

The first video is a brief introduction to some of my favorite new C++14 core language features.
The target audience is newcomers to the C++14 standard who already have some experience with C++11.

**Dive into C++14 - [2] - `for_each_argument` explained and expanded**
</br>[Watch on YouTube](https://www.youtube.com/watch?v=Za92Tz_g0zQ)

The second video covers a very interesting code snippet originally posted on Twitter by Sean Parent: `for_each_argument`.

It shows and explains the usage of C++14 compile-time integer sequences, and analyzes a very interesting iterative implementation of an alternative version of Sean's function that takes the desired arity as a template parameter.

Feel free to fork/analyze/improve the source code on [my GitHub page](https://github.com/SuperV1234/Tutorials). 
You can find previous episodes here: [Playlist](https://www.youtube.com/playlist?list=PLTEcWGdSiQenl4YRPvSqW7UPC6SiGNN7e)

