After adding [discount](http://www.pell.portland.or.us/~orc/Code/discount/) to [my static website generator](https://github.com/SuperV1234/WEBVittorioRomeo2), I was unsatisfied with the C code introduced in my project:

	extern "C" 
	{
		#include <mkdio.h>
	}

	// ...

	FILE* f1 = fopen(mdPath.c_str(), "r");
	FILE* f2 = fopen(mdResPath.c_str(), "w");
	MMIOT* in = mkd_in(f1, 0);
	markdown(in, f2, 0);
	fclose(f1);
	fclose(f2);


I looked for alternatives, but I couldn't find any native C++ Markdown library or any C++ wrapper for C Markdown libaries.
So I decided to create a [C++11 wrapper for discount, called DiscountCpp](https://github.com/SuperV1234/DiscountCpp). It currently implements very few functions from Discount, but offers a very easy-to-use interface to quickly convert Markdown to HTML.

The updated code looks like this:

	#include <DiscountCpp/DiscountCpp.h>

	// ...

	discountcpp::getHTMLFromMarkdownFile(mdPath);

*Now I can sleep in peace.*

P.S.: I also implemented syntax highlighting on the site thanks to [highlight.js](http://softwaremaniacs.org/soft/highlight/en/).

