Developer's Codex
===================

A web developer / designer's life can be difficult.  It's hard to find the right tools, images, tutorials...etc.  I hope this collection of links will help make things a little bit easier for you.

 > “The three great essentials to achieve anything worth while are: Hard work, Stick-to-itiveness, and Common sense.” - Thomas A. Edison



Contribute
----------

Have a helpful link to share?  Suggestions? See any mistakes or a broken link? Send a pull request!



Inspiration
-----------
*Resources for when you need some inspiration*

#### Websites to give some ideas / inspiration
 * [AWWWARDS](http://www.awwwards.com/) - collection of great sites
 * [HTTPster](http://httpster.net/) - another collection of great sites
 * [TheBestDesigns](https://www.thebestdesigns.com/) - showcase of beautiful sites
 * [CSS Winner](http://www.csswinner.com/) - list of reviewed designs
 * [Site Inspire](https://www.siteinspire.com/) - site of fresh sites
 * [OnePageLove](https://onepagelove.com/) - Great designs for one page websites
 * [CSS Design Awards](http://www.cssdesignawards.com/) - beautiful site in and of itself. this site contains a list of award-worthy designs as well as a site-of-the-day.
 * [Dribble](https://dribbble.com/) - a place for designers to show off their work
 *  [CSS Awards](https://www.cssawards.net/) - another showcase of reviewed website designs

#### Code Snippets
 * [CodePen](http://codepen.io/) - playground for inspiration and snippets
 * [CodeMyUI](https://codemyui.com/) - code snippets + tutorials!
 * [CodyHouse](https://codyhouse.co/) - HTML, CSS, JS nuggets
 * [CodePad.Co](https://codepad.co/) - a place for developers to share & save code snippets



Assets
------
*Collection of images, icons, fonts ..etc to really make your sites pop*

#### Images
 * [Picjumbo](https://picjumbo.com/) - free stock photos
 * [Unsplash](http://unsplash.com/) - more free stock photos!
 * [New Old Stock](http://nos.twnsnd.co/) - free vintage photos - lots of sepia
 * [The Pattern Library](http://thepatternlibrary.com/) - collection of fun backgrounds
 * [Subtle Patterns](http://subtlepatterns.com/) - site of free, subtle backgrounds
 * [Death To Stock Photos](http://join.deathtothestockphoto.com/) - monthly photos emailed to you
 * [Placehold](http://placehold.it/) - generate placeholder images for your site
 * [WOCinTech Chat](http://www.wocintechchat.com/) - free stock photos representing women and non-binary people of color
 * [placekitten](https://placekitten.com/) - kitten-themed placeholder images for developers


#### Icons
 * [Font Awesome](http://fontawesome.io/) - awesome library of icons
 * [Flaticon](http://www.flaticon.com/) - huge collection of free icons: PNG, SVG, EPS, PSD formats
 * [Ionic Icons](http://ionicons.com/) - clean, ionic icons
 * [Simple Icons](https://simpleicons.org/) - svg icons for popular brands. Maintained by Dan Leech.
 * [The Noun Project](https://thenounproject.com/) - another plethora of great icons
 * [Feather Icons](https://feathericons.com/) - open-source collection of beautiul icons 

#### Fonts
 * [Google Fonts](https://www.google.com/fonts) - probably the most popular place to find fonts
   * Google fonts now has a newer, cleaner UI for their font library: [google fonts 2.0](https://fonts.google.com/)



Tools
-----
*Useful tools to aid in development*

#### Tools for color
 * [ColorPicker](https://chrome.google.com/webstore/detail/colorpick-eyedropper/ohcpnigalekghcmgcdcenkpelffpdolg?hl=en) - a very handy chrome extension for grabbing colors on a page
 * [ColorZilla](https://chrome.google.com/webstore/detail/colorzilla/bhlhnicpbhignbdhedgjhgdocnmhomnp?hl=en) - another handy color tool (avaiable for firefox too)
 * [CSS3Gen](http://css3gen.com/gradient-generator/) - an excellent, easy to use gradient generator
 * [Spectral](http://jxnblk.com/Spectral/) - create a color swatch


#### Tools for front end scaffolding / 'bootstrapping'
 * [Bootstrap](http://getbootstrap.com/) - popular framework for designing responsive sites and applications
 * [Bootswatch](https://bootswatch.com/) - nice themes to spice up bootstrap's look  
 * [StartBootstrap](http://startbootstrap.com/) - free open-source bootstrap themes
 * [Foundation](http://foundation.zurb.com/) - another popular framework for web development
 * [Bulma](http://bulma.io/) - A modern CSS framework based on Flexbox
 * [Skeleton](http://getskeleton.com/) - a clean, bareboned (pun intended), responsive css boilerplate
 * [Unsemantic](http://unsemantic.com/) - a simple, fluid-grid system
 * [FlatUI](http://designmodo.github.io/Flat-UI/) - a very sexy HTML and CSS framework for a flat design
 * [Materialize](http://materializecss.com/) - a modern front-end framework inspired by Google's Material design
 * [Tachyons](http://tachyons.io/) - create fast, 100% responsive apps with very little CSS
 * [Colormind](http://colormind.io/bootstrap/) - generate a color pallete for your project using ML - very cool


#### Workflow and build tools - to make your life easier
 * [Gulp](http://gulpjs.com/) - a task runner to automate those tedious, repetitive tasks
 * [Grunt](http://gruntjs.com/) - another popular task runner
 * [Webpack](https://webpack.github.io/) - a modular bundler for bundling code into convenient chunks
 * [Yeoman](http://yeoman.io/) - a scaffolding tool for building modern web apps



Collaborate
-----------
*Useful tools to allow for collaboration*

* [Cloud9](https://c9.io/) - code and work with others in the cloud
* [JSfiddle](https://jsfiddle.net/) - JS fiddle offers a really cool collab feature, though I haven't used too often
* [CodePen](http://codepen.io/) - codepen also offers a collaboration option (though I believe it's for pro users atm)
* [Gist](https://gist.github.com/) - share code fast. acts like a notepad for code
* [Slack](https://slack.com/) - collaborators need to communicate fast. slack seems to be the most popular chatting app amongst dev teams



Great Reading Material
----------------------
*Great reading resources to keep up with the latest trends/news*

* [A List Apart](http://alistapart.com/) - insightful and informative dev articles
* [Medium](https://medium.com/) - a blog platform with every topic imaginable. To refine your search, just type in your query into the search bar
* [CSS Tricks](https://css-tricks.com/) - a great blog/tutorial for just about anything code related.
* [Smashing Magazine](https://www.smashingmagazine.com/) - site filled with useful dev and design articles
* [Front End Developer Weekly](http://frontenddevweekly.com/) - front-end dev news, tools ..etc emailed to you weekly


License
-------

![CO Logo](http://i.creativecommons.org/p/zero/1.0/88x31.png)

I, [Vinny Aceto](https://github.com/vinnya3), waive all copyright-protected and related interests included in this project
