unit Fonetiza.Intf;

interface

type
  IFonetiza = interface
    ['{B906D0E0-1BD1-4D90-BB17-39FE665DBD7C}']
    /// <summary>
    ///   Gerar contedo fontico
    /// </summary>
    /// <param name="AValue">
    ///   Contedo que ser processado para gerao fontica
    /// </param>
    /// <returns>
    ///   Retorna o contedo fontico
    /// </returns>
    function Fonetizar(const AValue: string): string;
    /// <summary>
    ///   Gerar cdigo fontico
    /// </summary>
    /// <para>
    ///   Contedo que ser processado para gerao do cdigo fontico
    /// </para>
    /// <returns>
    ///   Retorna um cdigo fontico
    /// </returns>
    function GerarCodigoFonetico(const AValue: string): string;
    /// <summary>
    ///   Gerar lista de cdigos fonticos
    /// </summary>
    /// <param name="AValue">
    ///   Contedo que ser processado para gerao dos cdigos fonticos
    /// </param>
    /// <returns>
    ///   Retorna uma lista dos cdigos fonticos
    /// </returns>
    function GerarListaCodigosFoneticos(const AValue: string): TArray<string>;
  end;

implementation

end.
