# [Ciapre](https://github.com/vinhnx/Ciapre.tmTheme) #

Ciapre - an easy on the eyes Sublime Text/TextMate color scheme.

+ https://github.com/vinhnx/Ciapre.tmTheme
+ https://packagecontrol.io/packages/Ciapre%20Color%20Scheme

🎨 Check out my [Ciapre theme suite](https://github.com/vinhnx/Ciapre) 👈

##### *Installation* #####

Just search for `Ciapre` in Sublime Text's [Package Control Manager](https://sublime.wbond.net/installation) & install it.

Then, in menu bar, browse to `Preferences > Color Scheme` and choose your desired one!

## Comes with two different colors  ##

##### :star: Dark
![Ciapre Black](https://raw.githubusercontent.com/vinhnx/Ciapre.tmTheme/master/screenshot/ciapredark.png)

  * [Color Pallete](https://kuler.adobe.com/Ciapre-dark-color-theme-2695140/)
`#D9487D #262626 #BFB38F #D99A4E #BF4545`
![ciapredark-pallete](https://f.cloud.github.com/assets/1097578/781886/ccdefca4-ea2f-11e2-9740-d20b201f27aa.PNG)


##### :star: Blue
![Ciapre](https://raw.githubusercontent.com/vinhnx/Ciapre.tmTheme/master/screenshot/ciapreblue.png)

  * [Pallete](https://kuler.adobe.com/Ciapre-blue-color-theme-2695141/)
`#D9487D #383B73 #171C26 #BFB38F #A63333`
![ciapreblue-theme](https://f.cloud.github.com/assets/1097578/781904/5091bae6-ea30-11e2-9f7d-2b99f6de5160.PNG)

*sample code from jQuery source*

## Credit ##


+ [MOON: Color](https://kuler.adobe.com/#themeID/2320307)

##### *Tips* #####
--

* Great companion [Aqua](https://github.com/cafarm/aqua-theme) theme - Prokit.
   * There is also a better fork of it -> [Refined](https://github.com/danro/refined-theme).
* Font used `Consolas` - comes with Windows, but alternatively, the open-sourced [Inconsolata](http://www.levien.com/type/myfonts/inconsolata.html) is pretty close to it
   * For more programming fonts, visit [http://slant.co/topics/67/~what-are-the-best-programming-fonts](http://slant.co/topics/67/~what-are-the-best-programming-fonts).

## SublimeText 3 ##

Tested on ST3. 

It's just some HEX strings within messy XML, so no problem found. :)

**NOTE on SublimeText 3 build 3143**

Press `COMMAND+D` to open preferences editor

insert or modify "color_scheme" property to point to the installed Ciapre package

```xml
"color_scheme": "Packages/Ciapre Color Scheme/Ciapre.tmTheme"
```

If the theme is not found or not working, open this folder and check if it exists.

`~/Library/Application Support/Sublime Text 3/Packages/Ciapre Color Scheme`

If it doesn't exist, please try to install from Package Control and try again.

## Contribution ##

Contributton are very welcome. If you come across to port to another platform based on the color pallete above, please consider sending me a Pull Request.

Thank you!

# Ciapre on Other Platforms #

+ [CotEditor themes by Naotaka Morimoto](http://www.naotaka.com/coteditorthemes/#Vinh-Nguyen)
+ [Ciapre for emacs](https://github.com/emacsfodder/tmtheme-to-emacs/blob/master/generatedThemes/ciapre-theme.el)
+ [Ciapre for Jetbrains (IDEA) and iTerm2](https://github.com/zdj/themes#ciapreitermcolors)
+ [Red Planet - A Sublime Text 2 color scheme based off of the "Ciapre Dark" theme with slight mods.](https://github.com/eliquious/Red-Planet-Theme)
+ [My own Xcode theme](https://github.com/vinhnx/Ciapre-Xcode-theme)
+ [Ciapre theme for Visual Studio Code](https://marketplace.visualstudio.com/items?itemName=konart.ciapre) :rocket:
+ [macOS Terminal theme](https://github.com/lysyi3m/macos-terminal-themes#ciapre)

Thanks all for your works! :beer:

## What's With The Name? ##

Just random, really!

## Patreon ##

I also have a Patreon in case you want to support my work. Thank you in advance!

https://www.patreon.com/vinhnx

## Footnote ##

I really really love this theme, I was just a stoke in inspriration a long while ago. So please help me spread this to the world if you like this theme. Thank you!
