# Contributing to MOROS

First off, thanks for taking the time to contribute! ❤️

And if you like the project, but just don't have time to contribute, that's
fine. There are other easy ways to support the project and show your
appreciation, which we would also be very happy about:

- Star the project on GitHub ✨
- Talk about it on social media
- Mention the project at local meetups and tell your friends/colleagues

## Did you find a bug?

- Ensure the bug was not already reported by searching on GitHub under
  [Issues][1]
- If you're unable to find an open issue addressing the problem,
  [open a new one][2]
- Include a **title and clear description**, as much relevant information as
  possible to reproduce it

## Did you write a patch that fixes a bug?

- Open a new GitHub pull request with the patch
- Ensure the PR description clearly describes the problem and solution
- Include the relevant issue number if applicable

## Do you intend to add a new feature or change an existing one?

- Suggest your idea by [creating a new discussion][3]
- Please note that MOROS is a personal hobby project aimed at developing a
  simple operating system that can fit in one standard human brain, while also
  encouraging others to do the same. Forking is encouraged!
- You might instead prefer to collaborate on a project with a broader scope such
  as [Redox](https://www.redox-os.org/) or [Serenity](https://serenityos.org/)

## Do you have questions about the project?

- Ask any question about how to use MOROS by [creating a new discussion][4]

  [1]: https://github.com/vinc/moros/issues
  [2]: https://github.com/vinc/moros/issues/new
  [3]: https://github.com/vinc/moros/discussions/new?category=ideas
  [4]: https://github.com/vinc/moros/discussions/new?category=q-a
